/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import java.io.IOException;
import java.util.Enumeration;

public class LDAPDITStructureRuleSchema
extends LDAPSchemaElement {
    private int ruleID = 0;
    private String nameForm = "";
    private String[] superiorIDs = new String[]{""};

    public LDAPDITStructureRuleSchema(String[] stringArray, int n, String string, boolean bl, String string2, String[] stringArray2) {
        super(LDAPSchema.schemaTypeNames[5]);
        this.names = (String[])stringArray.clone();
        this.ruleID = n;
        this.description = string;
        this.obsolete = bl;
        this.nameForm = string2;
        this.superiorIDs = stringArray2;
        super.setValue(this.formatString());
    }

    public LDAPDITStructureRuleSchema(String string) {
        super(LDAPSchema.schemaTypeNames[5]);
        this.obsolete = false;
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            if (schemaParser.getNames() != null) {
                this.names = (String[])schemaParser.getNames().clone();
            }
            if (schemaParser.getID() != null) {
                this.ruleID = Integer.parseInt(schemaParser.getID());
            }
            if (schemaParser.getDescription() != null) {
                this.description = schemaParser.getDescription();
            }
            if (schemaParser.getSuperiors() != null) {
                this.superiorIDs = (String[])schemaParser.getSuperiors().clone();
            }
            if (schemaParser.getNameForm() != null) {
                this.nameForm = schemaParser.getNameForm();
            }
            this.obsolete = schemaParser.getObsolete();
            Enumeration enumeration = schemaParser.getQualifiers();
            while (enumeration.hasMoreElements()) {
                AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                this.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {}
    }

    public int getRuleID() {
        return this.ruleID;
    }

    public String getNameForm() {
        return this.nameForm;
    }

    public String[] getSuperiors() {
        return this.superiorIDs;
    }

    protected String formatString() {
        Enumeration enumeration;
        int n;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = String.valueOf(this.getRuleID());
        stringBuffer.append(string);
        String[] stringArray = this.getNames();
        if (stringArray != null) {
            stringBuffer.append(" NAME ");
            if (stringArray.length == 1) {
                stringBuffer.append("'" + stringArray[0] + "'");
            } else {
                stringBuffer.append("( ");
                n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(" '" + stringArray[n] + "'");
                    ++n;
                }
                stringBuffer.append(" )");
            }
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if (this.isObsolete()) {
            stringBuffer.append(" OBSOLETE");
        }
        if ((string = this.getNameForm()) != null) {
            stringBuffer.append(" FORM ");
            stringBuffer.append("'" + string + "'");
        }
        if ((stringArray = this.getSuperiors()) != null) {
            stringBuffer.append(" SUP ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((enumeration = this.getQualifierNames()) != null) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                stringBuffer.append(" " + string2 + " ");
                String[] stringArray2 = this.getQualifier(string2);
                if (stringArray2 == null) continue;
                if (stringArray2.length > 1) {
                    stringBuffer.append("( ");
                }
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (n2 > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("'" + stringArray2[n2] + "'");
                    ++n2;
                }
                if (stringArray2.length <= 1) continue;
                stringBuffer.append(" )");
            }
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }
}

