/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.SchemaParser;
import java.io.IOException;

public class LDAPMatchingRuleUseSchema
extends LDAPSchemaElement {
    private String[] attributes;

    public LDAPMatchingRuleUseSchema(String[] stringArray, String string, String string2, boolean bl, String[] stringArray2) {
        super(LDAPSchema.schemaTypeNames[7]);
        this.names = (String[])stringArray.clone();
        this.oid = string;
        this.description = string2;
        this.obsolete = bl;
        this.attributes = (String[])stringArray2.clone();
        super.setValue(this.formatString());
    }

    public LDAPMatchingRuleUseSchema(String string) {
        super(LDAPSchema.schemaTypeNames[7]);
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            this.names = (String[])schemaParser.getNames().clone();
            this.oid = schemaParser.getID();
            this.description = schemaParser.getDescription();
            this.obsolete = schemaParser.getObsolete();
            this.attributes = schemaParser.getApplies();
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {}
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    protected String formatString() {
        int n;
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = this.getID();
        if (string != null) {
            stringBuffer.append(string);
        }
        if ((stringArray = this.getNames()) != null) {
            stringBuffer.append(" NAME ");
            if (stringArray.length == 1) {
                stringBuffer.append("'" + stringArray[0] + "'");
            } else {
                stringBuffer.append("( ");
                n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(" '" + stringArray[n] + "'");
                    ++n;
                }
                stringBuffer.append(" )");
            }
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if (this.isObsolete()) {
            stringBuffer.append(" OBSOLETE");
        }
        if ((stringArray = this.getAttributes()) != null) {
            stringBuffer.append(" APPLIES ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }
}

