/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.client.RespControlVector;
import com.novell.ldap.rfc2251.RfcControl;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcRequest;
import com.novell.ldap.util.DSMLReader;
import com.novell.ldap.util.DSMLWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class LDAPMessage
implements Serializable {
    public static final int BIND_REQUEST = 0;
    public static final int BIND_RESPONSE = 1;
    public static final int UNBIND_REQUEST = 2;
    public static final int SEARCH_REQUEST = 3;
    public static final int SEARCH_RESPONSE = 4;
    public static final int SEARCH_RESULT = 5;
    public static final int MODIFY_REQUEST = 6;
    public static final int MODIFY_RESPONSE = 7;
    public static final int ADD_REQUEST = 8;
    public static final int ADD_RESPONSE = 9;
    public static final int DEL_REQUEST = 10;
    public static final int DEL_RESPONSE = 11;
    public static final int MODIFY_RDN_REQUEST = 12;
    public static final int MODIFY_RDN_RESPONSE = 13;
    public static final int COMPARE_REQUEST = 14;
    public static final int COMPARE_RESPONSE = 15;
    public static final int ABANDON_REQUEST = 16;
    public static final int SEARCH_RESULT_REFERENCE = 19;
    public static final int EXTENDED_REQUEST = 23;
    public static final int EXTENDED_RESPONSE = 24;
    public static final int INTERMEDIATE_RESPONSE = 25;
    protected RfcLDAPMessage message;
    private int imsgNum = -1;
    private int messageType = -1;
    private String stringTag = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;

    LDAPMessage() {
    }

    LDAPMessage(int n, RfcRequest rfcRequest, LDAPControl[] lDAPControlArray) {
        this.messageType = n;
        RfcControls rfcControls = null;
        if (lDAPControlArray != null) {
            rfcControls = new RfcControls();
            int n2 = 0;
            while (n2 < lDAPControlArray.length) {
                rfcControls.add(lDAPControlArray[n2].getASN1Object());
                ++n2;
            }
        }
        this.message = new RfcLDAPMessage(rfcRequest, rfcControls);
    }

    protected LDAPMessage(RfcLDAPMessage rfcLDAPMessage) {
        this.message = rfcLDAPMessage;
    }

    final LDAPMessage clone(String string, String string2, boolean bl) throws LDAPException {
        return new LDAPMessage((RfcLDAPMessage)this.message.dupMessage(string, string2, bl));
    }

    final LDAPMessage getRequestingMessage() {
        return this.message.getRequestingMessage();
    }

    public LDAPControl[] getControls() {
        LDAPControl[] lDAPControlArray = null;
        RfcControls rfcControls = this.message.getControls();
        if (rfcControls != null) {
            lDAPControlArray = new LDAPControl[rfcControls.size()];
            int n = 0;
            while (n < rfcControls.size()) {
                RfcControl rfcControl = (RfcControl)rfcControls.get(n);
                String string = rfcControl.getControlType().stringValue();
                byte[] byArray = rfcControl.getControlValue().byteValue();
                boolean bl = rfcControl.getCriticality().booleanValue();
                lDAPControlArray[n] = this.controlFactory(string, bl, byArray);
                ++n;
            }
        }
        return lDAPControlArray;
    }

    private final LDAPControl controlFactory(String string, boolean bl, byte[] byArray) {
        RespControlVector respControlVector = LDAPControl.getRegisteredControls();
        try {
            Class clazz = respControlVector.findResponseControl(string);
            if (clazz == null) {
                return new LDAPControl(string, bl, byArray);
            }
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LDAPMessage.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE, array$B == null ? (array$B = LDAPMessage.class$("[B")) : array$B};
            Object[] objectArray = new Object[]{string, new Boolean(bl), byArray};
            ReflectiveOperationException reflectiveOperationException = null;
            try {
                Constructor constructor = clazz.getConstructor(classArray);
                try {
                    Object var10_12 = null;
                    var10_12 = constructor.newInstance(objectArray);
                    return var10_12;
                }
                catch (InstantiationException instantiationException) {
                    reflectiveOperationException = instantiationException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    reflectiveOperationException = illegalAccessException;
                }
                catch (InvocationTargetException invocationTargetException) {
                    reflectiveOperationException = invocationTargetException;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                reflectiveOperationException = noSuchMethodException;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return new LDAPControl(string, bl, byArray);
    }

    public int getMessageID() {
        if (this.imsgNum == -1) {
            this.imsgNum = this.message.getMessageID();
        }
        return this.imsgNum;
    }

    public int getType() {
        if (this.messageType == -1) {
            this.messageType = this.message.getType();
        }
        return this.messageType;
    }

    public boolean isRequest() {
        return this.message.isRequest();
    }

    RfcLDAPMessage getASN1Object() {
        return this.message;
    }

    public String toString() {
        return this.getName() + "(" + this.getMessageID() + "): " + this.message.toString();
    }

    private final String getName() {
        String string;
        switch (this.getType()) {
            case 4: {
                string = "LDAPSearchResponse";
                break;
            }
            case 5: {
                string = "LDAPSearchResult";
                break;
            }
            case 3: {
                string = "LDAPSearchRequest";
                break;
            }
            case 6: {
                string = "LDAPModifyRequest";
                break;
            }
            case 7: {
                string = "LDAPModifyResponse";
                break;
            }
            case 8: {
                string = "LDAPAddRequest";
                break;
            }
            case 9: {
                string = "LDAPAddResponse";
                break;
            }
            case 10: {
                string = "LDAPDelRequest";
                break;
            }
            case 11: {
                string = "LDAPDelResponse";
                break;
            }
            case 12: {
                string = "LDAPModifyRDNRequest";
                break;
            }
            case 13: {
                string = "LDAPModifyRDNResponse";
                break;
            }
            case 14: {
                string = "LDAPCompareRequest";
                break;
            }
            case 15: {
                string = "LDAPCompareResponse";
                break;
            }
            case 0: {
                string = "LDAPBindRequest";
                break;
            }
            case 1: {
                string = "LDAPBindResponse";
                break;
            }
            case 2: {
                string = "LDAPUnbindRequest";
                break;
            }
            case 16: {
                string = "LDAPAbandonRequest";
                break;
            }
            case 19: {
                string = "LDAPSearchResultReference";
                break;
            }
            case 23: {
                string = "LDAPExtendedRequest";
                break;
            }
            case 24: {
                string = "LDAPExtendedResponse";
                break;
            }
            case 25: {
                string = "LDAPIntermediateResponse";
                break;
            }
            default: {
                throw new RuntimeException("LDAPMessage: Unknown Type " + this.getType());
            }
        }
        return string;
    }

    public void setTag(String string) {
        this.stringTag = string;
    }

    public String getTag() {
        if (this.stringTag != null) {
            return this.stringTag;
        }
        if (this.isRequest()) {
            return null;
        }
        LDAPMessage lDAPMessage = this.getRequestingMessage();
        if (lDAPMessage == null) {
            return null;
        }
        return lDAPMessage.stringTag;
    }

    public void writeDSML(OutputStream outputStream) throws IOException {
        DSMLWriter dSMLWriter = new DSMLWriter(outputStream);
        try {
            dSMLWriter.useIndent(true);
            dSMLWriter.setIndent(4);
            dSMLWriter.writeMessage(this);
            dSMLWriter.finish();
        }
        catch (LDAPLocalException lDAPLocalException) {}
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        LDAPMessage lDAPMessage = null;
        try {
            DSMLReader dSMLReader = new DSMLReader(inputStream);
            lDAPMessage = dSMLReader.readMessage();
        }
        catch (LDAPLocalException lDAPLocalException) {
            lDAPLocalException.printStackTrace();
            throw new IOException("LDAPLocalException" + lDAPLocalException);
        }
        return lDAPMessage;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

