/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.Connection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.Message;
import com.novell.ldap.MessageVector;
import com.novell.ldap.client.BindProperties;

class MessageAgent {
    private MessageVector messages = new MessageVector(5, 5);
    private int indexLastRead = 0;
    private static Object nameLock = new Object();
    private static int agentNum = 0;
    private String name;

    MessageAgent() {
    }

    Object[] getMessageArray() {
        return this.messages.getObjectArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void merge(MessageAgent messageAgent) {
        Object[] objectArray = messageAgent.getMessageArray();
        int n = 0;
        while (n < objectArray.length) {
            this.messages.addElement(objectArray[n]);
            ((Message)objectArray[n]).setAgent(this);
            ++n;
        }
        MessageVector messageVector = this.messages;
        synchronized (messageVector) {
            if (objectArray.length > 1) {
                this.messages.notifyAll();
            } else if (objectArray.length == 1) {
                this.messages.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sleepersAwake(boolean bl) {
        MessageVector messageVector = this.messages;
        synchronized (messageVector) {
            if (bl) {
                this.messages.notifyAll();
            } else {
                this.messages.notify();
            }
        }
    }

    final boolean isResponseReceived() {
        int n = this.messages.size();
        int n2 = this.indexLastRead + 1;
        int n3 = 0;
        while (n3 < n) {
            Message message;
            if (n2 == n) {
                n2 = 0;
            }
            if ((message = (Message)this.messages.elementAt(n2)).hasReplies()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    final boolean isResponseReceived(int n) {
        try {
            Message message = this.messages.findMessageById(n);
            return message.hasReplies();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
    }

    final void abandon(int n, LDAPConstraints lDAPConstraints) {
        Message message = null;
        try {
            message = this.messages.findMessageById(n);
            this.messages.removeElement(message);
            message.abandon(lDAPConstraints, null);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
    }

    final void abandonAll() {
        int n = this.messages.size();
        int n2 = 0;
        while (n2 < n) {
            Message message = (Message)this.messages.elementAt(n2);
            this.messages.removeElement(message);
            message.abandon(null, null);
            ++n2;
        }
    }

    final int[] getMessageIDs() {
        int n = this.messages.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            Message message = (Message)this.messages.elementAt(n2);
            nArray[n2] = message.getMessageID();
            ++n2;
        }
        return nArray;
    }

    final boolean isComplete(int n) {
        try {
            Message message = this.messages.findMessageById(n);
            if (!message.isComplete()) {
                return false;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return true;
    }

    final Message getMessage(int n) throws NoSuchFieldException {
        return this.messages.findMessageById(n);
    }

    final void sendMessage(Connection connection, LDAPMessage lDAPMessage, int n, LDAPMessageQueue lDAPMessageQueue, BindProperties bindProperties) throws LDAPException {
        Message message = new Message(lDAPMessage, n, connection, this, lDAPMessageQueue, bindProperties);
        this.messages.addElement(message);
        message.sendMessage();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Object getLDAPMessage(Integer n) {
        if (this.messages.size() == 0) {
            return null;
        }
        if (n != null) {
            try {
                Message message = this.messages.findMessageById(n);
                Object object = message.waitForReply();
                if (!message.acceptsReplies() && !message.hasReplies()) {
                    this.messages.removeElement(message);
                    message.abandon(null, null);
                }
                return object;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return null;
            }
        }
        MessageVector messageVector = this.messages;
        synchronized (messageVector) {
            while (true) {
                int n2 = this.indexLastRead + 1;
                int n3 = 0;
                while (n3 < this.messages.size()) {
                    if (n2 >= this.messages.size()) {
                        n2 = 0;
                    }
                    Message message = (Message)this.messages.elementAt(n2);
                    this.indexLastRead = n2++;
                    Object object = message.getReply();
                    if (!message.acceptsReplies() && !message.hasReplies()) {
                        this.messages.removeElement(message);
                        message.abandon(null, null);
                        --n3;
                    }
                    if (object != null) {
                        return object;
                    }
                    ++n3;
                }
                if (this.messages.size() == 0) {
                    return null;
                }
                try {
                    this.messages.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    String getAgentName() {
        return this.name;
    }

    int getCount() {
        int n = 0;
        Object[] objectArray = this.messages.toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            Message message = (Message)objectArray[n2];
            n += message.getCount();
            ++n2;
        }
        return n;
    }

    private void debugDisplayMessages() {
    }
}

