/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPBindRequest;
import com.novell.ldap.LDAPCompareRequest;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedRequest;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchRequest;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMWriter
implements LDAPWriter {
    private Document doc;
    private Element root;
    private int state = 0;
    private static final int NEW_BATCH = 0;
    private static final int REQUEST_BATCH = 1;
    private static final int RESPONSE_BATCH = 2;
    private static final int SEARCH_RESPONSE = 3;
    private Element searchNode;

    public DOMWriter() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.doc = documentBuilder.newDocument();
    }

    public String getVersion() {
        return "2.0";
    }

    public boolean isRequest() {
        return this.root.getNodeName().equals("batchRequest");
    }

    public void writeComments(String string) throws IOException {
    }

    public void writeMessage(LDAPMessage lDAPMessage) throws LDAPLocalException, IOException {
        this.checkState(lDAPMessage);
        if (lDAPMessage.getType() == 4 || lDAPMessage.getType() == 5 || lDAPMessage.getType() == 19) {
            this.searchNode.appendChild(this.message2Element(lDAPMessage));
        } else {
            this.root.appendChild(this.message2Element(lDAPMessage));
        }
        if (lDAPMessage.getType() == 5) {
            this.state = 2;
            this.searchNode = null;
        }
    }

    public void writeEntry(LDAPEntry lDAPEntry) throws LDAPLocalException {
        this.checkState(lDAPEntry);
        this.myWriteEntry(lDAPEntry, null);
    }

    public void writeEntry(LDAPEntry lDAPEntry, LDAPControl[] lDAPControlArray) throws LDAPLocalException {
        this.checkState(lDAPEntry);
        this.myWriteEntry(lDAPEntry, lDAPControlArray);
    }

    public void writeEntry(LDAPEntry lDAPEntry, LDAPControl[] lDAPControlArray, String string) throws LDAPLocalException {
        this.checkState(lDAPEntry);
        Element element = this.myWriteEntry(lDAPEntry, lDAPControlArray);
        if (string != null && string.length() != 0) {
            element.setAttribute("requestID", string);
        }
    }

    private Element myWriteEntry(LDAPEntry lDAPEntry, LDAPControl[] lDAPControlArray) {
        Element element = this.doc.createElement("searchResultEntry");
        element.setAttribute("dn", lDAPEntry.getDN());
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Iterator iterator = lDAPAttributeSet.iterator();
        while (iterator.hasNext()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)iterator.next();
            Element element2 = this.doc.createElement("attr");
            this.writeAttribute(element2, lDAPAttribute);
            element.appendChild(element2);
        }
        if (lDAPControlArray != null) {
            this.writeControls(element, lDAPControlArray);
        }
        this.searchNode.appendChild(element);
        return element;
    }

    private void writeAttribute(Element element, LDAPAttribute lDAPAttribute) {
        element.setAttribute("name", lDAPAttribute.getName());
        String[] stringArray = lDAPAttribute.getStringValueArray();
        byte[][] byArray = lDAPAttribute.getByteValueArray();
        int n = 0;
        while (n < stringArray.length) {
            Element element2 = this.doc.createElement("value");
            if (Base64.isValidUTF8(byArray[n], false)) {
                element2.appendChild(this.doc.createTextNode(stringArray[n]));
            } else {
                element2.setAttribute("xsi:type", "base64Binary");
                element2.appendChild(this.doc.createTextNode(Base64.encode(byArray[n])));
            }
            element.appendChild(element2);
            ++n;
        }
    }

    public Element message2Element(LDAPMessage lDAPMessage) {
        Element element = null;
        switch (lDAPMessage.getType()) {
            case 0: {
                element = this.doc.createElement("authRequest");
                element.setAttribute("principle", ((LDAPBindRequest)lDAPMessage).getAuthenticationDN());
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Writing of an unbind request is not currently supported");
            }
            case 3: {
                element = this.doc.createElement("searchRequest");
                LDAPSearchRequest lDAPSearchRequest = (LDAPSearchRequest)lDAPMessage;
                element.setAttribute("dn", lDAPSearchRequest.getDN());
                Element element2 = this.doc.createElement("filter");
                this.writeFilter(element2, lDAPSearchRequest.getSearchFilter());
                element.appendChild(element2);
                Element element3 = this.doc.createElement("attributes");
                String[] stringArray = lDAPSearchRequest.getAttributes();
                int n = 0;
                while (n < stringArray.length) {
                    Element element4 = this.doc.createElement("attribute");
                    element4.setAttribute("name", stringArray[n]);
                    element3.appendChild(element4);
                    ++n;
                }
                element.appendChild(element3);
                int n2 = lDAPSearchRequest.getScope();
                if (n2 == 0) {
                    element.setAttribute("scope", "baseObject");
                } else if (n2 == 1) {
                    element.setAttribute("scope", "singleLevel");
                } else if (n2 == 2) {
                    element.setAttribute("scope", "wholeSubtree");
                }
                n2 = lDAPSearchRequest.getDereference();
                if (n2 == 0) {
                    element.setAttribute("derefAliases", "neverDerefAliases");
                } else if (n2 == 1) {
                    element.setAttribute("derefAliases", "derefInSearching");
                } else if (n2 == 2) {
                    element.setAttribute("derefAliases", "derefFindingBaseObj");
                } else if (n2 == 3) {
                    element.setAttribute("derefAliases", "derefAlways");
                }
                n2 = lDAPSearchRequest.getMaxResults();
                if (n2 != 0) {
                    element.setAttribute("sizeLimit", Integer.toString(n2));
                }
                if ((n2 = lDAPSearchRequest.getServerTimeLimit()) != 0) {
                    element.setAttribute("timeLimit", Integer.toString(n2));
                }
                if (!lDAPSearchRequest.isTypesOnly()) break;
                element.setAttribute("typesOnly", "true");
                break;
            }
            case 6: {
                element = this.doc.createElement("modifyRequest");
                LDAPModifyRequest lDAPModifyRequest = (LDAPModifyRequest)lDAPMessage;
                element.setAttribute("dn", lDAPModifyRequest.getDN());
                LDAPModification[] lDAPModificationArray = lDAPModifyRequest.getModifications();
                int n = 0;
                while (n < lDAPModificationArray.length) {
                    Element element5 = this.doc.createElement("modification");
                    LDAPAttribute lDAPAttribute = lDAPModificationArray[n].getAttribute();
                    if (lDAPModificationArray[n].getOp() == 0) {
                        element5.setAttribute("operation", "add");
                    } else if (lDAPModificationArray[n].getOp() == 1) {
                        element5.setAttribute("operation", "delete");
                    } else if (lDAPModificationArray[n].getOp() == 2) {
                        element5.setAttribute("operation", "replace");
                    }
                    this.writeAttribute(element5, lDAPAttribute);
                    element.appendChild(element5);
                    ++n;
                }
                break;
            }
            case 8: {
                element = this.doc.createElement("addRequest");
                LDAPAddRequest lDAPAddRequest = (LDAPAddRequest)lDAPMessage;
                LDAPEntry lDAPEntry = lDAPAddRequest.getEntry();
                element.setAttribute("dn", lDAPEntry.getDN());
                Iterator iterator = lDAPEntry.getAttributeSet().iterator();
                while (iterator.hasNext()) {
                    Element element6 = this.doc.createElement("attr");
                    this.writeAttribute(element6, (LDAPAttribute)iterator.next());
                    element.appendChild(element6);
                }
                break;
            }
            case 10: {
                element = this.doc.createElement("delRequest");
                element.setAttribute("dn", ((LDAPDeleteRequest)lDAPMessage).getDN());
                break;
            }
            case 12: {
                element = this.doc.createElement("modDNRequest");
                LDAPModifyDNRequest lDAPModifyDNRequest = (LDAPModifyDNRequest)lDAPMessage;
                element.setAttribute("dn", lDAPModifyDNRequest.getDN());
                element.setAttribute("newrdn", lDAPModifyDNRequest.getNewRDN());
                element.setAttribute("deleteoldrdn", lDAPModifyDNRequest.getDeleteOldRDN() + "");
                String string = lDAPModifyDNRequest.getParentDN();
                if (string == null || string.length() <= 0) break;
                element.setAttribute("newSuperior", string);
                break;
            }
            case 14: {
                element = this.doc.createElement("compareRequest");
                LDAPCompareRequest lDAPCompareRequest = (LDAPCompareRequest)lDAPMessage;
                element.setAttribute("dn", lDAPCompareRequest.getDN());
                Element element7 = this.doc.createElement("assertion");
                element7.setAttribute("name", lDAPCompareRequest.getAttributeDescription());
                element.appendChild(element7);
                Element element8 = this.doc.createElement("value");
                element7.appendChild(element8);
                byte[] byArray = lDAPCompareRequest.getAssertionValue();
                if (Base64.isValidUTF8(byArray, false)) {
                    try {
                        element8.appendChild(this.doc.createTextNode(new String(byArray, "UTF-8")));
                        break;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new RuntimeException("UTF-8 not supported by JVM:" + unsupportedEncodingException);
                    }
                }
                element8.setNodeValue(Base64.encode(byArray));
                break;
            }
            case 16: {
                element = this.doc.createElement("abandonRequest");
                element.setAttribute("abandonID", DOMWriter.findRequestID(lDAPMessage));
                break;
            }
            case 23: {
                element = this.doc.createElement("extendedRequest");
                LDAPExtendedOperation lDAPExtendedOperation = ((LDAPExtendedRequest)lDAPMessage).getExtendedOperation();
                Element element9 = this.doc.createElement("requestName");
                element9.appendChild(this.doc.createTextNode(lDAPExtendedOperation.getID()));
                element.appendChild(element9);
                byte[] byArray = lDAPExtendedOperation.getValue();
                if (byArray == null) break;
                Element element10 = this.doc.createElement("requestValue");
                element10.setAttribute("xsi:type", "xsd:base64Binary");
                element10.appendChild(this.doc.createTextNode(Base64.encode(lDAPExtendedOperation.getValue())));
                element.appendChild(element10);
                break;
            }
            case 4: {
                element = this.myWriteEntry(((LDAPSearchResult)lDAPMessage).getEntry(), lDAPMessage.getControls());
                break;
            }
            case 19: {
                element = this.doc.createElement("searchResultReference");
                String[] stringArray = ((LDAPSearchResultReference)lDAPMessage).getReferrals();
                int n = 0;
                while (n < stringArray.length) {
                    Element element11 = this.doc.createElement("ref");
                    Text text = this.doc.createTextNode(stringArray[n]);
                    element11.appendChild(text);
                    element.appendChild(element11);
                    ++n;
                }
                break;
            }
            case 5: {
                element = this.doc.createElement("searchResultDone");
                this.writeResult(element, (LDAPResponse)lDAPMessage);
                break;
            }
            case 7: {
                element = this.doc.createElement("modifyResponse");
                this.writeResult(element, (LDAPResponse)lDAPMessage);
                break;
            }
            case 9: {
                element = this.doc.createElement("addResponse");
                this.writeResult(element, (LDAPResponse)lDAPMessage);
                break;
            }
            case 11: {
                element = this.doc.createElement("delResponse");
                this.writeResult(element, (LDAPResponse)lDAPMessage);
                break;
            }
            case 13: {
                element = this.doc.createElement("modDNResponse");
                this.writeResult(element, (LDAPResponse)lDAPMessage);
                break;
            }
            case 15: {
                element = this.doc.createElement("compareResponse");
                this.writeResult(element, (LDAPResponse)lDAPMessage);
                break;
            }
            case 24: {
                LDAPExtendedResponse lDAPExtendedResponse = (LDAPExtendedResponse)lDAPMessage;
                element = this.doc.createElement("extendedResponse");
                this.writeResult(element, (LDAPResponse)lDAPMessage);
                Element element12 = this.doc.createElement("responseName");
                Text text = this.doc.createTextNode(lDAPExtendedResponse.getID());
                element12.appendChild(text);
                element.appendChild(element12);
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) break;
                element12 = this.doc.createElement("response");
                element12.setAttribute("xsi:type", "base64Binary");
                element12.appendChild(this.doc.createTextNode(Base64.encode(byArray)));
                element.appendChild(element12);
            }
        }
        String string = DOMWriter.findRequestID(lDAPMessage);
        if (string != null && string.length() != 0) {
            element.setAttribute("requestID", string);
        }
        return element;
    }

    private void writeMatching(Element element, Iterator iterator) {
        element.setAttribute("name", (String)iterator.next());
        Element element2 = this.doc.createElement("value");
        element.appendChild(element2);
        byte[] byArray = (byte[])iterator.next();
        String string = this.byte2String(byArray);
        element2.appendChild(this.doc.createTextNode(string));
    }

    private void writeFilter(Element element, Iterator iterator) {
        int n = -1;
        Element element2 = null;
        block17: while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Integer) {
                n = (Integer)e;
                switch (n) {
                    case 0: {
                        element2 = this.doc.createElement("and");
                        break;
                    }
                    case 1: {
                        element2 = this.doc.createElement("or");
                        break;
                    }
                    case 2: {
                        element2 = this.doc.createElement("not");
                        break;
                    }
                    case 3: {
                        element2 = this.doc.createElement("equalityMatch");
                        this.writeMatching(element2, iterator);
                        break;
                    }
                    case 5: {
                        element2 = this.doc.createElement("greaterOrEqual");
                        this.writeMatching(element2, iterator);
                        break;
                    }
                    case 6: {
                        element2 = this.doc.createElement("lessOrEqual");
                        this.writeMatching(element2, iterator);
                        break;
                    }
                    case 8: {
                        element2 = this.doc.createElement("approxMatch");
                        this.writeMatching(element2, iterator);
                        break;
                    }
                    case 7: {
                        element2 = this.doc.createElement("present");
                        element2.setAttribute("name", (String)iterator.next());
                        break;
                    }
                    case 9: {
                        element2 = this.doc.createElement("extensibleMatch");
                        element2.setAttribute("matchingRule", (String)iterator.next());
                        element2.setAttribute("name", (String)iterator.next());
                        Element element3 = this.doc.createElement("value");
                        element3.appendChild(this.doc.createTextNode((String)iterator.next()));
                        element2.appendChild(element3);
                        break;
                    }
                    case 4: {
                        Element element3;
                        element2 = this.doc.createElement("substrings");
                        element2.setAttribute("name", (String)iterator.next());
                        while (iterator.hasNext()) {
                            n = (Integer)iterator.next();
                            element3 = null;
                            switch (n) {
                                case 0: {
                                    element3 = this.doc.createElement("initial");
                                    break;
                                }
                                case 1: {
                                    element3 = this.doc.createElement("any");
                                    break;
                                }
                                case 2: {
                                    element3 = this.doc.createElement("final");
                                }
                            }
                            String string = (String)iterator.next();
                            element3.appendChild(this.doc.createTextNode(string));
                            element2.appendChild(element3);
                        }
                        continue block17;
                    }
                }
                continue;
            }
            if (!(e instanceof Iterator)) continue;
            this.writeFilter(element2, (Iterator)e);
        }
        element.appendChild(element2);
    }

    private String byte2String(byte[] byArray) {
        String string = null;
        if (Base64.isValidUTF8(byArray, false)) {
            try {
                string = new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("UTF-8 not supported by JVM" + unsupportedEncodingException);
            }
        } else {
            string = Base64.encode(byArray);
        }
        return string;
    }

    private void writeResult(Element element, LDAPResponse lDAPResponse) {
        Object object;
        String[] stringArray;
        LDAPControl[] lDAPControlArray = lDAPResponse.getControls();
        if (lDAPControlArray != null) {
            this.writeControls(element, lDAPControlArray);
        }
        if ((stringArray = lDAPResponse.getReferrals()) != null) {
            int n = 0;
            while (n < stringArray.length) {
                Element element2 = this.doc.createElement("referral");
                object = this.doc.createTextNode(stringArray[n]);
                element2.appendChild((Node)object);
                element.appendChild(element2);
                ++n;
            }
        }
        Element element3 = this.doc.createElement("resultCode");
        int n = lDAPResponse.getResultCode();
        element3.setAttribute("code", n + "");
        element3.setAttribute("descr", LDAPException.resultCodeToString(n));
        element.appendChild(element3);
        object = lDAPResponse.getErrorMessage();
        if (object != null && ((String)object).length() > 0) {
            Element element4 = this.doc.createElement("errorMessage");
            Text text = this.doc.createTextNode((String)object);
            element4.appendChild(text);
            element.appendChild(element4);
        }
        if ((object = lDAPResponse.getMatchedDN()) != null && ((String)object).length() > 0) {
            element.setAttribute("matchedDN", (String)object);
        }
    }

    private void writeControls(Element element, LDAPControl[] lDAPControlArray) {
        int n = 0;
        while (n < lDAPControlArray.length) {
            Element element2 = this.doc.createElement("control");
            element2.setAttribute("NumericOID", lDAPControlArray[n].getID());
            element2.setAttribute("criticality", "" + lDAPControlArray[n].isCritical());
            byte[] byArray = lDAPControlArray[n].getValue();
            if (byArray != null) {
                Element element3 = this.doc.createElement("controlValue");
                element3.setAttribute("xsi:type", "base64Binary");
                Text text = this.doc.createTextNode(Base64.encode(byArray));
                element3.appendChild(text);
                element2.appendChild(element3);
            }
            element.appendChild(element2);
            ++n;
        }
    }

    public void writeError(Exception exception) throws IOException {
        Element element = this.doc.createElement("errorResponse");
        if (exception instanceof LDAPException) {
            switch (((LDAPException)exception).getResultCode()) {
                case 84: {
                    element.setAttribute("type", "malformedRequest");
                    break;
                }
                case 82: {
                    element.setAttribute("type", "gatewayInternalError");
                    break;
                }
                case 49: {
                    element.setAttribute("type", "authenticationFailed");
                    break;
                }
                default: {
                    element.setAttribute("type", "other");
                    break;
                }
            }
        } else {
            element.setAttribute("type", "other");
        }
        Element element2 = this.doc.createElement("message");
        Text text = this.doc.createTextNode(exception.toString());
        element2.appendChild(text);
        element.appendChild(text);
        this.root.appendChild(element);
    }

    private void checkState(LDAPMessage lDAPMessage) throws LDAPLocalException {
        boolean bl;
        boolean bl2 = bl = !lDAPMessage.isRequest();
        if (this.state == 0) {
            if (bl) {
                this.root = this.doc.createElement("batchResponse");
                this.root.setAttribute("xmlns", "urn:oasis:names:tc:DSML:2:0:core");
                this.root.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
                this.root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this.state = 2;
            } else {
                this.root = this.doc.createElement("batchRequest");
                this.root.setAttribute("xmlns", "urn:oasis:names:tc:DSML:2:0:core");
                this.root.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
                this.root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this.state = 1;
            }
        }
        if (this.state != 3 && (lDAPMessage.getType() == 4 || lDAPMessage.getType() == 5 || lDAPMessage.getType() == 19)) {
            this.searchNode = this.doc.createElement("searchResponse");
            this.searchNode.setAttribute("requestID", "" + DOMWriter.findRequestID(lDAPMessage));
            this.root.appendChild(this.searchNode);
            this.state = 3;
        } else {
            if (this.state == 1 && bl) {
                throw new LDAPLocalException("Attempted insertion of a response message in a request batch", 83);
            }
            if (!(this.state != 2 && this.state != 3 || bl)) {
                throw new LDAPLocalException("Attempted insertion of a request message in a response batch", 83);
            }
            if (this.state == 3 && lDAPMessage.getType() != 4 && lDAPMessage.getType() != 5 && lDAPMessage.getType() != 19) {
                throw new LDAPLocalException("Attempted insertion of a non-search result into a searchResponse", 83);
            }
        }
    }

    private void checkState(LDAPEntry lDAPEntry) throws LDAPLocalException {
        boolean bl = true;
        if (this.state == 0) {
            this.root = this.doc.createElement("batchResponse");
            this.root.setAttribute("xmlns", "urn:oasis:names:tc:DSML:2:0:core");
            this.root.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            this.root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.state = 2;
        }
        if (this.state != 3) {
            this.searchNode = this.doc.createElement("searchResponse");
            this.root.appendChild(this.searchNode);
            this.state = 3;
        } else if (this.state == 1 && bl) {
            throw new LDAPLocalException("Attempted insertion of a response message in a request batch", 83);
        }
    }

    static String findRequestID(LDAPMessage lDAPMessage) {
        String string = lDAPMessage.getTag();
        if (string == null) {
            string = lDAPMessage.getMessageID() + "";
        }
        return string;
    }

    public Element getRootElement() {
        return this.root;
    }

    public void finish() throws IOException {
        this.doc.appendChild(this.root);
    }
}

