/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPCompareRequest;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedRequest;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPResponse;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchRequest;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.LDAPSearchResultReference;
import com.novell.ldap.rfc2251.RfcFilter;
import com.novell.ldap.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class DSMLHandler
extends DefaultHandler
implements ContentHandler,
ErrorHandler {
    private boolean isAddRequest;
    private ArrayList queue = new ArrayList();
    private LDAPMessage message = null;
    private LDAPEntry entry = null;
    private LDAPAttributeSet attrSet = null;
    private ArrayList attributeValues = new ArrayList();
    private ArrayList attributeNames = new ArrayList();
    private ArrayList modlist = new ArrayList();
    private LDAPSearchConstraints searchCons = null;
    private String attrName = null;
    private String dn;
    private String newRDN;
    private String newSuperior;
    private String requestName;
    private byte[] requestValue;
    private StringBuffer value;
    private boolean typesOnly;
    private boolean deleteOldRDN;
    private boolean isBase64;
    private int scope;
    private int operation;
    private RfcFilter filter;
    private boolean isDNMatching;
    private String matchingRule;
    private ArrayList controls = new ArrayList();
    private ArrayList referrallist = new ArrayList();
    private int responsetype = 0;
    private int responsecode = 0;
    private String responseDesc = null;
    private String errorMessage = null;
    private static final int START = 0;
    private static final int BATCH_REQUEST = 1;
    private static final int AUTH_REQUEST = 2;
    private static final int MODIFY_REQUEST = 3;
    private static final int SEARCH_REQUEST = 4;
    private static final int ADD_REQUEST = 5;
    private static final int DELETE_REQUEST = 6;
    private static final int MODIFY_DN_REQUEST = 7;
    private static final int COMPARE_REQUEST = 8;
    private static final int EXTENDED_REQUEST = 9;
    private static final int ASSERTION = 10;
    private static final int VALUE = 11;
    private static final int ATTRIBUTES = 12;
    private static final int ATTRIBUTE = 13;
    private static final int FILTER = 14;
    private static final int AND = 15;
    private static final int OR = 16;
    private static final int NOT = 17;
    private static final int EQUALITY_MATCH = 18;
    private static final int SUBSTRINGS = 19;
    private static final int GREATER_OR_EQUAL = 20;
    private static final int LESS_OR_EQUAL = 21;
    private static final int PRESENT = 22;
    private static final int APPROXIMATE_MATCH = 23;
    private static final int EXTENSIBLE_MATCH = 24;
    private static final int INITIAL = 25;
    private static final int ANY = 26;
    private static final int FINAL = 27;
    private static final int ADD_ATTRIBUTE = 28;
    private static final int MODIFICATION = 29;
    private static final int X_NAME = 30;
    private static final int X_VALUE = 31;
    private static final int CONTROL = 32;
    private static final int BATCH_RESPONSE = 34;
    private static final int ADD_RESPONSE = 35;
    private static final int LDAP_RESPONSE = 36;
    private static final int RESULT_CODE = 37;
    private static final int ERROR_MESSAGE = 38;
    private static final int REFERRAL_LIST = 39;
    private static final int SEARCH_RESPONSE = 40;
    private static final int SEARCH_RESULT_ENTRY = 41;
    private static final int SEARCH_RESULT_REFERENCE = 42;
    private static final int SEARCH_RESULT_REFERENCE_REF = 43;
    private static final int SEARCH_RESULT_DONE = 44;
    private static final int EXTENDED_RESPONSE = 45;
    private static final int EXTENDED_RESPONSE_NAME = 46;
    private static final int EXTENDED_RESPONSE_RESPONSE = 47;
    private static final int AUTH_RESPONSE = 48;
    private static final int MODIFY_RESPONSE = 49;
    private static final int DEL_RESPONSE = 50;
    private static final int MODIFYDN_RESPONSE = 51;
    private static final int COMPARE_RESPONSE = 52;
    private int state = 0;
    private static final HashMap requestTags = new HashMap(35, 0.25f);
    private int valueState;
    private boolean critical;
    private String oid;
    private String requestID;
    private String batchRequestID;
    private boolean isParallel;
    private boolean isUnordered;
    private boolean isResumeOnError;
    private int prevstate = 0;
    private String searchResponseid;

    DSMLHandler() {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Integer n = (Integer)requestTags.get(string2);
        if (n == null) {
            if (this.state != 0) {
                throw new SAXNotRecognizedException("Element name, \"" + string3 + "\" not recognized");
            }
            return;
        }
        int n2 = n;
        if (n2 == 32) {
            this.handleControl(attributes);
            this.prevstate = this.state;
            this.state = 32;
        } else {
            switch (this.state) {
                case 0: {
                    if (n2 == 1 || n2 == 34) {
                        this.state = n2;
                        this.parseTagAttributes(n2, attributes);
                        break;
                    }
                    throw new SAXException("Invalid beginning tag :" + string3);
                }
                case 1: {
                    this.state = n2;
                    if (n2 == 5) {
                        this.attrSet = new LDAPAttributeSet();
                    }
                    if (n2 == 3) {
                        this.modlist.clear();
                    }
                    this.parseTagAttributes(n2, attributes);
                    break;
                }
                case 34: {
                    if (n2 == 35) {
                        this.responsetype = 9;
                        this.state = 36;
                        this.parseTagAttributes(36, attributes);
                    } else if (n2 == 40) {
                        this.responsetype = 4;
                        this.parseTagAttributes(n2, attributes);
                        this.state = 40;
                        this.searchResponseid = this.requestID;
                    } else if (n2 == 45) {
                        this.responsetype = 24;
                        this.parseTagAttributes(36, attributes);
                        this.state = 45;
                    } else if (n2 == 49) {
                        this.responsetype = 7;
                        this.state = 36;
                        this.parseTagAttributes(36, attributes);
                    } else if (n2 == 50) {
                        this.responsetype = 11;
                        this.state = 36;
                        this.parseTagAttributes(36, attributes);
                    } else if (n2 == 51) {
                        this.responsetype = 13;
                        this.state = 36;
                        this.parseTagAttributes(36, attributes);
                    } else if (n2 == 52) {
                        this.responsetype = 15;
                        this.state = 36;
                        this.parseTagAttributes(36, attributes);
                    } else {
                        throw new SAXException("invalid tag: " + string2);
                    }
                    this.referrallist.clear();
                    break;
                }
                case 40: {
                    if (n2 == 44) {
                        this.state = 36;
                        this.responsetype = 5;
                        this.parseTagAttributes(36, attributes);
                        break;
                    }
                    if (n2 == 42) {
                        this.referrallist.clear();
                        this.state = 42;
                        break;
                    }
                    if (n2 != 41) break;
                    this.state = 41;
                    this.parseTagAttributes(41, attributes);
                    this.attrSet = new LDAPAttributeSet();
                    break;
                }
                case 41: {
                    if (n2 != 28) break;
                    this.state = n2;
                    this.attributeValues.clear();
                    this.attrName = attributes.getValue("name");
                    this.isAddRequest = false;
                    break;
                }
                case 42: {
                    if (n2 != 43) break;
                    if (this.value == null) {
                        this.value = new StringBuffer();
                    } else {
                        this.value.delete(0, this.value.length());
                    }
                    this.state = 43;
                    break;
                }
                case 45: {
                    if (this.value == null) {
                        this.value = new StringBuffer();
                    } else {
                        this.value.delete(0, this.value.length());
                    }
                    if (n2 == 46) {
                        this.state = 46;
                    }
                    if (n2 == 47) {
                        this.state = 47;
                        String string4 = attributes.getValue("xsi:type");
                        this.isBase64 = string4 != null && string4.equals("xsd:base64Binary");
                    }
                }
                case 36: {
                    if (n2 == 37) {
                        if (attributes.getValue("code") == null) {
                            throw new SAXException("Response Code not provided");
                        }
                        this.responsecode = new Integer(attributes.getValue("code"));
                        this.responseDesc = attributes.getValue("descr");
                        break;
                    }
                    if (n2 == 38) {
                        if (this.value == null) {
                            this.value = new StringBuffer();
                        } else {
                            this.value.delete(0, this.value.length());
                        }
                        this.state = n2;
                        break;
                    }
                    if (n2 != 39) break;
                    if (this.value == null) {
                        this.value = new StringBuffer();
                    } else {
                        this.value.delete(0, this.value.length());
                    }
                    this.state = n2;
                    break;
                }
                case 4: {
                    if (this.isParallel && this.isUnordered && this.requestID == null) {
                        throw new SAXException("requestID not provided");
                    }
                    if (n2 == 12) {
                        this.attributeNames.clear();
                        this.attributeValues.clear();
                        this.state = n2;
                        break;
                    }
                    if (n2 == 14) {
                        this.state = 14;
                        this.filter = new RfcFilter();
                        break;
                    }
                    throw new SAXException("invalid searchRequest tag: " + string2);
                }
                case 2: 
                case 3: {
                    if (this.isParallel && this.isUnordered && this.requestID == null) {
                        throw new SAXException("requestID not provided");
                    }
                    if (n2 == 29) {
                        this.state = n2;
                        this.attributeValues.clear();
                        String string5 = this.requestID;
                        this.parseTagAttributes(n2, attributes);
                        this.requestID = string5;
                        string5 = null;
                        break;
                    }
                    throw new SAXException("invalid modifyRequest tag: " + string2);
                }
                case 5: {
                    if (this.isParallel && this.isUnordered && this.requestID == null) {
                        throw new SAXException("requestID not provided");
                    }
                    if (n2 == 28) {
                        this.state = n2;
                        this.attributeValues.clear();
                        this.attrName = attributes.getValue("name");
                        this.isAddRequest = true;
                        break;
                    }
                    throw new SAXException("invalid addRequest tag: " + string2);
                }
                case 6: {
                    if (!this.isParallel || !this.isUnordered || this.requestID != null) break;
                    throw new SAXException("requestID not provided");
                }
                case 7: {
                    if (!this.isParallel || !this.isUnordered || this.requestID != null) break;
                    throw new SAXException("requestID not provided");
                }
                case 8: {
                    if (this.isParallel && this.isUnordered && this.requestID == null) {
                        throw new SAXException("requestID not provided");
                    }
                    this.attributeValues.clear();
                    if (n2 == 10) {
                        this.attrName = attributes.getValue("name");
                        this.state = n2;
                        break;
                    }
                    throw new SAXException("invalid compareRequest tag: " + string2);
                }
                case 12: {
                    if (n2 == 13) {
                        this.attributeNames.add(attributes.getValue("name"));
                        this.state = n2;
                        break;
                    }
                    throw new SAXException("invalid attributes tag: " + string2);
                }
                case 19: {
                    if (n2 == 25 || n2 == 26 || n2 == 27) {
                        this.state = n2;
                        this.value = new StringBuffer();
                        break;
                    }
                    throw new SAXException("invalid substrings tag: " + string2);
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    this.handleFilter(n2, attributes, string2);
                    this.state = n2;
                    break;
                }
                case 9: {
                    this.attributeValues.clear();
                    if (n2 != 30 && n2 != 31) break;
                    this.state = n2;
                    this.value = new StringBuffer();
                    break;
                }
                case 10: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 28: 
                case 29: 
                case 32: {
                    if (n2 == 11) {
                        this.valueState = this.state;
                        this.state = n2;
                        this.value = new StringBuffer();
                        String string6 = attributes.getValue("xsi:type");
                        if (string6 != null && string6.equals("xsd:base64Binary")) {
                            this.isBase64 = true;
                            break;
                        }
                        this.isBase64 = false;
                        break;
                    }
                    throw new SAXException("invalid tag: " + string2);
                }
                default: {
                    throw new SAXException("invalid tag: " + string2);
                }
            }
        }
    }

    private void handleControl(Attributes attributes) throws SAXException {
        if (this.controls == null) {
            this.controls = new ArrayList();
        }
        this.oid = attributes.getValue("type");
        if (this.oid == null) {
            throw new SAXException("type is mandatory for a Control");
        }
        this.critical = "true".equalsIgnoreCase(attributes.getValue("criticality"));
    }

    private void handleFilter(int n, Attributes attributes, String string) throws SAXException {
        try {
            switch (n) {
                case 15: {
                    this.filter.startNestedFilter(0);
                    break;
                }
                case 16: {
                    this.filter.startNestedFilter(1);
                    break;
                }
                case 17: {
                    this.filter.startNestedFilter(2);
                    break;
                }
                case 19: {
                    this.attrName = attributes.getValue("name");
                    if (this.attrName == null) {
                        throw new SAXException("The mandatory attribute 'name' is missing from tag <" + string + ">");
                    }
                    this.filter.startSubstrings(this.attrName);
                    break;
                }
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    this.attrName = attributes.getValue("name");
                    if (this.attrName == null) {
                        throw new SAXException("The mandatory attribute 'name' is missing from tag <" + string + ">");
                    }
                    break;
                }
                case 24: {
                    this.attrName = attributes.getValue("name");
                    String string2 = attributes.getValue("dnAttributes");
                    this.isDNMatching = string2 != null && string2.equalsIgnoreCase("true");
                    this.matchingRule = attributes.getValue("matchingRule");
                    break;
                }
                default: {
                    throw new SAXException("invalid tag in filter: " + string);
                }
            }
        }
        catch (LDAPLocalException lDAPLocalException) {
            throw new SAXException("An error occured constructing a filter:" + lDAPLocalException.toString());
        }
    }

    private void parseTagAttributes(int n, Attributes attributes) throws SAXException {
        switch (n) {
            case 34: {
                this.batchRequestID = attributes.getValue("requestID");
                break;
            }
            case 36: {
                this.dn = attributes.getValue("matchedDN");
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                this.dn = attributes.getValue("dn");
                if (this.dn == null) {
                    throw new SAXException("DN is Mandatory in SearchResultEntry");
                }
            }
            case 1: {
                this.batchRequestID = attributes.getValue("requestID");
                String string = attributes.getValue("processing");
                this.isParallel = string != null && string.equals("parallel");
                string = attributes.getValue("responseOrder");
                this.isUnordered = string != null && string.equals("unordered");
                string = attributes.getValue("onError");
                this.isResumeOnError = string != null && string.equals("resume");
            }
            case 4: {
                int n2;
                String string = attributes.getValue("derefAliases");
                if (string == null) {
                    n2 = 3;
                } else if (string.equals("neverDerefAliases")) {
                    n2 = 0;
                } else if (string.equals("derefInSearching")) {
                    n2 = 1;
                } else if (string.equals("derefFindingBaseObj")) {
                    n2 = 2;
                } else if (string.equals("derefAlways")) {
                    n2 = 3;
                } else {
                    throw new SAXException("unknown attribute in searchRequest, " + string);
                }
                string = attributes.getValue("timeLimit");
                int n3 = string != null ? Integer.parseInt(string) : 0;
                string = attributes.getValue("sizeLimit");
                int n4 = string != null ? Integer.parseInt(string) : 0;
                this.searchCons = new LDAPSearchConstraints(n3, n3, n2, n4, false, 0, null, 0);
                this.dn = attributes.getValue("dn");
                string = attributes.getValue("typesOnly");
                if (string == null) {
                    this.typesOnly = false;
                } else if (new Boolean(string).booleanValue()) {
                    this.typesOnly = true;
                } else if (!new Boolean(string).booleanValue()) {
                    this.typesOnly = false;
                } else {
                    throw new SAXException("Invalid value for attribute 'typesOnly'," + string);
                }
                string = attributes.getValue("scope");
                if (string == null) {
                    this.scope = 0;
                } else if (string.equals("baseObject")) {
                    this.scope = 0;
                } else if (string.equals("singleLevel")) {
                    this.scope = 1;
                } else if (string.equals("wholeSubtree")) {
                    this.scope = 2;
                } else {
                    throw new SAXException("Invalid value for attribute 'scope', " + string);
                }
                this.filter = null;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.dn = attributes.getValue("dn");
                break;
            }
            case 29: {
                this.attrName = attributes.getValue("name");
                String string = attributes.getValue("operation");
                if (string == null || this.attrName == null) {
                    throw new SAXException("Required attribute missing from tag <modification> (operation or name are required)");
                }
                if (string.equals("add")) {
                    this.operation = 0;
                    break;
                }
                if (string.equals("replace")) {
                    this.operation = 2;
                    break;
                }
                if (string.equals("delete")) {
                    this.operation = 1;
                    break;
                }
                throw new SAXException("Invalid value for attribute 'operation': " + string);
            }
            case 5: {
                this.dn = attributes.getValue("dn");
                break;
            }
            case 6: {
                this.dn = attributes.getValue("dn");
                break;
            }
            case 7: {
                this.dn = attributes.getValue("dn");
                this.newRDN = attributes.getValue("newrdn");
                String string = attributes.getValue("deleteoldrdn");
                this.deleteOldRDN = string == null || !string.equals("false");
                this.newSuperior = attributes.getValue("newSuperior");
                break;
            }
            case 8: {
                this.dn = attributes.getValue("dn");
                break;
            }
        }
        this.requestID = attributes.getValue("requestID");
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.state == 25 || this.state == 26 || this.state == 27 || this.state == 30 || this.state == 31 || this.state == 11 || this.state == 38 || this.state == 46 || this.state == 47 || this.state == 39 || this.state == 43) {
            this.value.append(cArray, n, n2);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Integer n = (Integer)requestTags.get(string2);
        if (n == null) {
            if (this.state != 0) {
                throw new SAXNotRecognizedException("Element name, \"" + string3 + "\" not recognized");
            }
            return;
        }
        int n2 = n;
        LDAPControl[] lDAPControlArray = null;
        String[] stringArray = null;
        try {
            switch (n2) {
                case 1: 
                case 34: {
                    this.state = 0;
                    break;
                }
                case 43: {
                    String string4 = new String(this.value.toString().getBytes("UTF-8"));
                    this.referrallist.add(string4);
                    this.state = 42;
                    break;
                }
                case 41: {
                    this.state = 40;
                    this.entry = new LDAPEntry(this.dn, this.attrSet);
                    LDAPControl[] lDAPControlArray2 = null;
                    if (this.controls != null && this.controls.size() > 0) {
                        lDAPControlArray2 = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    this.message = new LDAPSearchResult(this.entry, lDAPControlArray2);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.controls.clear();
                    break;
                }
                case 42: {
                    this.state = 40;
                    if (!this.referrallist.isEmpty()) {
                        stringArray = this.referrallist.toArray(new String[this.referrallist.size()]);
                    }
                    try {
                        this.message = new LDAPSearchResultReference(stringArray);
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.out.println("MalformeURL Found");
                    }
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.errorMessage = null;
                    this.controls.clear();
                    this.queue.add(this.message);
                    break;
                }
                case 40: {
                    this.state = 34;
                    break;
                }
                case 44: {
                    this.state = 40;
                    if (this.controls != null && this.controls.size() > 0) {
                        lDAPControlArray = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    if (!this.referrallist.isEmpty()) {
                        stringArray = this.referrallist.toArray(new String[this.referrallist.size()]);
                    }
                    this.message = new LDAPResponse(this.responsetype, this.responsecode, this.dn, this.errorMessage, stringArray, lDAPControlArray);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.errorMessage = null;
                    this.controls.clear();
                    this.queue.add(this.message);
                    break;
                }
                case 46: {
                    this.state = 45;
                    this.requestName = this.value.toString();
                    break;
                }
                case 47: {
                    this.state = 45;
                    if (this.isBase64) {
                        String string5 = this.value.toString();
                        this.requestValue = Base64.decode(string5);
                    } else {
                        this.requestValue = this.value.toString().getBytes("UTF-8");
                    }
                    this.isBase64 = false;
                    break;
                }
                case 45: {
                    if (this.controls != null && this.controls.size() > 0) {
                        lDAPControlArray = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    if (!this.referrallist.isEmpty()) {
                        stringArray = this.referrallist.toArray(new String[this.referrallist.size()]);
                    }
                    try {
                        this.message = new LDAPExtendedResponse(this.responsecode, this.dn, this.errorMessage, stringArray, lDAPControlArray, this.requestName, this.requestValue);
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.out.println("MalformeURL Found");
                    }
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.state = 34;
                    this.controls.clear();
                    break;
                }
                case 35: 
                case 49: 
                case 50: 
                case 51: 
                case 52: {
                    this.state = 34;
                    if (this.controls != null && this.controls.size() > 0) {
                        lDAPControlArray = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    if (!this.referrallist.isEmpty()) {
                        stringArray = this.referrallist.toArray(new String[this.referrallist.size()]);
                    }
                    this.message = new LDAPResponse(this.responsetype, this.responsecode, this.dn, this.errorMessage, stringArray, lDAPControlArray);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.errorMessage = null;
                    this.controls.clear();
                    this.queue.add(this.message);
                    break;
                }
                case 37: {
                    break;
                }
                case 39: {
                    String string6 = new String(this.value.toString().getBytes("UTF-8"));
                    this.referrallist.add(string6);
                    this.state = 36;
                    break;
                }
                case 38: {
                    this.errorMessage = new String(this.value.toString().getBytes("UTF-8"));
                    this.state = 36;
                    break;
                }
                case 4: {
                    this.state = 1;
                    if (this.controls != null && this.controls.size() > 0) {
                        this.searchCons.setControls(this.controls.toArray(new LDAPControl[this.controls.size()]));
                    }
                    this.controls.clear();
                    this.message = this.filter == null ? new LDAPSearchRequest(this.dn, this.scope, "", this.attributeNames.toArray(new String[this.attributeNames.size()]), this.searchCons.getDereference(), this.searchCons.getMaxResults(), this.searchCons.getServerTimeLimit(), this.typesOnly, this.searchCons.getControls()) : new LDAPSearchRequest(this.dn, this.scope, this.filter, this.attributeNames.toArray(new String[this.attributeNames.size()]), this.searchCons.getDereference(), this.searchCons.getMaxResults(), this.searchCons.getServerTimeLimit(), this.typesOnly, this.searchCons.getControls());
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    break;
                }
                case 12: {
                    this.state = 4;
                    break;
                }
                case 13: {
                    this.state = 12;
                    break;
                }
                case 2: {
                    this.state = 1;
                    break;
                }
                case 3: {
                    this.state = 1;
                    LDAPControl[] lDAPControlArray3 = null;
                    if (this.controls != null && this.controls.size() > 0) {
                        lDAPControlArray3 = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    this.message = new LDAPModifyRequest(this.dn, this.modlist.toArray(new LDAPModification[this.modlist.size()]), lDAPControlArray3);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.controls.clear();
                    break;
                }
                case 29: {
                    LDAPAttribute lDAPAttribute = new LDAPAttribute(this.attrName);
                    int n3 = 0;
                    while (n3 < this.attributeValues.size()) {
                        lDAPAttribute.addValue((byte[])this.attributeValues.get(n3));
                        ++n3;
                    }
                    this.state = 3;
                    LDAPModification lDAPModification = new LDAPModification(this.operation, lDAPAttribute);
                    this.modlist.add(lDAPModification);
                    break;
                }
                case 7: {
                    this.state = 1;
                    LDAPControl[] lDAPControlArray4 = null;
                    if (this.controls != null && this.controls.size() > 0) {
                        lDAPControlArray4 = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    this.message = new LDAPModifyDNRequest(this.dn, this.newRDN, this.newSuperior, this.deleteOldRDN, lDAPControlArray4);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.controls.clear();
                    break;
                }
                case 5: {
                    this.state = 1;
                    this.entry = new LDAPEntry(this.dn, this.attrSet);
                    LDAPControl[] lDAPControlArray5 = null;
                    if (this.controls != null && this.controls.size() > 0) {
                        lDAPControlArray5 = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    this.message = new LDAPAddRequest(this.entry, lDAPControlArray5);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.controls.clear();
                    break;
                }
                case 6: {
                    this.state = 1;
                    LDAPControl[] lDAPControlArray6 = null;
                    if (this.controls != null && this.controls.size() > 0) {
                        lDAPControlArray6 = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    this.message = new LDAPDeleteRequest(this.dn, lDAPControlArray6);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.controls.clear();
                    break;
                }
                case 8: {
                    Object e;
                    this.state = 1;
                    LDAPControl[] lDAPControlArray7 = null;
                    if (this.controls != null && this.controls.size() > 0) {
                        lDAPControlArray7 = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    this.message = (e = this.attributeValues.get(0)) instanceof byte[] ? new LDAPCompareRequest(this.dn, this.attrName, (byte[])e, lDAPControlArray7) : new LDAPCompareRequest(this.dn, this.attrName, ((String)e).getBytes("UTF-8"), lDAPControlArray7);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.controls.clear();
                    break;
                }
                case 10: {
                    this.state = 8;
                    break;
                }
                case 28: {
                    LDAPAttribute lDAPAttribute = this.attrSet.getAttribute(this.attrName);
                    if (lDAPAttribute == null) {
                        lDAPAttribute = new LDAPAttribute(this.attrName);
                        this.attrSet.add(lDAPAttribute);
                    }
                    int n4 = this.attributeValues.size();
                    int n5 = 0;
                    while (n5 < n4) {
                        Object e = this.attributeValues.get(n5);
                        byte[] byArray = e instanceof byte[] ? (byte[])e : ((String)e).getBytes("UTF8");
                        this.state = this.isAddRequest ? 5 : 41;
                        lDAPAttribute.addValue(byArray);
                        ++n5;
                    }
                    break;
                }
                case 9: {
                    LDAPControl[] lDAPControlArray8 = null;
                    if (this.controls != null && this.controls.size() > 0) {
                        lDAPControlArray8 = this.controls.toArray(new LDAPControl[this.controls.size()]);
                    }
                    this.message = new LDAPExtendedRequest(new LDAPExtendedOperation(this.requestName, this.requestValue), lDAPControlArray8);
                    if (this.requestID != null) {
                        this.message.setTag(this.requestID);
                    }
                    this.requestID = null;
                    this.queue.add(this.message);
                    this.state = 1;
                    this.controls.clear();
                    break;
                }
                case 30: {
                    this.state = 9;
                    this.requestName = this.value.toString();
                    break;
                }
                case 31: {
                    this.state = 9;
                    this.requestValue = Base64.decode(this.value, 0, this.value.length());
                    break;
                }
                case 14: {
                    this.state = 4;
                    break;
                }
                case 17: {
                    this.filter.endNestedFilter(2);
                    this.state = 14;
                    break;
                }
                case 15: {
                    this.filter.endNestedFilter(0);
                    this.state = 14;
                    break;
                }
                case 16: {
                    this.filter.endNestedFilter(1);
                    this.state = 14;
                    break;
                }
                case 18: {
                    if (this.state != 18) {
                        throw new SAXException("Unexpected tag: " + string2);
                    }
                    this.filter.addAttributeValueAssertion(3, this.attrName, this.value.toString().getBytes("UTF-8"));
                    this.state = 14;
                    break;
                }
                case 22: {
                    if (this.state != 22) {
                        throw new SAXException("Unexpected tag: " + string2);
                    }
                    this.filter.addPresent(this.attrName);
                    this.state = 14;
                    break;
                }
                case 20: {
                    if (this.state != 20) {
                        throw new SAXException("Unexpected tag: " + string2);
                    }
                    this.filter.addAttributeValueAssertion(5, this.attrName, this.value.toString().getBytes("UTF-8"));
                    this.state = 14;
                    break;
                }
                case 21: {
                    if (this.state != 21) {
                        throw new SAXException("Unexpected tag: " + string2);
                    }
                    this.filter.addAttributeValueAssertion(6, this.attrName, this.value.toString().getBytes("UTF-8"));
                    this.state = 14;
                    break;
                }
                case 23: {
                    if (this.state != 23) {
                        throw new SAXException("Unexpected tag: " + string2);
                    }
                    this.filter.addAttributeValueAssertion(8, this.attrName, this.value.toString().getBytes("UTF-8"));
                    this.state = 14;
                    break;
                }
                case 24: {
                    if (this.state != 24) {
                        throw new SAXException("Unexpected tag: " + string2);
                    }
                    this.filter.addExtensibleMatch(this.matchingRule, this.attrName, this.value.toString().getBytes("UTF-8"), this.isDNMatching);
                    this.state = 14;
                    break;
                }
                case 25: {
                    if (this.state != 25) {
                        throw new SAXException("Unexpected tag: " + string2);
                    }
                    this.filter.addSubstring(0, this.value.toString().getBytes("UTF-8"));
                    this.state = 19;
                    break;
                }
                case 26: {
                    if (this.state != 26) {
                        throw new SAXException("Unexpected tag: " + string2);
                    }
                    this.filter.addSubstring(1, this.value.toString().getBytes("UTF-8"));
                    this.state = 19;
                    break;
                }
                case 27: {
                    if (this.state != 27) {
                        throw new SAXException("Unexpected tag: " + string2);
                    }
                    this.filter.addSubstring(2, this.value.toString().getBytes("UTF-8"));
                    this.state = 19;
                    break;
                }
                case 19: {
                    if (this.state != 27 && this.state != 19) {
                        throw new SAXException("Unexpected closing substring tag");
                    }
                    this.filter.endSubstrings();
                    this.state = 14;
                    break;
                }
                case 32: {
                    byte[] byArray = this.isBase64 ? Base64.decode(this.value, 0, this.value.length()) : this.value.toString().getBytes("UTF-8");
                    this.controls.add(new LDAPControl(this.oid, this.critical, byArray));
                    this.state = this.prevstate;
                    break;
                }
                case 11: {
                    this.state = this.valueState;
                    if (this.isBase64) {
                        this.attributeValues.add(Base64.decode(this.value, 0, this.value.length()));
                        break;
                    }
                    this.attributeValues.add(this.value.toString().getBytes("UTF-8"));
                }
            }
        }
        catch (LDAPException lDAPException) {
            throw new SAXException(lDAPException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF8 encoding not supported:" + unsupportedEncodingException);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.out.println("warning: " + sAXParseException.toString());
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.out.println("error: " + sAXParseException.toString());
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.out.println("fatal error: " + sAXParseException.toString());
        throw sAXParseException;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    String getBatchRequestID() {
        return this.batchRequestID;
    }

    boolean isParallelProcessing() {
        return this.isParallel;
    }

    boolean isResponseUnordered() {
        return this.isUnordered;
    }

    boolean isResumeOnError() {
        return this.isResumeOnError;
    }

    ArrayList getQueue() {
        return this.queue;
    }

    static {
        requestTags.put("batchRequest", new Integer(1));
        requestTags.put("authRequest", new Integer(2));
        requestTags.put("modifyRequest", new Integer(3));
        requestTags.put("searchRequest", new Integer(4));
        requestTags.put("addRequest", new Integer(5));
        requestTags.put("delRequest", new Integer(6));
        requestTags.put("modDNRequest", new Integer(7));
        requestTags.put("compareRequest", new Integer(8));
        requestTags.put("extendedRequest", new Integer(9));
        requestTags.put("batchResponse", new Integer(34));
        requestTags.put("assertion", new Integer(10));
        requestTags.put("value", new Integer(11));
        requestTags.put("attributes", new Integer(12));
        requestTags.put("attribute", new Integer(13));
        requestTags.put("filter", new Integer(14));
        requestTags.put("and", new Integer(15));
        requestTags.put("or", new Integer(16));
        requestTags.put("not", new Integer(17));
        requestTags.put("equalityMatch", new Integer(18));
        requestTags.put("substrings", new Integer(19));
        requestTags.put("greaterOrEqual", new Integer(20));
        requestTags.put("lessOrEqual", new Integer(21));
        requestTags.put("present", new Integer(22));
        requestTags.put("approxMatch", new Integer(23));
        requestTags.put("extensibleMatch", new Integer(24));
        requestTags.put("attr", new Integer(28));
        requestTags.put("modification", new Integer(29));
        requestTags.put("requestName", new Integer(30));
        requestTags.put("requestValue", new Integer(31));
        requestTags.put("initial", new Integer(25));
        requestTags.put("any", new Integer(26));
        requestTags.put("final", new Integer(27));
        requestTags.put("control", new Integer(32));
        requestTags.put("controlValue", new Integer(11));
        requestTags.put("addResponse", new Integer(35));
        requestTags.put("resultCode", new Integer(37));
        requestTags.put("errorMessage", new Integer(38));
        requestTags.put("referral", new Integer(39));
        requestTags.put("searchResponse", new Integer(40));
        requestTags.put("searchResultEntry", new Integer(41));
        requestTags.put("searchResultReference", new Integer(42));
        requestTags.put("ref", new Integer(43));
        requestTags.put("searchResultDone", new Integer(44));
        requestTags.put("authResponse", new Integer(48));
        requestTags.put("modifyResponse", new Integer(49));
        requestTags.put("delResponse", new Integer(50));
        requestTags.put("modDNResponse", new Integer(51));
        requestTags.put("compareResponse", new Integer(52));
        requestTags.put("extendedResponse", new Integer(45));
        requestTags.put("responseName", new Integer(46));
        requestTags.put("response", new Integer(47));
    }
}

