/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.index;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.Uri;
import org.apache.slide.common.XAServiceBase;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.index.BasicExpressionFactoryTxtContainsSample;
import org.apache.slide.index.LuceneIndexer;
import org.apache.slide.search.IndexException;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.store.IndexStore;

public class SampleTxtContainsIndexer
extends XAServiceBase
implements IndexStore {
    private static final String INDEX_PATH = "indexpath";
    private String indexpath;
    private boolean started = false;

    public void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        this.indexpath = token.getNamespaceConfig().getParameter(INDEX_PATH);
        IndexWriter indexWriter = null;
        try {
            indexWriter = new IndexWriter(this.indexpath, (Analyzer)new StandardAnalyzer(), false);
        }
        catch (IOException e) {
            try {
                indexWriter = new IndexWriter(this.indexpath, (Analyzer)new StandardAnalyzer(), true);
            }
            catch (IOException ex) {
                throw new ServiceInitializationFailedException((Service)this, (Exception)ex);
            }
        }
        try {
            indexWriter.close();
        }
        catch (IOException e) {
            throw new ServiceInitializationFailedException((Service)this, (Exception)e);
        }
    }

    public IBasicExpressionFactory getBasicExpressionFactory() {
        return new BasicExpressionFactoryTxtContainsSample(this.indexpath);
    }

    public synchronized void createIndex(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws IndexException {
        try {
            LuceneIndexer indexer = new LuceneIndexer(this.indexpath);
            indexer.index(uri.toString(), new CharArrayReader(revisionContent.getContent()));
        }
        catch (Exception e) {
            throw new IndexException((Throwable)e);
        }
    }

    public synchronized void updateIndex(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws IndexException {
        try {
            LuceneIndexer indexer = new LuceneIndexer(this.indexpath);
            indexer.removeIndex(uri.toString());
            indexer.index(uri.toString(), new CharArrayReader(revisionContent.getContent()));
        }
        catch (Exception e) {
            throw new IndexException((Throwable)e);
        }
    }

    public synchronized void dropIndex(Uri uri, NodeRevisionNumber number) throws IndexException {
        try {
            LuceneIndexer indexer = new LuceneIndexer(this.indexpath);
            indexer.removeIndex(uri.toString());
        }
        catch (Exception e) {
            throw new IndexException((Throwable)e);
        }
    }

    public void connect() throws ServiceConnectionFailedException {
        System.out.println("SampleIndexer: connect");
        this.started = true;
    }

    public boolean isConnected() throws ServiceAccessException {
        return this.started;
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        this.indexpath = (String)parameters.get(INDEX_PATH);
        if (this.indexpath == null || this.indexpath.length() == 0) {
            throw new ServiceParameterMissingException((Service)this, INDEX_PATH);
        }
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
        System.out.println("SampleIndexer: disconnect");
        this.started = false;
    }

    public void reset() throws ServiceResetFailedException {
        System.out.println("SampleIndexer: reset");
    }
}

