/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms.expression;

import java.util.Collection;
import java.util.Iterator;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.SearchException;
import org.apache.slide.search.basic.IBasicExpression;
import org.apache.slide.search.basic.IBasicResultSet;
import org.apache.slide.store.impl.rdbms.expression.RDBMSExpression;
import org.apache.slide.store.impl.rdbms.expression.RDBMSQueryContext;

public class RDBMSMergeExpression
extends RDBMSExpression {
    private final String _name;
    private final String _namespace;
    private final Collection _rdbmsExpressions;
    private final Collection _otherExpressions;

    public RDBMSMergeExpression(String name, String namespace, RDBMSQueryContext context, Collection rdbmsExpressions, Collection otherExpressions) throws BadQueryException {
        super(context);
        this._name = name;
        this._namespace = namespace;
        this._rdbmsExpressions = rdbmsExpressions;
        this._otherExpressions = otherExpressions;
    }

    public IBasicResultSet execute() throws SearchException {
        return this.compile(null);
    }

    protected IBasicResultSet compile(RDBMSMergeExpression expression) throws SearchException {
        if (this._rdbmsExpressions != null && this._rdbmsExpressions.size() > 0) {
            this._context.criteria().add(" ( ");
            Iterator iter = this._rdbmsExpressions.iterator();
            while (iter.hasNext()) {
                ((RDBMSExpression)iter.next()).compile(this);
                if (!iter.hasNext()) continue;
                this._context.criteria().add(" " + this._name + " ");
            }
            this._context.criteria().add(" ) ");
        }
        if (this._otherExpressions != null) {
            IBasicExpression merger = this._factory.createStandardMergeExpression(this._name, this._namespace, this._otherExpressions);
            return merger.execute();
        }
        return this._context.results();
    }

    protected String getName() {
        return this._name;
    }

    protected Collection getRDBMSExpressions() {
        return this._rdbmsExpressions;
    }
}

