/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.mem;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.transaction.memory.ConflictException;
import org.apache.commons.transaction.memory.TransactionalMapWrapper;
import org.apache.commons.transaction.memory.jca.MapXAResource;
import org.apache.slide.common.AbstractServiceBase;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.util.logger.TxLogger;

public abstract class AbstractTransientStore
extends AbstractServiceBase {
    static final String MAP_IMPL_PARAMETER = "map-classname";
    static final String MAP_IMPL_PARAMETER_DEFAULT = "org.apache.commons.transaction.memory.OptimisticMapWrapper";
    private Map parameters = null;
    private boolean isConnected = false;
    private TransactionalMapWrapper store = null;
    private MapXAResource xaResource = null;
    protected static Enumeration EMPTY_ENUM = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$org$apache$commons$transaction$util$LoggerFacade;

    public void start(Xid xid, int flags) throws XAException {
        this.debug("start {0} {1}", xid, Integer.toString(flags));
        this.xaResource.start(xid, flags);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.debug("commit {0} {1}", xid, onePhase ? "true" : "false");
        try {
            this.xaResource.commit(xid, onePhase);
        }
        catch (ConflictException e) {
            this.xaResource.rollback(xid);
            throw new XAException(104);
        }
    }

    public int prepare(Xid xid) throws XAException {
        this.debug("prepare {0}", xid);
        return this.xaResource.prepare(xid);
    }

    public void end(Xid xid, int flags) throws XAException {
        this.debug("end {0} {1}", xid, Integer.toString(flags));
        this.xaResource.end(xid, flags);
    }

    public void rollback(Xid xid) throws XAException {
        this.debug("rollback {0}", xid);
        this.xaResource.rollback(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        this.debug("recover {0}", Integer.toString(flag));
        return this.xaResource.recover(flag);
    }

    public void forget(Xid xid) throws XAException {
        this.debug("forget {0}", xid);
        this.xaResource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaResource.setTransactionTimeout(seconds);
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return this == xares;
    }

    protected void put(Object key, Object value) {
        this.store.put(key, value);
    }

    protected Object get(Object key) {
        return this.store.get(key);
    }

    protected Object remove(Object key) {
        return this.store.remove(key);
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        this.parameters = new HashMap(parameters);
    }

    protected String getParameter(String name) {
        if (this.parameters != null) {
            return (String)this.parameters.get(name);
        }
        throw new IllegalStateException("Parameter not yet set!");
    }

    public void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        super.initialize(token);
        TxLogger txLogger = new TxLogger(this.getLogger(), this.LogChannel());
        String param = (String)this.parameters.get(MAP_IMPL_PARAMETER);
        if (param == null) {
            param = MAP_IMPL_PARAMETER_DEFAULT;
        }
        try {
            this.info("Initializing {0} using {1}.", ((Object)((Object)this)).getClass().getName(), param);
            HashMap toBeWrapped = new HashMap();
            Class<?> mapClass = Class.forName(param);
            try {
                Class[] ctorFormalArgs = new Class[]{class$java$util$Map == null ? (class$java$util$Map = AbstractTransientStore.class$("java.util.Map")) : class$java$util$Map, class$org$apache$commons$transaction$util$LoggerFacade == null ? (class$org$apache$commons$transaction$util$LoggerFacade = AbstractTransientStore.class$("org.apache.commons.transaction.util.LoggerFacade")) : class$org$apache$commons$transaction$util$LoggerFacade};
                Constructor<?> ctor = mapClass.getConstructor(ctorFormalArgs);
                Object[] ctorArgs = new Object[]{toBeWrapped, txLogger};
                this.store = (TransactionalMapWrapper)ctor.newInstance(ctorArgs);
            }
            catch (NoSuchMethodException e) {
                try {
                    Class[] ctorFormalArgs = new Class[]{class$java$util$Map == null ? (class$java$util$Map = AbstractTransientStore.class$("java.util.Map")) : class$java$util$Map};
                    Constructor<?> ctor = mapClass.getConstructor(ctorFormalArgs);
                    Object[] ctorArgs = new Object[]{toBeWrapped};
                    this.store = (TransactionalMapWrapper)ctor.newInstance(ctorArgs);
                }
                catch (NoSuchMethodException ee) {
                    this.error("Initialization error: ", ee);
                    throw new ServiceInitializationFailedException((Service)this, (Exception)ee);
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.error("Initialization error: ", e);
            throw new ServiceInitializationFailedException((Service)this, (Exception)e);
        }
        catch (InstantiationException e) {
            this.error("Initialization error: ", e);
            throw new ServiceInitializationFailedException((Service)this, (Exception)e);
        }
        catch (IllegalAccessException e) {
            this.error("Initialization error: ", e);
            throw new ServiceInitializationFailedException((Service)this, (Exception)e);
        }
        catch (InvocationTargetException e) {
            this.error("Initialization error: ", e);
            throw new ServiceInitializationFailedException((Service)this, (Exception)e);
        }
        catch (ClassCastException e) {
            this.error("Initialization error: ", e);
            throw new ServiceInitializationFailedException((Service)this, "class in parameter 'map-classname' must be derived from TransactionalMapWrapper");
        }
        this.xaResource = new MapXAResource(this.store);
    }

    public void connect() throws ServiceConnectionFailedException {
        this.isConnected = true;
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
        this.isConnected = false;
    }

    public void reset() throws ServiceResetFailedException {
    }

    public boolean isConnected() throws ServiceAccessException {
        return this.isConnected;
    }

    protected String LogChannel() {
        return this.LOG_CHANNEL;
    }

    protected void debug(String msg, Object o) {
        if (this.getLogger().isEnabled(7)) {
            Object[] args = new Object[]{o};
            this.getLogger().log((Object)MessageFormat.format(msg, args), this.LogChannel(), 7);
        }
    }

    protected void debug(String msg, Object o1, Object o2) {
        if (this.getLogger().isEnabled(7)) {
            Object[] args = new Object[]{o1, o2};
            this.getLogger().log((Object)MessageFormat.format(msg, args), this.LogChannel(), 7);
        }
    }

    private void info(String msg, Object o1, Object o2) {
        if (this.getLogger().isEnabled(6)) {
            Object[] args = new Object[]{o1, o2};
            this.getLogger().log((Object)MessageFormat.format(msg, args), this.LogChannel(), 6);
        }
    }

    private void error(String msg, Throwable t) {
        if (this.getLogger().isEnabled(6)) {
            this.getLogger().log((Object)msg, t, this.LogChannel(), 6);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class IteratorEnum
    implements Enumeration {
        private Iterator iterator;

        public IteratorEnum(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

