/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.mem;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.mem.AbstractTransientStore;

public class TransientLockStore
extends AbstractTransientStore
implements LockStore {
    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        this.debug("putLock {0} {1}", uri, lock.getLockId());
        ArrayList<Object> list = (ArrayList<NodeLock>)this.get(uri.toString());
        list = list != null ? new ArrayList(list) : new ArrayList<NodeLock>();
        list.add(lock);
        this.put(uri.toString(), list);
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.debug("renewLock {0} {1}", uri, lock.getLockId());
        ArrayList<NodeLock> list = (ArrayList<NodeLock>)this.get(uri.toString());
        if (list == null || !list.contains(lock)) {
            throw new LockTokenNotFoundException(lock);
        }
        list = new ArrayList<NodeLock>(list);
        list.remove(lock);
        list.add(lock);
        this.put(uri.toString(), list);
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.debug("removeLock {0} {1}", uri, lock.getLockId());
        ArrayList list = (ArrayList)this.get(uri.toString());
        if (list == null) {
            throw new LockTokenNotFoundException(lock);
        }
        if (!list.contains(lock)) {
            throw new LockTokenNotFoundException(lock);
        }
        if (list.size() == 1) {
            this.remove(uri.toString());
        } else {
            list = new ArrayList(list);
            list.remove(lock);
            this.put(uri.toString(), list);
        }
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.debug("killLock {0} {1}", uri, lock.getLockId());
        this.removeLock(uri, lock);
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        this.debug("enumerateLocks {0}", uri);
        List list = (List)this.get(uri.toString());
        if (list != null) {
            return new AbstractTransientStore.IteratorEnum(list.iterator());
        }
        return EMPTY_ENUM;
    }
}

