/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.txfile;

import java.io.File;
import java.util.Hashtable;
import javax.transaction.Status;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.transaction.file.FileResourceManager;
import org.apache.commons.transaction.file.ResourceManagerException;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.commons.transaction.util.xa.XidWrapper;
import org.apache.slide.common.AbstractServiceBase;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.macro.ConflictException;
import org.apache.slide.util.logger.TxLogger;

public abstract class AbstractTxFileStoreService
extends AbstractServiceBase
implements Status {
    protected static final int DEBUG_LEVEL = 7;
    protected static final String STORE_DIR_PARAMETER = "rootpath";
    protected static final String WORK_DIR_PARAMETER = "workpath";
    protected static final String TIMEOUT_PARAMETER = "timeout";
    protected static final String URLENCODE_PATH_PARAMETER = "url-encode-path";
    protected static final String DEBUG_MODE_PARAMETER = "debug";
    protected FileResourceManager rm;
    protected boolean started = false;
    protected String storeDir;
    protected String workDir;
    protected ThreadLocal activeTransactionBranch = new ThreadLocal();
    static /* synthetic */ Class class$org$apache$commons$transaction$file$FileResourceManager;

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        this.storeDir = (String)parameters.get(STORE_DIR_PARAMETER);
        this.workDir = (String)parameters.get(WORK_DIR_PARAMETER);
        if (this.storeDir == null) {
            throw new ServiceParameterMissingException((Service)this, STORE_DIR_PARAMETER);
        }
        if (this.workDir == null) {
            throw new ServiceParameterMissingException((Service)this, WORK_DIR_PARAMETER);
        }
        new File(this.storeDir).mkdirs();
        new File(this.workDir).mkdirs();
        boolean debug = false;
        String debugString = (String)parameters.get(DEBUG_MODE_PARAMETER);
        if (debugString != null) {
            debug = "true".equals(debugString);
        }
        boolean urlEncodePath = false;
        String urlEncodePathString = (String)parameters.get(URLENCODE_PATH_PARAMETER);
        if (urlEncodePathString != null) {
            urlEncodePath = "true".equals(urlEncodePathString);
        }
        this.rm = new FileResourceManager(this.storeDir, this.workDir, urlEncodePath, (LoggerFacade)new TxLogger(this.getLogger(), (class$org$apache$commons$transaction$file$FileResourceManager == null ? (class$org$apache$commons$transaction$file$FileResourceManager = AbstractTxFileStoreService.class$("org.apache.commons.transaction.file.FileResourceManager")) : class$org$apache$commons$transaction$file$FileResourceManager).getName()), debug);
        this.getLogger().log((Object)("File Store configured to " + this.storeDir + ", working directory " + this.workDir), this.getLogChannel(), 6);
        String timeoutString = (String)parameters.get(TIMEOUT_PARAMETER);
        if (timeoutString != null) {
            try {
                int timeout = Integer.parseInt(timeoutString);
                this.rm.setDefaultTransactionTimeout((long)(timeout * 1000));
                this.getLogger().log((Object)("Set timeout to " + timeoutString), this.getLogChannel(), 6);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log((Object)("Can not set timeout, '" + timeoutString + "' must be an integer!"), this.getLogChannel(), 4);
            }
        }
    }

    public String toString() {
        return "TxFileStore at " + this.storeDir + "  working on " + this.workDir;
    }

    public void connect() throws ServiceConnectionFailedException {
        try {
            this.rm.start();
            this.started = true;
        }
        catch (ResourceManagerException e) {
            throw new ServiceConnectionFailedException((Service)this, (Exception)((Object)e));
        }
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
        try {
            if (!this.rm.stop(0)) {
                throw new ServiceDisconnectionFailedException((Service)this, "Shut down timed out");
            }
            this.started = false;
        }
        catch (ResourceManagerException e) {
            throw new ServiceDisconnectionFailedException((Service)this, (Exception)((Object)e));
        }
    }

    public boolean isConnected() throws ServiceAccessException {
        return this.started;
    }

    public void reset() {
        this.rm.reset();
    }

    public int getTransactionTimeout() throws XAException {
        try {
            long msecs = this.rm.getTransactionTimeout(this.getActiveTxId());
            return Math.round((float)msecs / 1000.0f);
        }
        catch (ResourceManagerException e) {
            throw this.createXAException(e);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            this.rm.setTransactionTimeout(this.getActiveTxId(), (long)(seconds * 1000));
            return true;
        }
        catch (ResourceManagerException e) {
            throw this.createXAException(e);
        }
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return xares instanceof AbstractTxFileStoreService && ((AbstractTxFileStoreService)((Object)xares)).rm.equals(this.rm);
    }

    public synchronized Xid[] recover(int flag) throws XAException {
        return null;
    }

    public synchronized void forget(Xid xid) throws XAException {
    }

    public synchronized int prepare(Xid xid) throws XAException {
        String txId = this.wrap(xid);
        Thread currentThread = Thread.currentThread();
        this.getLogger().log((Object)("Thread " + currentThread + " prepares transaction branch " + txId), this.getLogChannel(), 7);
        try {
            int status = this.rm.prepareTransaction((Object)txId);
            switch (status) {
                case 2: {
                    return 3;
                }
                case 1: {
                    return 0;
                }
            }
            throw new XAException(100);
        }
        catch (ResourceManagerException e) {
            this.getLogger().log((Object)("Thread " + currentThread + " failed to prepare transaction branch " + txId), (Throwable)e, this.getLogChannel(), 1);
            throw this.createXAException(e);
        }
    }

    public synchronized void rollback(Xid xid) throws XAException {
        String txId = this.wrap(xid);
        Thread currentThread = Thread.currentThread();
        this.getLogger().log((Object)("Thread " + currentThread + " rolls back transaction branch " + txId), this.getLogChannel(), 7);
        try {
            this.rm.rollbackTransaction((Object)txId);
            this.activeTransactionBranch.set(null);
        }
        catch (ResourceManagerException e) {
            this.getLogger().log((Object)("Thread " + currentThread + " failed to roll back transaction branch " + txId), (Throwable)e, this.getLogChannel(), 1);
            throw this.createXAException(e);
        }
    }

    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        String txId = this.wrap(xid);
        Thread currentThread = Thread.currentThread();
        this.getLogger().log((Object)("Thread " + currentThread + " commits transaction branch " + txId), this.getLogChannel(), 7);
        try {
            if (!onePhase && this.rm.getTransactionState((Object)txId) != 2) {
                throw new XAException(-5);
            }
            this.rm.commitTransaction((Object)txId);
            this.activeTransactionBranch.set(null);
        }
        catch (ResourceManagerException e) {
            this.getLogger().log((Object)("Thread " + currentThread + " failed to commit transaction branch " + txId), (Throwable)e, this.getLogChannel(), 1);
            throw this.createXAException(e);
        }
    }

    public synchronized void end(Xid xid, int flags) throws XAException {
        String txId = this.wrap(xid);
        Thread currentThread = Thread.currentThread();
        this.getLogger().log((Object)("Thread " + currentThread + (flags == 0x2000000 ? " suspends" : (flags == 0x20000000 ? " fails" : " ends")) + " work on behalf of transaction branch " + txId), this.getLogChannel(), 7);
        switch (flags) {
            case 0x2000000: {
                this.activeTransactionBranch.set(null);
                break;
            }
            case 0x20000000: {
                try {
                    this.rm.markTransactionForRollback((Object)this.wrap(xid));
                    break;
                }
                catch (ResourceManagerException e) {
                    throw this.createXAException(e);
                }
            }
        }
    }

    public synchronized void start(Xid xid, int flags) throws XAException {
        String txId = this.wrap(xid);
        Thread currentThread = Thread.currentThread();
        this.getLogger().log((Object)("Thread " + currentThread + (flags == 0 ? " starts" : (flags == 0x200000 ? " joins" : " resumes")) + " work on behalf of transaction branch " + txId), this.getLogChannel(), 7);
        switch (flags) {
            case 0: {
                if (this.getActiveTxId() != null) {
                    throw new XAException(-5);
                }
                try {
                    this.rm.startTransaction((Object)txId);
                    this.activeTransactionBranch.set(txId);
                    break;
                }
                catch (ResourceManagerException e) {
                    throw this.createXAException(e);
                }
            }
            case 0x200000: {
                if (this.getActiveTxId() != null) {
                    throw new XAException(-5);
                }
                try {
                    if (this.rm.getTransactionState((Object)txId) == 6) {
                        throw new XAException(-5);
                    }
                }
                catch (ResourceManagerException e) {
                    throw this.createXAException(e);
                }
                this.activeTransactionBranch.set(txId);
                break;
            }
            case 0x8000000: {
                this.activeTransactionBranch.set(txId);
            }
        }
    }

    public synchronized void throwInternalError(String cause) throws ServiceAccessException {
        Object txId = this.getActiveTxId();
        this.getLogger().log((Object)("Thread " + Thread.currentThread() + " marked transaction branch " + txId + " for rollback. Cause: " + cause), this.getLogChannel(), 4);
        try {
            this.rm.markTransactionForRollback(txId);
        }
        catch (ResourceManagerException re) {
            throw new ServiceAccessException((Service)this, (Throwable)re);
        }
        throw new ServiceAccessException((Service)this, cause);
    }

    public synchronized void throwInternalError(Throwable cause) throws ServiceAccessException {
        Object txId = this.getActiveTxId();
        this.getLogger().log((Object)("Thread " + Thread.currentThread() + " marked transaction branch " + txId + " for rollback. Cause: " + cause), this.getLogChannel(), 4);
        try {
            this.rm.markTransactionForRollback(txId);
        }
        catch (ResourceManagerException re) {
            throw new ServiceAccessException((Service)this, (Throwable)re);
        }
        throw new ServiceAccessException((Service)this, cause);
    }

    public synchronized void throwInternalError(Throwable cause, String uri) throws ServiceAccessException {
        Object txId = this.getActiveTxId();
        if (cause instanceof ResourceManagerException && ((ResourceManagerException)cause).getStatus() == 5001) {
            if (txId != null) {
                try {
                    this.rm.markTransactionForRollback(txId);
                }
                catch (ResourceManagerException re) {
                    throw new ServiceAccessException((Service)this, (Throwable)re);
                }
            }
            this.getLogger().log((Object)("DEADLOCK VICTIM: Thread " + Thread.currentThread() + " marked transaction branch " + txId + " for rollback"), this.getLogChannel(), 6);
            throw new ServiceAccessException((Service)this, (Throwable)new ConflictException(uri));
        }
        this.getLogger().log((Object)("Could not process URI '" + uri + "'! Thread " + Thread.currentThread() + " marking transaction branch " + txId + " for rollback"), cause, this.getLogChannel(), 4);
        if (txId != null) {
            try {
                this.rm.markTransactionForRollback(txId);
            }
            catch (ResourceManagerException re) {
                throw new ServiceAccessException((Service)this, (Throwable)re);
            }
        }
        throw new ServiceAccessException((Service)this, cause);
    }

    protected Object getActiveTxId() {
        Object txId = this.activeTransactionBranch.get();
        return txId;
    }

    protected XAException createXAException(ResourceManagerException e) {
        if (e.getStatus() == 1004) {
            return new XAException(-8);
        }
        if (e.getStatus() == 1001) {
            return new XAException(-4);
        }
        return new XAException(e.toString());
    }

    protected String wrap(Xid xid) {
        String sxid = XidWrapper.wrap((Xid)xid).toString();
        sxid = sxid.replace('\'', '.').replace('\"', '.').replace(':', '.').replace('/', '.').replace('\\', '.');
        return sxid;
    }

    protected abstract String getLogChannel();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

