/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.txfile;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.transaction.file.FileSequence;
import org.apache.commons.transaction.file.ResourceManagerException;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.slide.common.AbstractServiceBase;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.store.SequenceStore;
import org.apache.slide.util.logger.TxLogger;

public class FileSequenceStore
extends AbstractServiceBase
implements SequenceStore {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$store$txfile$FileSequenceStore == null ? (class$org$apache$slide$store$txfile$FileSequenceStore = FileSequenceStore.class$("org.apache.slide.store.txfile.FileSequenceStore")) : class$org$apache$slide$store$txfile$FileSequenceStore).getName();
    protected static final String STORE_DIR_PARAMETER = "rootpath";
    protected FileSequence fileSequence;
    protected String storeDir = null;
    protected Map sequenceHash = new HashMap();
    protected int sequenceIncrement = 100;
    protected long sequenceStartValue = 1L;
    static /* synthetic */ Class class$org$apache$slide$store$txfile$FileSequenceStore;

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        this.storeDir = (String)parameters.get(STORE_DIR_PARAMETER);
        if (this.storeDir == null) {
            throw new ServiceParameterMissingException((Service)this, STORE_DIR_PARAMETER);
        }
        try {
            this.fileSequence = new FileSequence(this.storeDir, (LoggerFacade)new TxLogger(this.getLogger(), LOG_CHANNEL));
            this.getLogger().log((Object)("File Sequence Store configured to " + this.storeDir), LOG_CHANNEL, 6);
        }
        catch (ResourceManagerException e) {
            this.getLogger().log((Object)"Can not initialize File Sequence Store", (Throwable)e, LOG_CHANNEL, 1);
            throw new ServiceParameterErrorException((Service)this, STORE_DIR_PARAMETER);
        }
    }

    public String toString() {
        return "FileSequenceStore at " + this.storeDir;
    }

    public void connect() throws ServiceConnectionFailedException {
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
    }

    public void reset() throws ServiceResetFailedException {
    }

    public boolean isConnected() throws ServiceAccessException {
        return true;
    }

    public boolean isSequenceSupported() {
        return true;
    }

    public boolean sequenceExists(String sequenceName) throws ServiceAccessException {
        SeqContext seq = (SeqContext)this.sequenceHash.get(sequenceName);
        if (seq != null) {
            return true;
        }
        return this.fileSequence.exists(sequenceName);
    }

    public synchronized boolean createSequence(String sequenceName) throws ServiceAccessException {
        try {
            if (this.fileSequence.create(sequenceName, this.sequenceStartValue)) {
                this.sequenceHash.put(sequenceName, new SeqContext(sequenceName, this.sequenceStartValue, this.sequenceStartValue));
                return true;
            }
            return false;
        }
        catch (ResourceManagerException e) {
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public synchronized long nextSequenceValue(String sequenceName) throws ServiceAccessException {
        SeqContext seq = (SeqContext)this.sequenceHash.get(sequenceName);
        if (seq != null && seq.pos < seq.end - 1L) {
            ++seq.pos;
            return seq.pos;
        }
        try {
            long pos;
            if (seq == null) {
                seq = new SeqContext(sequenceName);
                this.sequenceHash.put(sequenceName, seq);
            }
            seq.pos = pos = this.fileSequence.nextSequenceValueBottom(sequenceName, (long)this.sequenceIncrement);
            seq.end = seq.pos + (long)this.sequenceIncrement;
            return seq.pos;
        }
        catch (ResourceManagerException e) {
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
    }

    public void end(Xid xid, int flags) throws XAException {
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource == this;
    }

    public int prepare(Xid xid) throws XAException {
        return 3;
    }

    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    public void rollback(Xid xid) throws XAException {
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return true;
    }

    public void start(Xid xid, int flags) throws XAException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class SeqContext {
        public String name;
        public long pos;
        public long end;

        public SeqContext(String name) {
            this(name, -1L, -1L);
        }

        public SeqContext(String name, long pos, long end) {
            this.name = name;
            this.pos = pos;
            this.end = end;
        }
    }
}

