/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.portal.PortalException;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PersonManagerFactory;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.StatsRecorder;
import org.jasig.portal.utils.ResourceLoader;

public class LogoutServlet
extends HttpServlet {
    private static boolean INITIALIZED = false;
    private static String DEFAULT_REDIRECT;
    private static HashMap REDIRECT_MAP;
    static /* synthetic */ Class class$org$jasig$portal$LogoutServlet;

    public void init() {
        if (!INITIALIZED) {
            String upFile = "render.userLayoutRootNode.uP";
            HashMap<String, String> rdHash = new HashMap<String, String>(1);
            try {
                upFile = UPFileSpec.buildUPFile(null, 0, "userLayoutRootNode", null, null);
                Properties props = ResourceLoader.getResourceAsProperties(class$org$jasig$portal$LogoutServlet == null ? (class$org$jasig$portal$LogoutServlet = LogoutServlet.class$("org.jasig.portal.LogoutServlet")) : class$org$jasig$portal$LogoutServlet, "/properties/security.properties");
                Enumeration<?> propNames = props.propertyNames();
                while (propNames.hasMoreElements()) {
                    String propName = (String)propNames.nextElement();
                    String propValue = props.getProperty(propName);
                    if (!propName.startsWith("logoutRedirect.")) continue;
                    String key = propName.substring(15);
                    key = key.startsWith("root.") ? key.substring(5) : key;
                    LogService.log(LogService.DEBUG, "LogoutServlet::initializer() Redirect key = " + key);
                    LogService.log(LogService.DEBUG, "LogoutServlet::initializer() Redirect value = " + propValue);
                    rdHash.put(key, propValue);
                }
            }
            catch (PortalException pe) {
                LogService.log(LogService.ERROR, "LogoutServlet::static " + pe);
                LogService.log(LogService.ERROR, pe);
            }
            catch (IOException ioe) {
                LogService.log(LogService.ERROR, "LogoutServlet::static " + ioe);
                LogService.log(LogService.ERROR, ioe);
            }
            REDIRECT_MAP = rdHash;
            DEFAULT_REDIRECT = upFile;
            INITIALIZED = true;
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.init();
        String redirect = this.getRedirectionUrl(request);
        HttpSession session = request.getSession(false);
        try {
            IPerson person = PersonManagerFactory.getPersonManagerInstance().getPerson(request);
            StatsRecorder.recordLogout(person);
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
        if (session != null) {
            session.invalidate();
        }
        response.sendRedirect(redirect);
    }

    private String getRedirectionUrl(HttpServletRequest request) {
        String redirect = null;
        String defaultRedirect = request.getContextPath() + '/' + DEFAULT_REDIRECT;
        IPerson person = null;
        if (REDIRECT_MAP == null) {
            return defaultRedirect;
        }
        try {
            person = PersonManagerFactory.getPersonManagerInstance().getPerson(request);
            ISecurityContext securityContext = person.getSecurityContext();
            if (securityContext.isAuthenticated()) {
                LogService.log(LogService.DEBUG, "LogoutServlet::getRedirectionUrl() Looking for redirect string for the root context");
                redirect = (String)REDIRECT_MAP.get("root");
                if (redirect != null && !redirect.equals("")) {
                    return redirect;
                }
            }
            Enumeration subCtxNames = securityContext.getSubContextNames();
            while (subCtxNames.hasMoreElements()) {
                String subCtxName = (String)subCtxNames.nextElement();
                LogService.log(LogService.DEBUG, "LogoutServlet::getRedirectionUrl()  subCtxName = " + subCtxName);
                ISecurityContext sc = securityContext.getSubContext(subCtxName);
                LogService.log(LogService.DEBUG, "LogoutServlet::getRedirectionUrl() subCtxName isAuth = " + sc.isAuthenticated());
                if (!sc.isAuthenticated()) continue;
                LogService.log(LogService.DEBUG, "LogoutServlet::getRedirectionUrl() Looking for redirect string for subCtxName = " + subCtxName);
                redirect = (String)REDIRECT_MAP.get(subCtxName);
                if (redirect == null || redirect.equals("")) continue;
                LogService.log(LogService.DEBUG, "LogoutServlet::getRedirectionUrl() subCtxName redirect = " + redirect);
                break;
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "LogoutServlet::getRedirectionUrl() Error: " + e);
            LogService.log(LogService.ERROR, e);
        }
        if (redirect == null) {
            redirect = defaultRedirect;
        }
        LogService.log(LogService.DEBUG, "LogoutServlet::getRedirectionUrl() redirectionURL = " + redirect);
        return redirect;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

