/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.IMultithreadedCacheable;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.BaseMultithreadedChannel;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

public class CApplet
extends BaseMultithreadedChannel
implements IMultithreadedCacheable {
    private static final String sslLocation = "CApplet/CApplet.ssl";

    public void renderXML(ContentHandler out, String uid) throws PortalException {
        BaseMultithreadedChannel.ChannelState channelState = (BaseMultithreadedChannel.ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pce) {
            LogService.log(LogService.ERROR, pce);
            throw new GeneralRenderingException(pce.getMessage());
        }
        Element appletE = doc.createElement("applet");
        appletE.setAttribute("code", staticData.getParameter("code"));
        appletE.setAttribute("codebase", staticData.getParameter("codeBase"));
        appletE.setAttribute("width", staticData.getParameter("width"));
        appletE.setAttribute("height", staticData.getParameter("height"));
        appletE.setAttribute("align", "top");
        appletE.setAttribute("border", "0");
        appletE.setAttribute("archive", staticData.getParameter("archive"));
        Enumeration allKeys = staticData.keys();
        while (allKeys.hasMoreElements()) {
            String p = (String)allKeys.nextElement();
            if (!p.startsWith("APPLET.")) continue;
            Element paramE = doc.createElement("param");
            paramE.setAttribute("name", p.substring(7));
            paramE.setAttribute("value", staticData.getParameter(p));
            appletE.appendChild(paramE);
        }
        doc.appendChild(appletE);
        XSLT xslt = XSLT.getTransformer(this, runtimeData.getLocales());
        xslt.setXML(doc);
        xslt.setXSL(sslLocation, "main", runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.transform();
    }

    public ChannelCacheKey generateKey(String uid) {
        ChannelCacheKey key = new ChannelCacheKey();
        key.setKey(this.getKey(uid));
        key.setKeyScope(1);
        key.setKeyValidity(null);
        return key;
    }

    public boolean isCacheValid(Object validity, String uid) {
        return true;
    }

    private String getKey(String uid) {
        BaseMultithreadedChannel.ChannelState channelState = (BaseMultithreadedChannel.ChannelState)channelStateMap.get(uid);
        ChannelStaticData staticData = channelState.getStaticData();
        ChannelRuntimeData runtimeData = channelState.getRuntimeData();
        StringBuffer sbKey = new StringBuffer(1024);
        sbKey.append("org.jasig.portal.channels.CApplet").append(": ");
        sbKey.append("xslUri:");
        try {
            String sslUrl = ResourceLoader.getResourceAsURLString(this.getClass(), sslLocation);
            sbKey.append(XSLT.getStylesheetURI(sslUrl, runtimeData.getBrowserInfo())).append(", ");
        }
        catch (PortalException pe) {
            sbKey.append("Not available, ");
        }
        sbKey.append("staticData:").append(staticData.toString());
        sbKey.append("locales:").append(LocaleManager.stringValueOf(runtimeData.getLocales()));
        return sbKey.toString();
    }
}

