/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jasig.portal.IUserLayoutStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.UserProfile;
import org.jasig.portal.layout.ALChannel;
import org.jasig.portal.layout.ALChannelDescription;
import org.jasig.portal.layout.ALFolder;
import org.jasig.portal.layout.ALFolderDescription;
import org.jasig.portal.layout.ALNode;
import org.jasig.portal.layout.AggregatedLayout;
import org.jasig.portal.layout.AggregatedUserLayoutStore;
import org.jasig.portal.layout.IALChannelDescription;
import org.jasig.portal.layout.IALFolderDescription;
import org.jasig.portal.layout.IALNodeDescription;
import org.jasig.portal.layout.IAggregatedUserLayoutManager;
import org.jasig.portal.layout.IUserLayout;
import org.jasig.portal.layout.IUserLayoutNodeDescription;
import org.jasig.portal.layout.LayoutEventListener;
import org.jasig.portal.layout.restrictions.IUserLayoutRestriction;
import org.jasig.portal.layout.restrictions.PriorityRestriction;
import org.jasig.portal.layout.restrictions.UserLayoutRestriction;
import org.jasig.portal.layout.restrictions.UserLayoutRestrictionFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.CommonUtils;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.GuidGenerator;
import org.jasig.portal.utils.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;

public class AggregatedLayoutManager
implements IAggregatedUserLayoutManager {
    private AggregatedUserLayoutStore layoutStore;
    private AggregatedLayout layout;
    private UserProfile userProfile;
    private static final String lostFolderId = "lost_folder";
    private IPerson person;
    private IALNodeDescription addTargetsNodeDesc;
    private String moveTargetsNodeId;
    private int restrictionMask = 0;
    private boolean autoCommit = false;
    private String fragmentId;
    private Hashtable fragments;
    private static GuidGenerator guid = null;
    private String cacheKey = null;

    public AggregatedLayoutManager(IPerson person, UserProfile userProfile) throws Exception {
        this.person = person;
        this.userProfile = userProfile;
        this.layout = new AggregatedLayout(String.valueOf(this.getLayoutId()), this);
        this.autoCommit = false;
        if (guid == null) {
            guid = new GuidGenerator();
        }
        this.updateCacheKey();
    }

    public AggregatedLayoutManager(IPerson person, UserProfile userProfile, IUserLayoutStore layoutStore) throws Exception {
        this(person, userProfile);
        this.layoutStore = (AggregatedUserLayoutStore)layoutStore;
        this.loadUserLayout();
    }

    private void updateCacheKey() {
        this.cacheKey = guid.getNewGuid();
    }

    public IUserLayout getUserLayout() throws PortalException {
        return this.layout;
    }

    public void setUserLayout(IUserLayout userLayout) throws PortalException {
        if (!(this.layout instanceof AggregatedLayout)) {
            throw new PortalException("The user layout instance must have AggregatedLayout type!");
        }
        this.layout = this.layout;
        this.updateCacheKey();
    }

    public IUserLayoutNodeDescription createNodeDescription(int nodeType) throws PortalException {
        switch (nodeType) {
            case 2: {
                return new ALFolderDescription();
            }
            case 1: {
                return new ALChannelDescription();
            }
        }
        return null;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public int getLayoutId() {
        return this.userProfile.getLayoutId();
    }

    public String getParentId(String nodeId) throws PortalException {
        return this.layout.getParentId(nodeId);
    }

    public Enumeration getChildIds(String nodeId) throws PortalException {
        return this.layout.getChildIds(nodeId);
    }

    public String getPreviousSiblingId(String nodeId) throws PortalException {
        return this.layout.getPreviousSiblingId(nodeId);
    }

    public String getNextSiblingId(String nodeId) throws PortalException {
        return this.layout.getNextSiblingId(nodeId);
    }

    protected boolean checkRestriction(String nodeId, int restrictionType, String restrictionPath, String propertyValue) throws PortalException {
        ALNode node = this.getLayoutNode(nodeId);
        return node != null ? this.checkRestriction(node, restrictionType, restrictionPath, propertyValue) : true;
    }

    protected boolean checkRestriction(String nodeId, int restrictionType, String propertyValue) throws PortalException {
        return nodeId != null ? this.checkRestriction(nodeId, restrictionType, UserLayoutRestriction.LOCAL_RESTRICTION, propertyValue) : true;
    }

    protected boolean checkRestriction(ALNode node, int restrictionType, String restrictionPath, String propertyValue) throws PortalException {
        IUserLayoutRestriction restriction = node.getRestriction(UserLayoutRestriction.getRestrictionName(restrictionType, restrictionPath));
        if (restriction != null) {
            return restriction.checkRestriction(propertyValue);
        }
        return true;
    }

    private void moveWrongFragmentsToLostFolder() throws PortalException {
        Enumeration nodes = this.layoutStore.getIncorrectPushedFragmentNodes(this.person, this.userProfile);
        while (nodes.hasMoreElements()) {
            String nodeId = (String)nodes.nextElement();
            ALNode node = this.getLayoutNode(nodeId);
            if (node == null || nodeId == null || this.moveNodeToLostFolder(nodeId)) continue;
            LogService.log(LogService.INFO, "Unable to move the pushed fragment with ID=" + node.getFragmentId() + " to the lost folder");
        }
    }

    protected void moveWrongNodesToLostFolder() throws PortalException {
        this.moveWrongNodesToLostFolder(this.getRootFolderId(), 0);
    }

    private void moveWrongNodesToLostFolder(String nodeId, int depth) throws PortalException {
        String parentNodeId;
        String tmpNodeId;
        boolean isFolder;
        ALNode node = this.getLayoutNode(nodeId);
        Vector restrictions = node.getRestrictionsByPath(UserLayoutRestriction.LOCAL_RESTRICTION);
        for (int i = 0; i < restrictions.size(); ++i) {
            IUserLayoutRestriction restriction = (IUserLayoutRestriction)restrictions.get(i);
            if ((restriction.getRestrictionType() & 3) != 0 || restriction.checkRestriction(node)) continue;
            this.moveNodeToLostFolder(nodeId);
            break;
        }
        if (!this.checkRestriction(nodeId, 2, depth + "")) {
            this.moveNodeToLostFolder(nodeId);
        }
        restrictions = node.getRestrictionsByPath("children");
        boolean bl = isFolder = node.getNodeType() == 2;
        if (isFolder) {
            for (int i = 0; i < restrictions.size(); ++i) {
                IUserLayoutRestriction restriction = (IUserLayoutRestriction)restrictions.get(i);
                String nextId = ((ALFolder)node).getFirstChildNodeId();
                while (nextId != null) {
                    ALNode nextNode = this.getLayoutNode(nextId);
                    tmpNodeId = nextNode.getNextNodeId();
                    if ((restriction.getRestrictionType() & 2) == 0 && !restriction.checkRestriction(nextNode)) {
                        this.moveNodeToLostFolder(nextId);
                    }
                    nextId = tmpNodeId;
                }
            }
        }
        if ((parentNodeId = node.getParentNodeId()) != null) {
            restrictions = node.getRestrictionsByPath("parent");
            ALNode parentNode = this.getLayoutNode(parentNodeId);
            for (int i = 0; i < restrictions.size(); ++i) {
                IUserLayoutRestriction restriction = (IUserLayoutRestriction)restrictions.get(i);
                if ((restriction.getRestrictionType() & 2) != 0 || restriction.checkRestriction(parentNode)) continue;
                this.moveNodeToLostFolder(nodeId);
                break;
            }
        }
        if (isFolder) {
            String firstChildId;
            ++depth;
            String nextId = firstChildId = ((ALFolder)node).getFirstChildNodeId();
            while (nextId != null) {
                ALNode tmpNode = this.getLayoutNode(nextId);
                tmpNodeId = tmpNode.getNextNodeId();
                if (nextId.equals(firstChildId)) {
                    while (!this.changeSiblingNodesOrder(firstChildId)) {
                        this.moveNodeToLostFolder(this.getLastSiblingNode(firstChildId).getId());
                    }
                }
                this.moveWrongNodesToLostFolder(nextId, depth);
                nextId = tmpNodeId;
            }
        }
    }

    public String getLostFolderXML() throws PortalException {
        Document document = DocumentFactory.getNewDocument();
        this.layout.writeTo(lostFolderId, document);
        return XML.serializeNode(document);
    }

    protected boolean checkRestriction(ALNode node, int restrictionType, String propertyValue) throws PortalException {
        return this.checkRestriction(node, restrictionType, UserLayoutRestriction.LOCAL_RESTRICTION, propertyValue);
    }

    private boolean checkAddRestrictions(IALNodeDescription nodeDesc, String parentId, String nextSiblingId) throws PortalException {
        String newNodeId = nodeDesc.getId();
        ALNode newNode = null;
        newNode = newNodeId == null ? (nodeDesc instanceof IALChannelDescription ? new ALChannel((IALChannelDescription)nodeDesc) : new ALFolder((IALFolderDescription)nodeDesc)) : this.getLayoutNode(newNodeId);
        ALNode parentNode = this.getLayoutNode(parentId);
        if (parentNode.getNodeType() != 2) {
            throw new PortalException("The target parent node should be a folder!");
        }
        if (!parentNode.getNodeDescription().isImmutable()) {
            IUserLayoutRestriction restriction;
            int i;
            Vector restrictions = parentNode.getRestrictionsByPath("children");
            for (i = 0; i < restrictions.size(); ++i) {
                restriction = (IUserLayoutRestriction)restrictions.get(i);
                if ((restriction.getRestrictionType() & 2) != 0 || restriction.checkRestriction(newNode)) continue;
                return false;
            }
            restrictions = newNode.getRestrictionsByPath("parent");
            for (i = 0; i < restrictions.size(); ++i) {
                restriction = (IUserLayoutRestriction)restrictions.get(i);
                if ((restriction.getRestrictionType() & 2) != 0 || restriction.checkRestriction(parentNode)) continue;
                return false;
            }
            if (newNodeId != null) {
                if (!this.checkDepthRestrictions(newNodeId, parentId)) {
                    return false;
                }
            } else {
                return this.checkRestriction(newNode, 2, this.getDepth(parentId) + 1 + "");
            }
            return this.changeSiblingNodesPriorities(newNode, parentId, nextSiblingId, false);
        }
        return false;
    }

    private boolean checkMoveRestrictions(String nodeId, String newParentId, String nextSiblingId) throws PortalException {
        ALNode node = this.getLayoutNode(nodeId);
        ALNode oldParentNode = this.getLayoutNode(node.getParentNodeId());
        ALNode newParentNode = this.getLayoutNode(newParentId);
        if (!oldParentNode.getNodeDescription().isImmutable() && !newParentNode.getNodeDescription().isImmutable()) {
            if (!oldParentNode.equals(newParentNode)) {
                IUserLayoutRestriction restriction;
                int i;
                Vector restrictions = newParentNode.getRestrictionsByPath("children");
                for (i = 0; i < restrictions.size(); ++i) {
                    restriction = (IUserLayoutRestriction)restrictions.get(i);
                    if ((restriction.getRestrictionType() & 2) != 0 || restriction.checkRestriction(node)) continue;
                    return false;
                }
                restrictions = node.getRestrictionsByPath("parent");
                for (i = 0; i < restrictions.size(); ++i) {
                    restriction = (IUserLayoutRestriction)restrictions.get(i);
                    if ((restriction.getRestrictionType() & 2) != 0 || restriction.checkRestriction(newParentNode)) continue;
                    return false;
                }
                if (!this.checkDepthRestrictions(nodeId, newParentId)) {
                    return false;
                }
            }
            return this.changeSiblingNodesPriorities(node, newParentId, nextSiblingId, false);
        }
        return false;
    }

    private boolean checkDeleteRestrictions(String nodeId) throws PortalException {
        ALNode node = this.getLayoutNode(nodeId);
        if (nodeId == null || node == null) {
            return true;
        }
        if (!this.getLayoutNode(node.getParentNodeId()).getNodeDescription().isImmutable()) {
            return !node.getNodeDescription().isUnremovable();
        }
        return false;
    }

    private boolean checkDepthRestrictions(String nodeId, String newParentId) throws PortalException {
        int parentDepth;
        if (nodeId == null) {
            return true;
        }
        int nodeDepth = this.getDepth(nodeId);
        if (nodeDepth == (parentDepth = this.getDepth(newParentId)) + 1) {
            return true;
        }
        return this.checkDepthRestrictions(nodeId, newParentId, nodeDepth);
    }

    private boolean checkDepthRestrictions(String nodeId, String newParentId, int parentDepth) throws PortalException {
        ALNode node = this.getLayoutNode(nodeId);
        if (!this.checkRestriction(nodeId, 2, parentDepth + 1 + "")) {
            return false;
        }
        if (node.getNodeType() == 2) {
            String nextId = ((ALFolder)node).getFirstChildNodeId();
            while (nextId != null) {
                node = this.getLayoutNode(nextId);
                if (!this.checkDepthRestrictions(nextId, node.getParentNodeId(), parentDepth + 1)) {
                    return false;
                }
                nextId = node.getNextNodeId();
            }
        }
        return true;
    }

    private int getDepth(String nodeId) throws PortalException {
        int depth = 0;
        String parentId = nodeId;
        while (parentId != null) {
            parentId = this.getLayoutNode(parentId).getParentNodeId();
            ++depth;
        }
        return depth;
    }

    private boolean moveNodeToLostFolder(String nodeId) throws PortalException {
        ALFolder lostFolder = this.getLayoutFolder(lostFolderId);
        if (lostFolder == null) {
            lostFolder = ALFolder.createLostFolder();
        }
        return this.moveNode(nodeId, lostFolder.getId(), null);
    }

    private static IUserLayoutRestriction getRestriction(ALNode node, int restrictionType, String restrictionPath) throws PortalException {
        return node.getRestriction(UserLayoutRestriction.getRestrictionName(restrictionType, restrictionPath));
    }

    public static PriorityRestriction getPriorityRestriction(ALNode node) throws PortalException {
        PriorityRestriction priorRestriction = AggregatedLayoutManager.getPriorityRestriction(node, UserLayoutRestriction.LOCAL_RESTRICTION);
        if (priorRestriction == null) {
            priorRestriction = (PriorityRestriction)UserLayoutRestrictionFactory.createRestriction(1, "0-2147483647", UserLayoutRestriction.LOCAL_RESTRICTION);
        }
        return priorRestriction;
    }

    private static PriorityRestriction getPriorityRestriction(ALNode node, String restrictionPath) throws PortalException {
        return (PriorityRestriction)AggregatedLayoutManager.getRestriction(node, 1, restrictionPath);
    }

    protected boolean changeSiblingNodesPriorities(String nodeId) throws PortalException {
        ALNode firstNode = this.getFirstSiblingNode(nodeId);
        String parentId = firstNode.getParentNodeId();
        String id = firstNode.getId();
        while (id != null) {
            String nextId;
            ALNode node = this.getLayoutNode(id);
            if (!this.changeSiblingNodesPriorities(node, parentId, nextId = node.getNextNodeId(), false)) {
                return false;
            }
            id = nextId;
        }
        return true;
    }

    protected boolean changeSiblingNodesPriorities(ALNode node, String parentNodeId, String nextNodeId, boolean justCheck) throws PortalException {
        ALNode firstNode = null;
        ALNode nextNode = null;
        String firstNodeId = null;
        int priority = 0;
        int nextPriority = 0;
        int prevPriority = 0;
        int[] range = null;
        int[] prevRange = null;
        int[] nextRange = null;
        PriorityRestriction priorityRestriction = null;
        String nodeId = node.getId();
        ALFolder parent = this.getLayoutFolder(parentNodeId);
        if (parentNodeId != null) {
            firstNodeId = parent.getFirstChildNodeId();
            if (nodeId.equals(firstNodeId)) {
                firstNodeId = node.getNextNodeId();
            }
            if (firstNodeId == null) {
                return true;
            }
        } else {
            return false;
        }
        firstNode = this.getLayoutNode(firstNodeId);
        if (nextNodeId != null) {
            nextNode = this.getLayoutNode(nextNodeId);
            nextPriority = nextNode.getPriority();
            priorityRestriction = AggregatedLayoutManager.getPriorityRestriction(nextNode);
            nextRange = priorityRestriction.getRange();
        }
        priority = node.getPriority();
        priorityRestriction = AggregatedLayoutManager.getPriorityRestriction(node);
        range = priorityRestriction.getRange();
        if (firstNodeId.equals(nextNodeId)) {
            if (range[1] <= nextRange[0]) {
                return false;
            }
            if (priority > nextPriority) {
                return true;
            }
            if (range[1] > nextPriority) {
                if (!justCheck) {
                    node.setPriority(range[1]);
                }
                return true;
            }
            if (nextPriority + 1 <= range[1] && nextPriority + 1 >= range[0]) {
                if (!justCheck) {
                    node.setPriority(nextPriority + 1);
                }
                return true;
            }
        }
        if (nextNode == null) {
            ALNode lastNode = this.getLastSiblingNode(firstNodeId);
            if (nodeId.equals(lastNode.getId())) {
                lastNode = this.getLayoutNode(lastNode.getPreviousNodeId());
            }
            int lastPriority = lastNode.getPriority();
            PriorityRestriction lastPriorityRestriction = AggregatedLayoutManager.getPriorityRestriction(lastNode);
            int[] lastRange = lastPriorityRestriction.getRange();
            if (range[0] >= lastRange[1]) {
                return false;
            }
            if (priority < lastPriority) {
                return true;
            }
            if (range[0] < lastPriority) {
                if (!justCheck) {
                    node.setPriority(range[0]);
                }
                return true;
            }
            if (lastPriority - 1 <= range[1] && lastPriority - 1 >= range[0]) {
                if (!justCheck) {
                    node.setPriority(lastPriority - 1);
                }
                return true;
            }
        }
        if (nextNode != null && !nextNode.equals(firstNode) && !node.equals(nextNode)) {
            ALNode prevNode = this.getLayoutNode(nextNode.getPreviousNodeId());
            prevPriority = prevNode.getPriority();
            PriorityRestriction lastPriorityRestriction = AggregatedLayoutManager.getPriorityRestriction(prevNode);
            prevRange = lastPriorityRestriction.getRange();
            if (range[1] <= nextRange[0] || range[0] >= prevRange[1]) {
                return false;
            }
            if (priority < prevPriority && priority > nextPriority) {
                return true;
            }
            int maxPossibleLowValue = Math.max(range[0], nextPriority + 1);
            int minPossibleHighValue = Math.min(range[1], prevPriority - 1);
            if (minPossibleHighValue >= maxPossibleLowValue) {
                if (!justCheck) {
                    node.setPriority(minPossibleHighValue);
                }
                return true;
            }
        }
        Vector<Integer> priorities = null;
        if (!justCheck) {
            priorities = new Vector<Integer>();
        }
        int tmpPriority = Integer.MAX_VALUE;
        String nextId = firstNodeId;
        while (nextId != null) {
            ALNode curNode = this.getLayoutNode(nextId);
            if (nextId.equals(node.getId())) {
                nextId = curNode.getNextNodeId();
                continue;
            }
            int[] curRange = nextId.equals(nextNodeId) ? nextRange : AggregatedLayoutManager.getPriorityRestriction(curNode).getRange();
            int value = Math.min(curRange[1], tmpPriority - 1);
            if (value < tmpPriority) {
                if (!justCheck) {
                    priorities.add(new Integer(value));
                }
            } else {
                return false;
            }
            tmpPriority = value;
            nextId = curNode.getNextNodeId();
        }
        if (!justCheck) {
            int i = 0;
            String nextId2 = firstNodeId;
            while (nextId2 != null) {
                ALNode curNode = this.getLayoutNode(nextId2);
                if (nextId2.equals(node.getId())) {
                    nextId2 = curNode.getNextNodeId();
                    --i;
                } else {
                    int prior = (Integer)priorities.get(i);
                    if (nextId2.equals(nextNodeId)) {
                        nextNode.setPriority(prior);
                    } else {
                        curNode.setPriority(prior);
                    }
                    nextId2 = curNode.getNextNodeId();
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean changeSiblingNodesOrder(String firstNodeId) throws PortalException {
        String lastNodeId;
        if (firstNodeId == null) {
            throw new PortalException("The first node ID in the sibling line cannot be NULL!");
        }
        ALNode firstNode = this.getLayoutNode(firstNodeId);
        String parentNodeId = firstNode.getParentNodeId();
        boolean rightOrder = true;
        ALNode node = null;
        String nextNodeId = firstNodeId;
        while (nextNodeId != null) {
            node = this.getLayoutNode(nextNodeId);
            if ((nextNodeId = node.getNextNodeId()) == null) continue;
            ALNode nextNode = this.getLayoutNode(nextNodeId);
            if (node.getPriority() > nextNode.getPriority()) continue;
            rightOrder = false;
            break;
        }
        if (rightOrder) {
            return true;
        }
        if (this.changeSiblingNodesPriorities(firstNodeId)) {
            return true;
        }
        ALNode lastNode = this.getLastSiblingNode(node.getId());
        String prevNodeId = lastNodeId = lastNode.getId();
        while (prevNodeId != null) {
            String nodeId = lastNodeId;
            while (nodeId != null) {
                if (!nodeId.equals(prevNodeId) && this.moveNode(prevNodeId, parentNodeId, nodeId) && this.changeSiblingNodesPriorities(firstNodeId)) {
                    return true;
                }
                nodeId = this.getLayoutNode(nodeId).getPreviousNodeId();
            }
            if (this.moveNode(prevNodeId, parentNodeId, null) && this.changeSiblingNodesPriorities(firstNodeId)) {
                return true;
            }
            prevNodeId = this.getLayoutNode(prevNodeId).getPreviousNodeId();
        }
        return false;
    }

    public String getCacheKey() throws PortalException {
        return this.cacheKey;
    }

    public void getUserLayout(ContentHandler contentHandler) throws PortalException {
        this.layout.writeTo(contentHandler);
    }

    public void getUserLayout(String nodeId, ContentHandler contentHandler) throws PortalException {
        this.layout.writeTo(nodeId, contentHandler);
    }

    private ALNode getLayoutNode(String nodeId) {
        return this.layout.getLayoutNode(nodeId);
    }

    private ALFolder getLayoutFolder(String folderId) {
        return this.layout.getLayoutFolder(folderId);
    }

    private ALNode getLastSiblingNode(String nodeId) {
        return this.layout.getLastSiblingNode(nodeId);
    }

    private ALNode getFirstSiblingNode(String nodeId) {
        return this.layout.getFirstSiblingNode(nodeId);
    }

    public Document getUserLayoutDOM() throws PortalException {
        Document document = DocumentFactory.getNewDocument();
        this.layout.writeTo(document);
        return document;
    }

    private void setUserLayoutDOM(Node n, String parentNodeId, Hashtable layoutData) throws PortalException {
        String id;
        Element node = (Element)n;
        NodeList childNodes = node.getChildNodes();
        IALNodeDescription nodeDesc = ALNode.createUserLayoutNodeDescription(node);
        String nodeId = node.getAttribute("ID");
        nodeDesc.setId(nodeId);
        nodeDesc.setName(node.getAttribute("name"));
        nodeDesc.setFragmentId(node.getAttribute("fragmentID"));
        nodeDesc.setHidden(CommonUtils.strToBool(node.getAttribute("hidden")));
        nodeDesc.setImmutable(CommonUtils.strToBool(node.getAttribute("immutable")));
        nodeDesc.setUnremovable(CommonUtils.strToBool(node.getAttribute("unremovable")));
        nodeDesc.setHidden(CommonUtils.strToBool(node.getAttribute("hidden")));
        ALNode layoutNode = null;
        IALChannelDescription channelDesc = null;
        if (nodeDesc instanceof IALChannelDescription) {
            channelDesc = (IALChannelDescription)nodeDesc;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String restrType;
            Node childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            NamedNodeMap attributes = childNode.getAttributes();
            if ("parameter".equals(nodeName) && channelDesc != null) {
                String overParam;
                Node paramNameNode = attributes.getNamedItem("name");
                String paramName = paramNameNode != null ? paramNameNode.getFirstChild().getNodeValue() : null;
                Node paramValueNode = attributes.getNamedItem("value");
                String paramValue = paramValueNode != null ? paramValueNode.getFirstChild().getNodeValue() : null;
                Node overParamNode = attributes.getNamedItem("override");
                String string = overParam = overParamNode != null ? overParamNode.getFirstChild().getNodeValue() : null;
                if (paramName == null) continue;
                channelDesc.setParameterValue(paramName, paramValue);
                channelDesc.setParameterOverride(paramName, "yes".equalsIgnoreCase(overParam));
                continue;
            }
            if (!"restriction".equals(nodeName)) continue;
            Node restrPathNode = attributes.getNamedItem("path");
            String restrPath = restrPathNode != null ? restrPathNode.getFirstChild().getNodeValue() : null;
            Node restrValueNode = attributes.getNamedItem("value");
            String restrValue = restrValueNode != null ? restrValueNode.getFirstChild().getNodeValue() : null;
            Node restrTypeNode = attributes.getNamedItem("type");
            String string = restrType = restrTypeNode != null ? restrTypeNode.getFirstChild().getNodeValue() : "0";
            if (restrValue == null) continue;
            IUserLayoutRestriction restriction = UserLayoutRestrictionFactory.createRestriction(CommonUtils.parseInt(restrType), restrValue, restrPath);
            nodeDesc.addRestriction(restriction);
        }
        if (channelDesc != null) {
            channelDesc.setChannelPublishId(node.getAttribute("chanID"));
            channelDesc.setChannelTypeId(node.getAttribute("typeID"));
            channelDesc.setClassName(node.getAttribute("class"));
            channelDesc.setDescription(node.getAttribute("description"));
            channelDesc.setEditable(CommonUtils.strToBool(node.getAttribute("editable")));
            channelDesc.setHasAbout(CommonUtils.strToBool(node.getAttribute("hasAbout")));
            channelDesc.setHasHelp(CommonUtils.strToBool(node.getAttribute("hasHelp")));
            channelDesc.setIsSecure(CommonUtils.strToBool(node.getAttribute("secure")));
            channelDesc.setFunctionalName(node.getAttribute("fname"));
            channelDesc.setTimeout(Long.parseLong(node.getAttribute("timeout")));
            channelDesc.setTitle(node.getAttribute("title"));
            layoutNode = new ALChannel(channelDesc);
        } else {
            layoutNode = new ALFolder((IALFolderDescription)nodeDesc);
        }
        layoutNode.setPriority(CommonUtils.parseInt(node.getAttribute("priority"), 0));
        ALFolder parentFolder = this.getLayoutFolder(parentNodeId);
        if (parentFolder != null) {
            layoutNode.setParentNodeId(parentNodeId);
        }
        Element nextNode = (Element)node.getNextSibling();
        Element prevNode = (Element)node.getPreviousSibling();
        if (nextNode != null && this.isNodeFolderOrChannel(nextNode)) {
            layoutNode.setNextNodeId(nextNode.getAttribute("ID"));
        }
        if (prevNode != null && this.isNodeFolderOrChannel(prevNode)) {
            layoutNode.setPreviousNodeId(prevNode.getAttribute("ID"));
        }
        if (((ALNode)layoutNode).getNodeType() == 2 && (id = ((Element)node.getFirstChild()).getAttribute("ID")) != null && id.length() > 0) {
            layoutNode.setFirstChildNodeId(id);
        }
        layoutData.put(nodeDesc.getId(), layoutNode);
        for (int i = 0; i < childNodes.getLength() && ((ALNode)layoutNode).getNodeType() == 2; ++i) {
            Element childNode = (Element)childNodes.item(i);
            if (!this.isNodeFolderOrChannel(childNode)) continue;
            this.setUserLayoutDOM(childNode, nodeDesc.getId(), layoutData);
        }
    }

    public void setUserLayoutDOM(Document domLayout) throws PortalException {
        Hashtable<String, ALFolder> layoutData = new Hashtable<String, ALFolder>();
        String rootId = this.getRootFolderId();
        Element rootNode = (Element)domLayout.getDocumentElement().getFirstChild();
        ALFolder rootFolder = new ALFolder((IALFolderDescription)ALNode.createUserLayoutNodeDescription(rootNode));
        rootFolder.setFirstChildNodeId(((Element)rootNode.getFirstChild()).getAttribute("ID"));
        layoutData.put(rootId, rootFolder);
        NodeList childNodes = rootNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            this.setUserLayoutDOM(childNodes.item(i), rootId, layoutData);
        }
        this.layout.setLayoutData(layoutData);
        this.updateCacheKey();
    }

    private boolean isNodeFolderOrChannel(Element node) {
        String nodeName = node.getNodeName();
        return "folder".equals(nodeName) || "channel".equals(nodeName);
    }

    public void setLayoutStore(IUserLayoutStore layoutStore) {
        this.layoutStore = (AggregatedUserLayoutStore)layoutStore;
    }

    public void loadUserLayout() throws PortalException {
        try {
            if (this.layoutStore != null) {
                this.fragmentId = null;
                this.layout = (AggregatedLayout)this.layoutStore.getAggregatedLayout(this.person, this.userProfile);
                this.layout.setLayoutManager(this);
                this.fragments = (Hashtable)this.layoutStore.getFragments(this.person);
                ALFolder rootFolder = this.getLayoutFolder(this.getRootFolderId());
                String firstChildId = rootFolder.getFirstChildNodeId();
                if (firstChildId != null && this.getLayoutNode(firstChildId) == null) {
                    rootFolder.setFirstChildNodeId(null);
                }
                this.moveWrongFragmentsToLostFolder();
                this.moveWrongNodesToLostFolder();
                this.updateCacheKey();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PortalException(e.getMessage());
        }
    }

    public void saveUserLayout() throws PortalException {
        try {
            if (!this.isLayoutFragment()) {
                this.layoutStore.setAggregatedLayout(this.person, this.userProfile, this.layout);
            }
            this.updateCacheKey();
        }
        catch (Exception e) {
            throw new PortalException(e.getMessage());
        }
    }

    public void loadFragment(String fragmentId) throws PortalException {
        try {
            if (fragmentId.equals("new_fragment")) {
                this.layout = new AggregatedLayout(String.valueOf(this.getLayoutId()), this);
                ALFolder rootFolder = ALFolder.createRootFolder();
                Hashtable<String, ALFolder> layoutData = new Hashtable<String, ALFolder>();
                layoutData.put(this.getRootFolderId(), rootFolder);
                this.layout.setLayoutData(layoutData);
            } else {
                this.layout = (AggregatedLayout)this.layoutStore.getFragment(this.person, fragmentId);
                this.layout.setLayoutManager(this);
            }
            this.fragments = (Hashtable)this.layoutStore.getFragments(this.person);
            this.fragmentId = fragmentId;
            this.moveWrongNodesToLostFolder();
            this.updateCacheKey();
        }
        catch (Exception e) {
            throw new PortalException(e.getMessage());
        }
    }

    public void saveFragment() throws PortalException {
        try {
            if (this.isLayoutFragment()) {
                this.layoutStore.setFragment(this.person, this.fragmentId, this.layout);
            }
            this.updateCacheKey();
        }
        catch (Exception e) {
            throw new PortalException(e.getMessage());
        }
    }

    private boolean isLayoutFragment() {
        return this.fragmentId != null && CommonUtils.parseInt(this.fragmentId) > 0;
    }

    public IUserLayoutNodeDescription getNode(String nodeId) throws PortalException {
        return this.layout.getNodeDescription(nodeId);
    }

    public synchronized boolean moveNode(String nodeId, String parentId, String nextSiblingId) throws PortalException {
        String firstChildId;
        if (!parentId.equals(lostFolderId) && !this.canMoveNode(nodeId, parentId, nextSiblingId)) {
            return false;
        }
        ALNode node = this.getLayoutNode(nodeId);
        ALFolder targetFolder = this.getLayoutFolder(parentId);
        ALFolder sourceFolder = this.getLayoutFolder(node.getParentNodeId());
        String sourcePrevNodeId = node.getPreviousNodeId();
        String sourceNextNodeId = node.getNextNodeId();
        ALNode targetNextNode = this.getLayoutNode(nextSiblingId);
        ALNode targetPrevNode = null;
        ALNode sourcePrevNode = null;
        ALNode sourceNextNode = null;
        String prevSiblingId = null;
        targetPrevNode = targetNextNode != null ? this.getLayoutNode(targetNextNode.getPreviousNodeId()) : this.getLastSiblingNode(targetFolder.getFirstChildNodeId());
        if (targetPrevNode != null) {
            targetPrevNode.setNextNodeId(nodeId);
            prevSiblingId = targetPrevNode.getId();
        }
        if (targetNextNode != null) {
            targetNextNode.setPreviousNodeId(nodeId);
        }
        if (nodeId.equals(sourceFolder.getFirstChildNodeId())) {
            sourceFolder.setFirstChildNodeId(node.getNextNodeId());
        }
        if ((firstChildId = targetFolder.getFirstChildNodeId()) == null || firstChildId.equals(nextSiblingId)) {
            targetFolder.setFirstChildNodeId(nodeId);
        }
        if (sourcePrevNodeId != null) {
            sourcePrevNode = this.getLayoutNode(sourcePrevNodeId);
            sourcePrevNode.setNextNodeId(sourceNextNodeId);
        }
        if (sourceNextNodeId != null) {
            sourceNextNode = this.getLayoutNode(sourceNextNodeId);
            sourceNextNode.setPreviousNodeId(sourcePrevNodeId);
        }
        node.setParentNodeId(parentId);
        node.setNextNodeId(nextSiblingId);
        node.setPreviousNodeId(prevSiblingId);
        boolean result = true;
        if (this.autoCommit) {
            if (sourcePrevNode != null) {
                result &= this.layoutStore.updateUserLayoutNode(this.person, this.userProfile, sourcePrevNode);
            }
            if (sourceNextNode != null) {
                result &= this.layoutStore.updateUserLayoutNode(this.person, this.userProfile, sourceNextNode);
            }
            if (targetPrevNode != null) {
                result &= this.layoutStore.updateUserLayoutNode(this.person, this.userProfile, targetPrevNode);
            }
            if (targetNextNode != null) {
                result &= this.layoutStore.updateUserLayoutNode(this.person, this.userProfile, targetNextNode);
            }
            result &= this.layoutStore.updateUserLayoutNode(this.person, this.userProfile, targetFolder);
            result &= this.layoutStore.updateUserLayoutNode(this.person, this.userProfile, sourceFolder);
            result &= this.layoutStore.updateUserLayoutNode(this.person, this.userProfile, node);
        }
        this.updateCacheKey();
        return result;
    }

    public synchronized boolean deleteNode(String nodeId) throws PortalException {
        if (nodeId == null) {
            return false;
        }
        ALNode node = this.getLayoutNode(nodeId);
        if (node == null) {
            return false;
        }
        if (!this.canDeleteNode(nodeId)) {
            LogService.log(LogService.DEBUG, "The node with ID = '" + nodeId + "' cannot be deleted");
            return false;
        }
        ALFolder parentFolder = this.getLayoutFolder(node.getParentNodeId());
        boolean result = false;
        if (nodeId.equals(parentFolder.getFirstChildNodeId())) {
            parentFolder.setFirstChildNodeId(node.getNextNodeId());
            if (this.autoCommit) {
                result = this.layoutStore.updateUserLayoutNode(this.person, this.userProfile, parentFolder);
            }
        }
        String prevSiblingId = node.getPreviousNodeId();
        String nextSiblingId = node.getNextNodeId();
        if (prevSiblingId != null) {
            ALNode prevNode = this.getLayoutNode(prevSiblingId);
            prevNode.setNextNodeId(nextSiblingId);
            if (this.autoCommit) {
                result = this.layoutStore.updateUserLayoutNode(this.person, this.userProfile, prevNode);
            }
        }
        if (nextSiblingId != null) {
            ALNode nextNode = this.getLayoutNode(nextSiblingId);
            nextNode.setPreviousNodeId(prevSiblingId);
            if (this.autoCommit) {
                result = this.layoutStore.updateUserLayoutNode(this.person, this.userProfile, nextNode);
            }
        }
        if (this.autoCommit) {
            result = this.layoutStore.deleteUserLayoutNode(this.person, this.userProfile, node);
        }
        result = this.layout.getLayoutData().remove(nodeId) != null && (!this.autoCommit || result);
        this.updateCacheKey();
        return result;
    }

    public synchronized IUserLayoutNodeDescription addNode(IUserLayoutNodeDescription nodeDesc, String parentId, String nextSiblingId) throws PortalException {
        if (!this.canAddNode(nodeDesc, parentId, nextSiblingId)) {
            return null;
        }
        ALFolder parentFolder = this.getLayoutFolder(parentId);
        ALNode nextNode = this.getLayoutNode(nextSiblingId);
        ALNode prevNode = null;
        prevNode = nextNode != null ? this.getLayoutNode(nextNode.getPreviousNodeId()) : this.getLastSiblingNode(parentFolder.getFirstChildNodeId());
        ALNode layoutNode = ALNode.createALNode(nodeDesc);
        layoutNode.setParentNodeId(parentId);
        if (prevNode != null) {
            layoutNode.setPreviousNodeId(prevNode.getId());
        }
        if (nextNode != null) {
            layoutNode.setNextNodeId(nextSiblingId);
        }
        layoutNode = this.layoutStore.addUserLayoutNode(this.person, this.userProfile, layoutNode);
        String nodeId = layoutNode.getId();
        this.layout.getLayoutData().put(nodeId, layoutNode);
        if (prevNode != null) {
            prevNode.setNextNodeId(nodeId);
        }
        if (nextNode != null) {
            nextNode.setPreviousNodeId(nodeId);
        }
        if (prevNode == null) {
            parentFolder.setFirstChildNodeId(nodeId);
        }
        if (nextNode != null) {
            this.layoutStore.updateUserLayoutNode(this.person, this.userProfile, nextNode);
        }
        if (prevNode != null) {
            this.layoutStore.updateUserLayoutNode(this.person, this.userProfile, prevNode);
        }
        this.layoutStore.updateUserLayoutNode(this.person, this.userProfile, parentFolder);
        this.updateCacheKey();
        return layoutNode.getNodeDescription();
    }

    private void changeDescendantsBooleanProperties(IALNodeDescription nodeDesc, IALNodeDescription oldNodeDesc, String nodeId) throws PortalException {
        this.changeDescendantsBooleanProperties(nodeDesc.isHidden() == oldNodeDesc.isHidden(), nodeDesc.isImmutable() == oldNodeDesc.isImmutable(), nodeDesc.isUnremovable() == oldNodeDesc.isUnremovable(), nodeDesc, nodeId);
        this.updateCacheKey();
    }

    private void changeDescendantsBooleanProperties(boolean hiddenValuesMatch, boolean immutableValuesMatch, boolean unremovableValuesMatch, IALNodeDescription nodeDesc, String nodeId) throws PortalException {
        ALNode node = this.getLayoutNode(nodeId);
        if (node.getNodeType() == 2) {
            String firstChildId;
            String nextNodeId = firstChildId = ((ALFolder)node).getFirstChildNodeId();
            while (nextNodeId != null) {
                String nextId;
                ALFolder folder;
                boolean canChange;
                ALNode currentNode = this.getLayoutNode(nextNodeId);
                if (!hiddenValuesMatch) {
                    canChange = this.checkRestriction(currentNode, 32, CommonUtils.boolToStr(nodeDesc.isHidden()));
                    canChange &= this.checkRestriction(currentNode.getParentNodeId(), 32, "children", CommonUtils.boolToStr(nodeDesc.isHidden()));
                    if (currentNode.getNodeType() == 2) {
                        folder = (ALFolder)node;
                        nextId = folder.getFirstChildNodeId();
                        while (nextId != null) {
                            canChange &= this.checkRestriction(nextId, 32, "parent", CommonUtils.boolToStr(nodeDesc.isHidden()));
                            nextId = this.getLayoutNode(nextId).getNextNodeId();
                        }
                    }
                    if (canChange) {
                        currentNode.getNodeDescription().setHidden(nodeDesc.isHidden());
                    }
                }
                if (!immutableValuesMatch) {
                    canChange = this.checkRestriction(currentNode, 8, CommonUtils.boolToStr(nodeDesc.isImmutable()));
                    canChange &= this.checkRestriction(currentNode.getParentNodeId(), 8, "children", CommonUtils.boolToStr(nodeDesc.isImmutable()));
                    if (currentNode.getNodeType() == 2) {
                        folder = (ALFolder)node;
                        nextId = folder.getFirstChildNodeId();
                        while (nextId != null) {
                            canChange &= this.checkRestriction(nextId, 8, "parent", CommonUtils.boolToStr(nodeDesc.isImmutable()));
                            nextId = this.getLayoutNode(nextId).getNextNodeId();
                        }
                    }
                    if (canChange) {
                        currentNode.getNodeDescription().setImmutable(nodeDesc.isImmutable());
                    }
                }
                if (!unremovableValuesMatch) {
                    canChange = this.checkRestriction(currentNode, 16, CommonUtils.boolToStr(nodeDesc.isUnremovable()));
                    canChange &= this.checkRestriction(currentNode.getParentNodeId(), 16, "children", CommonUtils.boolToStr(nodeDesc.isUnremovable()));
                    if (currentNode.getNodeType() == 2) {
                        folder = (ALFolder)node;
                        nextId = folder.getFirstChildNodeId();
                        while (nextId != null) {
                            canChange &= this.checkRestriction(nextId, 16, "parent", CommonUtils.boolToStr(nodeDesc.isImmutable()));
                            nextId = this.getLayoutNode(nextId).getNextNodeId();
                        }
                    }
                    if (canChange) {
                        currentNode.getNodeDescription().setUnremovable(nodeDesc.isUnremovable());
                    }
                }
                this.changeDescendantsBooleanProperties(hiddenValuesMatch, immutableValuesMatch, unremovableValuesMatch, nodeDesc, nextNodeId);
                nextNodeId = currentNode.getNextNodeId();
            }
        }
    }

    public synchronized boolean updateNode(IUserLayoutNodeDescription nodeDesc) throws PortalException {
        if (!this.canUpdateNode(nodeDesc)) {
            return false;
        }
        ALNode node = this.getLayoutNode(nodeDesc.getId());
        IALNodeDescription oldNodeDesc = node.getNodeDescription();
        this.changeDescendantsBooleanProperties((IALNodeDescription)nodeDesc, oldNodeDesc, nodeDesc.getId());
        node.setNodeDescription((IALNodeDescription)nodeDesc);
        this.updateCacheKey();
        if (this.autoCommit) {
            return this.layoutStore.updateUserLayoutNode(this.person, this.userProfile, node);
        }
        return true;
    }

    public boolean canAddNode(IUserLayoutNodeDescription nodeDesc, String parentId, String nextSiblingId) throws PortalException {
        return this.checkAddRestrictions((IALNodeDescription)nodeDesc, parentId, nextSiblingId);
    }

    public boolean canMoveNode(String nodeId, String parentId, String nextSiblingId) throws PortalException {
        return this.checkMoveRestrictions(nodeId, parentId, nextSiblingId);
    }

    public boolean canDeleteNode(String nodeId) throws PortalException {
        return this.checkDeleteRestrictions(nodeId);
    }

    public boolean canUpdateNode(IUserLayoutNodeDescription nodeDescription) throws PortalException {
        IALNodeDescription nodeDesc = (IALNodeDescription)nodeDescription;
        String nodeId = nodeDesc.getId();
        if (nodeId == null) {
            return false;
        }
        ALNode node = this.getLayoutNode(nodeId);
        IALNodeDescription currentNodeDesc = node.getNodeDescription();
        if (!nodeId.equals(currentNodeDesc.getId())) {
            return false;
        }
        if (currentNodeDesc.isImmutable()) {
            return false;
        }
        if (AggregatedLayoutManager.getRestriction(this.getLayoutNode(node.getParentNodeId()), 8, "children") != null && this.checkRestriction(node.getParentNodeId(), 8, "children", "true")) {
            return false;
        }
        if (node.getNodeType() == 2) {
            ALFolder folder = (ALFolder)node;
            String nextId = folder.getFirstChildNodeId();
            while (nextId != null) {
                if (AggregatedLayoutManager.getRestriction(this.getLayoutNode(nextId), 8, "parent") != null && this.checkRestriction(nextId, 8, "parent", "true")) {
                    return false;
                }
                nextId = this.getLayoutNode(nextId).getNextNodeId();
            }
        }
        if (nodeDesc.getRestrictions() == null) {
            nodeDesc.setRestrictions(currentNodeDesc.getRestrictions());
        }
        Hashtable rhash = nodeDesc.getRestrictions();
        node.setNodeDescription(nodeDesc);
        if (rhash != null) {
            Enumeration enumeration = rhash.elements();
            while (enumeration.hasMoreElements()) {
                if (((IUserLayoutRestriction)enumeration.nextElement()).checkRestriction(node)) continue;
                node.setNodeDescription(currentNodeDesc);
                return false;
            }
        }
        Vector restrictions = this.getLayoutNode(node.getParentNodeId()).getRestrictionsByPath("children");
        for (int i = 0; i < restrictions.size(); ++i) {
            IUserLayoutRestriction restriction = (IUserLayoutRestriction)restrictions.get(i);
            if (restriction.checkRestriction(node)) continue;
            node.setNodeDescription(currentNodeDesc);
            return false;
        }
        if (node.getNodeType() == 2) {
            String nextId = ((ALFolder)node).getFirstChildNodeId();
            while (nextId != null) {
                ALNode child = this.getLayoutNode(nextId);
                restrictions = child.getRestrictionsByPath("parent");
                for (int i = 0; i < restrictions.size(); ++i) {
                    IUserLayoutRestriction restriction = (IUserLayoutRestriction)restrictions.get(i);
                    if (restriction.checkRestriction(node)) continue;
                    node.setNodeDescription(currentNodeDesc);
                    return false;
                }
                nextId = child.getNextNodeId();
            }
        }
        return true;
    }

    public void markAddTargets(IUserLayoutNodeDescription nodeDesc) throws PortalException {
        if (nodeDesc != null && !(nodeDesc instanceof IALNodeDescription)) {
            throw new PortalException("The given argument is not a node description!");
        }
        this.addTargetsNodeDesc = (IALNodeDescription)nodeDesc;
        this.updateCacheKey();
    }

    public void markMoveTargets(String nodeId) throws PortalException {
        if (nodeId != null && this.getLayoutNode(nodeId) == null) {
            throw new PortalException("The node with nodeID=" + nodeId + " does not exist in the layout!");
        }
        this.moveTargetsNodeId = nodeId;
        this.updateCacheKey();
    }

    public IALNodeDescription getNodeBeingAdded() throws PortalException {
        return this.addTargetsNodeDesc;
    }

    public IALNodeDescription getNodeBeingMoved() throws PortalException {
        if (this.moveTargetsNodeId != null) {
            ALNode node = this.getLayoutNode(this.moveTargetsNodeId);
            return node != null ? node.getNodeDescription() : null;
        }
        return null;
    }

    public void setRestrictionMask(int restrictionMask) {
        this.restrictionMask = restrictionMask;
    }

    public int getRestrictionMask() {
        return this.restrictionMask;
    }

    public boolean addLayoutEventListener(LayoutEventListener l) {
        return false;
    }

    public boolean removeLayoutEventListener(LayoutEventListener l) {
        return false;
    }

    public String getRootFolderId() {
        return this.layout.getRootId();
    }

    public String getSubscribeId(String fname) throws PortalException {
        return this.layout.getNodeId(fname);
    }
}

