/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.channels;

import java.io.InputStream;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.IPrivileged;
import org.jasig.portal.IUserLayoutStore;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalException;
import org.jasig.portal.PortalSessionManager;
import org.jasig.portal.UserLayoutStoreFactory;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;

public class CSkinSelector
extends BaseChannel
implements IPrivileged {
    private static final String SKINS_PATH = "media/org/jasig/portal/layout/AL_TabColumn/integratedModes";
    private static final String sslLocation = "/org/jasig/portal/channels/CSkinSelector/CSkinSelector.ssl";
    private PortalControlStructures controlStructures;
    private static IUserPreferencesManager upm;
    private static IUserLayoutStore store;

    public void setPortalControlStructures(PortalControlStructures pcs) throws PortalException {
        this.controlStructures = pcs;
        if (upm == null) {
            upm = this.controlStructures.getUserPreferencesManager();
        }
    }

    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        this.runtimeData = rd;
        String action = this.runtimeData.getParameter("action");
        if (action != null && this.runtimeData.getParameter("submitSave") != null) {
            String skinName = this.runtimeData.getParameter("skinName");
            UserPreferences userPrefs = upm.getUserPreferences();
            userPrefs.getThemeStylesheetUserPreferences().putParameterValue("skin", skinName);
            this.saveUserPreferences(userPrefs);
        }
    }

    private void saveUserPreferences(UserPreferences userPrefs) throws PortalException {
        try {
            store.putUserPreferences(this.staticData.getPerson(), userPrefs);
        }
        catch (Exception e) {
            throw new PortalException(e.getMessage(), e);
        }
    }

    public void renderXML(ContentHandler out) throws PortalException {
        InputStream xmlStream = PortalSessionManager.getResourceAsStream("media/org/jasig/portal/layout/AL_TabColumn/integratedModes/skinList.xml");
        UserPreferences userPrefs = upm.getUserPreferences();
        String currentSkin = userPrefs.getThemeStylesheetUserPreferences().getParameterValue("skin");
        XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
        xslt.setXML(xmlStream);
        xslt.setXSL(sslLocation, "skinSelector", this.runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.setStylesheetParameter("skinsPath", SKINS_PATH);
        xslt.setStylesheetParameter("baseActionURL", this.runtimeData.getBaseActionURL());
        if (currentSkin != null) {
            xslt.setStylesheetParameter("currentSkin", currentSkin);
        }
        xslt.transform();
    }

    static {
        store = UserLayoutStoreFactory.getUserLayoutStoreImpl();
    }
}

