/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.ISecurityContextFactory;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.services.LogService;

public class InitialSecurityContextFactory {
    static /* synthetic */ Class class$org$jasig$portal$security$InitialSecurityContextFactory;

    public static ISecurityContext getInitialContext(String ctx) throws PortalSecurityException {
        ISecurityContextFactory factory;
        if (ctx.indexOf(46) != -1) {
            PortalSecurityException ep = new PortalSecurityException("Initial Context can't be compound");
            LogService.log(LogService.ERROR, ep);
            throw ep;
        }
        InputStream secprops = (class$org$jasig$portal$security$InitialSecurityContextFactory == null ? (class$org$jasig$portal$security$InitialSecurityContextFactory = InitialSecurityContextFactory.class$("org.jasig.portal.security.InitialSecurityContextFactory")) : class$org$jasig$portal$security$InitialSecurityContextFactory).getResourceAsStream("/properties/security.properties");
        Properties pr = new Properties();
        try {
            pr.load(secprops);
            secprops.close();
        }
        catch (IOException e) {
            PortalSecurityException ep = new PortalSecurityException(e.getMessage());
            LogService.log(LogService.ERROR, ep);
            throw ep;
        }
        String factoryname = pr.getProperty(ctx);
        if (factoryname == null) {
            PortalSecurityException ep = new PortalSecurityException("No such security context " + ctx);
            LogService.log(LogService.ERROR, ep);
            throw ep;
        }
        try {
            factory = (ISecurityContextFactory)Class.forName(factoryname).newInstance();
        }
        catch (Exception e) {
            PortalSecurityException ep = new PortalSecurityException("Failed to instantiate " + factoryname);
            LogService.log(LogService.ERROR, ep);
            throw ep;
        }
        ISecurityContext ictx = factory.getSecurityContext();
        Enumeration<?> ctxnames = pr.propertyNames();
        while (ctxnames.hasMoreElements()) {
            String candidate = (String)ctxnames.nextElement();
            if (!candidate.startsWith(ctx + ".")) continue;
            String secname = candidate.substring(ctx.length() + 1);
            String sfactoryname = pr.getProperty(candidate);
            try {
                ISecurityContextFactory sfactory = (ISecurityContextFactory)Class.forName(sfactoryname).newInstance();
                ictx.addSubContext(secname, sfactory.getSecurityContext());
            }
            catch (Exception e) {
                PortalSecurityException ep = new PortalSecurityException("(Subcontext)Failed to instantiate " + sfactoryname);
                LogService.log(LogService.ERROR, ep);
                throw ep;
            }
        }
        return ictx;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

