/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security;

import org.jasig.portal.PortalException;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.UserIdentityStoreFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.InitialSecurityContextFactory;
import org.jasig.portal.security.provider.PersonImpl;

public class PersonFactory {
    public static final String GUEST_USERNAME = PropertiesManager.getProperty("org.jasig.portal.security.PersonFactory.guest_user_name");

    public static IPerson createPerson() {
        return new PersonImpl();
    }

    public static IPerson createSystemPerson() {
        IPerson person = PersonFactory.createPerson();
        person.setAttribute("username", "SYSTEM_USER");
        person.setID(0);
        return person;
    }

    public static IPerson createGuestPerson() throws PortalException {
        IPerson person = PersonFactory.createPerson();
        person.setAttribute("username", GUEST_USERNAME);
        person.setID(UserIdentityStoreFactory.getUserIdentityStoreImpl().getPortalUID(person));
        person.setSecurityContext(InitialSecurityContextFactory.getInitialContext("root"));
        return person;
    }
}

