/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import java.io.File;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.jasig.portal.utils.ResourceLoader;

public final class LogService {
    public static final Priority NONE = Priority.DEBUG;
    public static final Priority SEVERE = Priority.FATAL;
    public static final Priority ERROR = Priority.ERROR;
    public static final Priority WARN = Priority.WARN;
    public static final Priority INFO = Priority.INFO;
    public static final Priority DEBUG = Priority.DEBUG;
    private static final String fs = File.separator;
    private static final String sLogRelativePath = "logs" + fs + "portal.log";
    private static boolean bInitialized = false;
    private static Logger m_logger = null;
    private static final LogService m_instance = new LogService();
    static /* synthetic */ Class class$org$jasig$portal$services$LogService;

    protected LogService() {
        LogService.initialize();
    }

    public static final LogService instance() {
        return m_instance;
    }

    private static final void initialize() {
        if (bInitialized) {
            return;
        }
        try {
            String loggerPropsFileName = ResourceLoader.getResourceAsFileString(class$org$jasig$portal$services$LogService == null ? (class$org$jasig$portal$services$LogService = LogService.class$("org.jasig.portal.services.LogService")) : class$org$jasig$portal$services$LogService, "/properties/Logger.properties");
            PropertyConfigurator.configureAndWatch((String)loggerPropsFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            m_logger = Logger.getLogger((String)"org.jasig.portal");
            bInitialized = true;
        }
        catch (Exception e) {
            System.err.println("Problem writing to log.");
            e.printStackTrace();
        }
        catch (Error er) {
            System.err.println("Problem writing to log.");
            er.printStackTrace();
        }
    }

    public static final void log(Priority pLogLevel, String sMessage) {
        try {
            LogService.initialize();
            m_logger.log(pLogLevel, (Object)sMessage);
        }
        catch (Exception e) {
            System.err.println("Problem writing to log.");
            e.printStackTrace();
        }
        catch (Error er) {
            System.err.println("Problem writing to log.");
            er.printStackTrace();
        }
    }

    public static final void log(Priority pLogLevel, Throwable ex) {
        try {
            LogService.initialize();
            m_logger.log(pLogLevel, (Object)("EXCEPTION: " + ex), ex);
        }
        catch (Exception e) {
            System.err.println("Problem writing to log.");
            e.printStackTrace();
        }
        catch (Error er) {
            System.err.println("Problem writing to log.");
            er.printStackTrace();
        }
    }

    public static final void log(Priority pLogLevel, String sMessage, Throwable ex) {
        try {
            LogService.initialize();
            m_logger.log(pLogLevel, (Object)sMessage, ex);
        }
        catch (Exception e) {
            System.err.println("Problem writing to log.");
            e.printStackTrace();
        }
        catch (Error er) {
            System.err.println("Problem writing to log.");
            er.printStackTrace();
        }
    }

    public static final void log(String sMessage) {
        try {
            LogService.initialize();
            m_logger.log(INFO, (Object)sMessage);
        }
        catch (Exception e) {
            System.err.println("Problem writing to log.");
            e.printStackTrace();
        }
        catch (Error er) {
            System.err.println("Problem writing to log.");
            er.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

