/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.jasig.portal.utils.SubstitutionIntegerFilter;
import org.jasig.portal.utils.WriteableWriterWrapper;

public class SubstitutionWriter
extends Writer {
    SubstitutionIntegerFilter filter;

    public SubstitutionWriter(Writer out, char[] target, char[] substitute, int bufferSize) {
        this.filter = new SubstitutionIntegerFilter(new WriteableWriterWrapper(out), SubstitutionWriter.getIntArrayFromCharArray(target), SubstitutionWriter.getIntArrayFromCharArray(substitute), bufferSize);
    }

    public SubstitutionWriter(Writer out, char[] target, char[] substitute) {
        this.filter = new SubstitutionIntegerFilter(new WriteableWriterWrapper(out), SubstitutionWriter.getIntArrayFromCharArray(target), SubstitutionWriter.getIntArrayFromCharArray(substitute));
    }

    public void write(int i) throws IOException {
        this.filter.write(i);
    }

    public void flush() throws IOException {
        this.filter.flush();
    }

    public void close() throws IOException {
        this.filter.close();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (off + len > cbuf.length) {
            throw new IOException("Invalid offsent or length specified");
        }
        for (int i = 0; i < len; ++i) {
            this.filter.write(cbuf[i]);
        }
    }

    private static int[] getIntArrayFromCharArray(char[] c) {
        int[] ic = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            ic[i] = c[i];
        }
        return ic;
    }

    public static void main(String[] args) {
        String inputString = "Marry had a little lamb, little lamb, little lamb.";
        StringWriter sw = new StringWriter();
        SubstitutionWriter substw = new SubstitutionWriter(sw, new String("lamb").toCharArray(), new String("rump").toCharArray());
        try {
            substw.write(inputString);
            substw.flush();
            String resultString = sw.toString();
            if (resultString.equals("Marry had a little rump, little rump, little rump.")) {
                System.out.println("Test passed.");
            } else {
                System.out.println("Test failed!");
            }
        }
        catch (Exception e) {
            System.out.println("Test failed:");
            e.printStackTrace();
        }
    }
}

