/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.event;

import java.net.InetAddress;

public final class Notification {
    private String url;
    private long subscription;
    private InetAddress inetAddress;

    public Notification(String url, long subscription, InetAddress address) {
        this.url = url;
        this.subscription = subscription;
        this.inetAddress = address;
    }

    public String getURL() {
        return this.url;
    }

    public long getSubscriptionId() {
        return this.subscription;
    }

    public String getNotifiersAddress() {
        return this.inetAddress.getHostAddress();
    }

    public String getNotifiersName() {
        return this.inetAddress.getHostName();
    }

    public String getNotifiersCanonicalName() {
        return this.inetAddress.getCanonicalHostName();
    }

    public String toString() {
        return new StringBuffer(120).append("url=").append(this.url).append(", subscription=").append(this.subscription).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Notification) {
            Notification that = (Notification)obj;
            return this.subscription == that.subscription && this.url.equals(that.url);
        }
        return false;
    }

    public int hashCode() {
        return 51 * (int)this.subscription + this.url.hashCode();
    }
}

