/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.event;

import org.apache.webdav.lib.event.Listener;
import org.apache.webdav.lib.event.Notification;
import org.apache.webdav.lib.event.NotificationProcessor;
import org.apache.webdav.lib.event.PrintingNotificationProcessor;
import org.apache.webdav.lib.event.UDPListener;

public class NotificationListener
extends Thread {
    private Listener listener;
    private NotificationProcessor processor;

    private NotificationListener(Listener listener, NotificationProcessor processor) {
        this.listener = listener;
        this.processor = processor;
        this.setName("Notification processing thread for " + listener);
    }

    public static NotificationListener createUDPListener(int port, NotificationProcessor processor) {
        return new NotificationListener(new UDPListener(port), processor);
    }

    public static NotificationListener createTCPListener(int port, NotificationProcessor processor) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.listener.start();
        while (true) {
            Notification notification;
            Listener listener = this.listener;
            synchronized (listener) {
                while (this.listener.getNotificationCount() < 1) {
                    try {
                        this.listener.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        this.listener.interrupt();
                        return;
                    }
                    if (!this.isInterrupted()) continue;
                    this.listener.interrupt();
                    return;
                }
                notification = this.listener.popNextNotification();
            }
            this.processor.processNotification(notification);
        }
    }

    public static void main(String[] args) {
        NotificationListener listener = NotificationListener.createUDPListener(80, new PrintingNotificationProcessor());
        listener.start();
        try {
            listener.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

