/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.event;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.webdav.lib.event.Listener;
import org.apache.webdav.lib.event.Notification;

class UDPListener
extends Listener {
    private int port = 80;
    private DatagramSocket socket;
    private byte[] buffer = new byte[1024];
    private LinkedList notifications = new LinkedList();
    private Exception exception = null;

    public UDPListener() {
        this(80);
    }

    public UDPListener(int port) {
        this.port = port;
        this.setName(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            this.socket = new DatagramSocket(this.port);
            this.socket.setSoTimeout(10000);
            DatagramPacket packet = new DatagramPacket(this.buffer, this.buffer.length);
            while (true) {
                try {
                    List l;
                    do {
                        this.socket.receive(packet);
                    } while ((l = this.parseRequest(packet)).size() <= 0);
                    UDPListener uDPListener = this;
                    synchronized (uDPListener) {
                        this.notifications.addAll(l);
                        this.notify();
                        continue;
                    }
                }
                catch (SocketTimeoutException e) {
                    if (this.isInterrupted()) return;
                    continue;
                }
                break;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.exception = e;
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.exception = e;
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public int getNotificationCount() {
        return this.notifications.size();
    }

    public Notification popNextNotification() {
        return (Notification)this.notifications.removeFirst();
    }

    public String toString() {
        return "UDP Notification Listener on port " + this.port;
    }

    private List parseRequest(DatagramPacket packet) {
        LinkedList<Notification> result = new LinkedList<Notification>();
        byte[] data = packet.getData();
        int pos = packet.getOffset();
        int lastPos = packet.getOffset() + packet.getLength();
        if (data[pos] == 78 && data[pos + 1] == 79 && data[pos + 2] == 84 && data[pos + 3] == 73 && data[pos + 4] == 70 && data[pos + 5] == 89 && data[pos + 6] == 32) {
            String url;
            int secondSpacePos = this.indexOf((byte)32, data, pos + 7, lastPos);
            if (secondSpacePos == -1) {
                return Collections.EMPTY_LIST;
            }
            try {
                url = URLDecoder.decode(new String(data, 7, secondSpacePos - 7), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                url = new String(data, 7, secondSpacePos);
            }
            pos = 1 + this.indexOfEOL(data, secondSpacePos + 1, lastPos);
            while (pos < lastPos) {
                String line;
                int lineEnd = this.indexOfEOL(data, pos, lastPos);
                if (lineEnd == -1) {
                    line = new String(data, pos, lastPos - pos);
                    lineEnd = lastPos;
                } else {
                    line = new String(data, pos, lineEnd - pos);
                }
                String headerName = line.substring(0, line.indexOf(58)).trim();
                if ("Subscription-ID".equalsIgnoreCase(headerName)) {
                    StringTokenizer tokenizer = new StringTokenizer(line.substring(line.indexOf(58) + 1), ", ");
                    while (tokenizer.hasMoreTokens()) {
                        long id = Long.parseLong(tokenizer.nextToken());
                        Notification n = new Notification(url, id, packet.getAddress());
                        result.add(n);
                    }
                }
                pos = lineEnd + 1;
            }
        }
        return result;
    }

    private int indexOf(byte b, byte[] data, int offset, int end) {
        for (int i = offset; i < end; ++i) {
            if (data[i] != b) continue;
            return i;
        }
        return -1;
    }

    private int indexOfEOL(byte[] data, int offset, int end) {
        for (int i = offset; i < end; ++i) {
            switch (data[i]) {
                case 13: {
                    if (i + 1 < end && data[i + 1] == 10) {
                        return i + 1;
                    }
                }
                case 10: {
                    return i;
                }
            }
        }
        return -1;
    }
}

