/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.properties;

import org.apache.util.DOMUtils;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.ResponseEntity;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResourceTypeProperty
extends BaseProperty {
    private boolean initialized = false;
    private boolean isCollection;
    public static final String TAG_NAME = "resourcetype";
    public static final String TAG_COLLECTION = "collection";

    public ResourceTypeProperty(ResponseEntity response, Element element) {
        super(response, element);
    }

    public boolean isCollection() {
        this.init();
        return this.isCollection;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        NodeList tmp = this.element.getChildNodes();
        for (int i = 0; tmp != null && i < tmp.getLength(); ++i) {
            try {
                Element child = (Element)tmp.item(i);
                if (!TAG_COLLECTION.equals(DOMUtils.getElementLocalName(child)) || !"DAV:".equals(DOMUtils.getElementNamespaceURI(child))) continue;
                this.isCollection = true;
                this.initialized = true;
                return;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.isCollection = false;
        this.initialized = true;
    }

    public String getPropertyAsString() {
        this.init();
        return this.isCollection ? "COLLECTION" : "";
    }
}

