/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.signature;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.encryption.DecryptDocument;
import org.pdfbox.pdfparser.PDFParser;

public class ShowSignature {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            ShowSignature.usage();
        } else {
            String password = args[0];
            String infile = args[1];
            FileInputStream is = null;
            COSDocument document = null;
            try {
                is = new FileInputStream(infile);
                PDFParser parser = new PDFParser(is);
                parser.parse();
                document = parser.getDocument();
                if (document.isEncrypted()) {
                    DecryptDocument decryptor = new DecryptDocument(document);
                    decryptor.decryptDocument(password);
                } else {
                    System.err.println("Warning: Document is not encrypted.");
                }
                COSDictionary trailer = document.getTrailer();
                COSDictionary root = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
                COSDictionary acroForm = (COSDictionary)root.getDictionaryObject(COSName.getPDFName("AcroForm"));
                COSArray fields = (COSArray)acroForm.getDictionaryObject(COSName.getPDFName("Fields"));
                int i = 0;
                while (i < fields.size()) {
                    COSDictionary field = (COSDictionary)fields.getObject(i);
                    COSName type = (COSName)field.getDictionaryObject(COSName.getPDFName("FT"));
                    if (type != null && type.getName().equals("Sig")) {
                        COSDictionary cert = (COSDictionary)field.getDictionaryObject(COSName.getPDFName("V"));
                        System.out.println("Certificate found");
                        System.out.println("Name=" + cert.getDictionaryObject(COSName.getPDFName("Name")));
                        System.out.println("Modified=" + cert.getDictionaryObject(COSName.getPDFName("M")));
                        COSName subFilter = (COSName)cert.getDictionaryObject(COSName.getPDFName("SubFilter"));
                        if (subFilter != null) {
                            if (subFilter.getName().equals("adbe.x509.rsa_sha1")) {
                                COSString certString = (COSString)cert.getDictionaryObject(COSName.getPDFName("Cert"));
                                byte[] certData = certString.getBytes();
                                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                                Collection<? extends Certificate> certs = factory.generateCertificates(new ByteArrayInputStream(certData));
                                System.out.println("certs=" + certs);
                            }
                        } else {
                            throw new IOException("Missing subfilter for cert dictionary");
                        }
                    }
                    ++i;
                }
                Object var20_19 = null;
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                ((InputStream)is).close();
                document.close();
                throw throwable;
            }
            ((InputStream)is).close();
            document.close();
            {
            }
        }
    }

    private static void usage() {
        System.err.println("usage: java org.pdfbox.examples.signature.ShowSignature <password> <inputfile>");
    }
}

