/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileInputStream
extends InputStream {
    private RandomAccessFile file;
    private long currentPosition;
    private long endPosition;

    public RandomAccessFileInputStream(RandomAccessFile file, long startPosition, long length) {
        this.file = file;
        this.currentPosition = startPosition;
        this.endPosition = this.currentPosition + length;
    }

    public int available() {
        return (int)(this.endPosition - this.currentPosition);
    }

    public void close() {
    }

    public int read() throws IOException {
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            int retval = -1;
            if (this.currentPosition < this.endPosition) {
                this.file.seek(this.currentPosition);
                ++this.currentPosition;
                retval = this.file.read();
            }
            int n = retval;
            return n;
        }
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (length > this.available()) {
            length = this.available();
        }
        int amountRead = -1;
        if (this.available() > 0) {
            RandomAccessFile randomAccessFile = this.file;
            synchronized (randomAccessFile) {
                this.file.seek(this.currentPosition);
                amountRead = this.file.read(b, offset, length);
            }
        }
        if (amountRead > 0) {
            this.currentPosition += (long)amountRead;
        }
        return amountRead;
    }

    public long skip(long amountToSkip) {
        long amountSkipped = Math.min(amountToSkip, (long)this.available());
        this.currentPosition += amountSkipped;
        return amountSkipped;
    }
}

