/**
 * @author Thomas Bellembois
 * @version
 * 
 * Creation date : 20 juil. 2005
 * Last modification :
 */
package org.esupportail.injac.webdavServer.esupWDServerManager.controller;

import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;

import javax.xml.rpc.ServiceException;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.injac.webdavServer.esupWDServerManager.ICommand;
import org.esupportail.injac.webdavServer.esupWDServerManager.IFactory;
import org.esupportail.injac.webdavServer.esupWDServerManager.IPACProduct;
import org.esupportail.injac.webdavServer.esupWDServerManager.core.exceptions.ConfigException;
import org.esupportail.injac.webdavServer.esupWDServerManager.core.exceptions.WrongPathException;
//import org.esupportail.injac.webdavServer.esupWDServerManager.core.homedirManager.HomedirManager;
//import org.esupportail.injac.webdavServer.esupWDServerManager.core.injacSpacesManager.InjacSpacesManager;
import org.esupportail.injac.webdavServer.esupWDServerManager.core.quotaManager.QuotaManager;
import org.esupportail.injac.webdavServer.esupWDServerManager.core.spaceManager.SpaceManager;
import org.esupportail.injac.webdavServer.esupWDServerManager.core.webDAVManager.WebDAVManager;
import org.esupportail.injac.webdavServer.esupWDServerManager.userInterface.PWDServerManager;
//import org.esupportail.portal.utils.webdav.acl.exception.ReadAclException;
//import org.esupportail.portal.utils.webdav.acl.exception.WriteAclException;

import com.novell.ldap.LDAPException;

public class CWDServerManager implements IPACProduct { //extends QuotaManager, WebDAVClient
	
	QuotaManager quotaManager;
	WebDAVManager webdavManager;
//	HomedirManager homedirManager;
//	InjacSpacesManager injacSpacesManager;
	SpaceManager spaceManager;
	
	protected PWDServerManager pQuotaManager; // link with the presentation class
	
	private Log log;
	
	public CWDServerManager(IFactory factory) throws MalformedURLException,
			RemoteException, ServiceException, ConfigurationException {
		
		quotaManager = new QuotaManager();
		webdavManager = new WebDAVManager();
//		homedirManager = new HomedirManager();
//		injacSpacesManager = new InjacSpacesManager();
		spaceManager = new SpaceManager();
		
		log = LogFactory.getLog("org.esupportail.portal.utils.injac.esupWDServerManager.CQuotaManager");
		
		pQuotaManager = (PWDServerManager) factory.newPQuotaManager();
		
		pQuotaManager.setGetQuotaAvailableBytesAction(new GetQuotaAvailableBytesAction());
		pQuotaManager.setSetQuotaAction(new SetQuotaAction());
		pQuotaManager.setSetVirtualRootAction(new SetVirtualRootAction());
		pQuotaManager.setCalculateQuotaUsedBytesAction(new CalculateQuotaUsedBytesAction());
		pQuotaManager.setGetChildrenAction(new GetChildrenAction());
		pQuotaManager.setGetQuotaAvailableBytesAction(new GetQuotaAvailableBytesAction());
		pQuotaManager.setGetQuotaUsedBytesAction(new GetQuotaUsedBytesAction());
		pQuotaManager.setGetTreeQuotaInformationAction(new GetTreeQuotaInformationAction());
		pQuotaManager.setGetVirtualRootAction(new GetVirtualRootAction());
		pQuotaManager.setPatchQuotaAvailableBytesAction(new PatchQuotaAvailableBytesAction());
		pQuotaManager.setPatchQuotaUsedBytesAction(new PatchQuotaUsedBytesAction());
		pQuotaManager.setRemoveQuotaAction(new RemoveQuotaAction());
		pQuotaManager.setSetQuotaAction(new SetQuotaAction());
		pQuotaManager.setSetVirtualRootAction(new SetVirtualRootAction());
		pQuotaManager.setConnectAction(new ConnectAction());
//		pQuotaManager.setCreateHomedir(new CreateHomedirAction());
//		pQuotaManager.setGetNumberLDAPEntries(new GetNumberLDAPEntriesAction());
		pQuotaManager.setCdAction(new CdAction());
		pQuotaManager.setExistAction(new ExistAction());
		pQuotaManager.setMkdirAction(new MkdirAction());
		pQuotaManager.setRmAction(new RmAction());
//		pQuotaManager.setCreateInjacSpaceAction(new CreateInjacSpaceAction());
		pQuotaManager.setCreateSpaceAction(new CreateSpaceAction());
		
		pQuotaManager.startInterface();
	}// CQuotaManager

	
	/*
	 * ---- Actions called by the pQuotaManager presentation class ----
	 */
	/**
	 * Action ConnectAction
	 */
	public class ConnectAction implements ICommand {
		
		public void execute() {
			connectQuotaManager(pQuotaManager.getWebServiceURL(), pQuotaManager.getConnectUserName(), pQuotaManager.getConnectPassword());
			connectWebDAVManager(pQuotaManager.getWebdavServerURL(), pQuotaManager.getConnectUserName(), pQuotaManager.getConnectPassword());
//			connectHomedirManager(pQuotaManager.getWebdavServerURL(),
//					pQuotaManager.getConnectUserName(),
//					pQuotaManager.getConnectPassword(),
//					pQuotaManager.getLdapUrl(),
//					pQuotaManager.getLdapPort(),
//					pQuotaManager.getLdapBaseDn(),
//					pQuotaManager.getLdapPrincipal(),
//					pQuotaManager.getLdapCredential(),
//					pQuotaManager.getLdapUserUidAttribut(),
//					pQuotaManager.getLdapMaxResults(),
//					pQuotaManager.get_ldapScope(),
//					pQuotaManager.getDirectoriesStructureHashType(),
//					pQuotaManager.getHomedirRoot(),
//					pQuotaManager.getUsersPath(),
//					pQuotaManager.getRolesPath(),
//					pQuotaManager.getLocalRolesPath(),
//					pQuotaManager.getUportalRolesPath()
//					);
//			connectInjacSpacesManager(pQuotaManager.getWebdavServerURL(), 
//					pQuotaManager.getConnectUserName(),
//					pQuotaManager.getConnectPassword(),
//					pQuotaManager.getUsersPath(),
//					pQuotaManager.getRolesPath(),
//					pQuotaManager.getLocalRolesPath(),
//					pQuotaManager.getUportalRolesPath());
			connectSpaceManager(pQuotaManager.getWebdavServerURL(), 
					pQuotaManager.getConnectUserName(),
					pQuotaManager.getConnectPassword(),
					pQuotaManager.getLdapUrl(),
					pQuotaManager.getLdapPort(),
					pQuotaManager.get_ldapScope(),
					pQuotaManager.getLdapBaseDn(),
					pQuotaManager.getLdapPrincipal(),
					pQuotaManager.getLdapCredential(),
					pQuotaManager.getLdapMaxResults(),
					pQuotaManager.getWebServiceURL()
			);

		}// execute

		
	}// ConnectAction
	
	/**
	 * Action GetQuotaAvailableBytesAction
	 */
	public class GetQuotaAvailableBytesAction implements ICommand {
		
		public void execute() {
			getQuotaAvailableBytes(pQuotaManager.getCurrentPath());
		}// execute
		
	}// GetQuotaAvailableBytesAction
	
	/**
	 * Action GetQuotaUsedBytesAction
	 */
	public class GetQuotaUsedBytesAction implements ICommand {
		
		public void execute() {
			getQuotaUsedBytes(pQuotaManager.getCurrentPath());
		}// execute
		
	}// GetQuotaUsedBytesAction
	
	/**
	 * Action CalculateQuotaUsedBytesAction
	 */
	public class CalculateQuotaUsedBytesAction implements ICommand {
		
		public void execute() {
			calculateQuotaUsedBytes(pQuotaManager.getCurrentPath());
		}// execute
		
	}// CalculateQuotaUsedBytesAction
	
	/**
	 * Action GetChildrenAction
	 */
	public class GetChildrenAction implements ICommand {
		
		public void execute() {
			_getChildren(pQuotaManager.getCurrentPath(), pQuotaManager.getChildrenProcessFiles(), pQuotaManager.getChildrenDepth());
		}// execute
		
	}// GetChildrenAction
	
	/**
	 * Action GetTreeQuotaInformationAction
	 */
	public class GetTreeQuotaInformationAction implements ICommand {
		
		public void execute() {
			getTreeQuotaInformation(pQuotaManager.getCurrentPath(), pQuotaManager.getTreeQuotaInformationProcessFiles(), pQuotaManager.getChildrenDepth());
		}// execute
		
	}// GetTreeQuotaInformationAction
	
	/**
	 * Action GetVirtualRootAction
	 */
	public class GetVirtualRootAction implements ICommand {
		
		public void execute() {
			getVirtualRoot(pQuotaManager.getCurrentPath());
		}// execute
		
	}// GetVirtualRootAction
	
	/**
	 * Action PatchQuotaAvailableBytesAction
	 */
	public class PatchQuotaAvailableBytesAction implements ICommand {
		
		public void execute() {
			patchQuotaAvailableBytes(pQuotaManager.getCurrentPath(), pQuotaManager.getNewQuotaAvailableBytes());
		}// execute
		
	}// PatchQuotaAvailableBytesAction
	
	/**
	 * Action PatchQuotaUsedBytesAction
	 */
	public class PatchQuotaUsedBytesAction implements ICommand {
		
		public void execute() {
			patchQuotaUsedBytes(pQuotaManager.getCurrentPath(), pQuotaManager.getNewQuotaUsedBytes(), pQuotaManager.getPatchQuotaUsedBytesOverwrite());
		}// execute
		
	}// PatchQuotaUsedBytesAction
	
	/**
	 * Action SetVirtualRootAction
	 */
	public class SetVirtualRootAction implements ICommand {
		
		public void execute() {
			setVirtualRoot(pQuotaManager.getCurrentPath(), pQuotaManager.getNewVirtualRoot());
		}// execute
		
	}// SetVirtualRootAction
	
	/**
	 * Action RemoveQuotaAction
	 */
	public class RemoveQuotaAction implements ICommand {
		
		public void execute() {
			removeQuota(pQuotaManager.getCurrentPath(), pQuotaManager.getRemoveQuotaProcessChildren());
		}// execute
		
	}// RemoveQuotaAction
	
	/**
	 * Action SetQuotaAction
	 */
	public class SetQuotaAction implements ICommand {
		
		public void execute() {
			setQuota(pQuotaManager.getCurrentPath(), pQuotaManager.getNewQuotaAvailableBytes(), pQuotaManager.getChildrenDepth(), pQuotaManager.getSetQuotaCalculateQuotaUsedBytes());
		}// execute
		
	}// SetQuotaAction
	
	/**
	 * Action CdAction
	 */
	public class CdAction implements ICommand {
		
		public void execute() {
			cd(pQuotaManager.getNewPath());
		}// execute
		
	}// ConnectAction
	
	public class ExistAction implements ICommand {
		
		public void execute() {
			exist(pQuotaManager.getCurrentPath());
		}// execute
		
	}// ExistAction
	
//	/**
//	 * Action CreateHomedirAction
//	 */
//	public class CreateHomedirAction implements ICommand {
//		public void execute() {
//			createHomedirs(pQuotaManager.getHomedirRoot(), pQuotaManager.getHomedirLdapFilter());
//		}// execute
//	}
	
//	/**
//	 * Action GetNumberLDAPEntriesAction
//	 */
//	public class GetNumberLDAPEntriesAction implements ICommand {
//		public void execute() {
//			getNumberLDAPEntries(pQuotaManager.getHomedirLdapFilter());
//		}// execute
//	}
	
	/**
	 * Action MkdirAction
	 */
	public class MkdirAction implements ICommand {
		public void execute() {
			mkdir(pQuotaManager.getNewPath());
		}// execute
	}
	
	/**
	 * Action RmAction
	 */
	public class RmAction implements ICommand {
		public void execute() {
			rm(pQuotaManager.getNewPath());
		}// execute
	}
	
//	/**
//	 * Action CreateInjacSpaceAction
//	 */
//	public class CreateInjacSpaceAction implements ICommand {
//		public void execute() {
//			createInjacSpace(pQuotaManager.getNewPath(), pQuotaManager.getInjacSpaceName(), pQuotaManager.getInjacAdmin(), pQuotaManager.getInjacChannelAccount());
//		}// execute
//	}
	
	/**
	 * Action CreateSpaceAction
	 */
	public class CreateSpaceAction implements ICommand {
		public void execute() {
			createSpace(pQuotaManager.getCurrentPath(), pQuotaManager.getSpaceName(), pQuotaManager.getSpaceLDAPFilter(), pQuotaManager.getSpaceLDAPAttribute(),  pQuotaManager.getSpaceRegexp(), pQuotaManager.getSpaceRegexpSeparator(), pQuotaManager.getSpacePatternFilePath(), pQuotaManager.getForceSetProperties());
		}// execute
	}
	
	/*
	 * ---- Methods called by the Action ----
	 */
	public boolean connectQuotaManager(String webServiceURL, String userName, String password) {
		boolean success = false;
		try {
			
			success = quotaManager.connect(webServiceURL, userName, password);
			if (success) updateDisplayActionResult("Quota manager connected to "+webServiceURL);
			else  updateDisplayActionResult("Quota manager connection to "+webServiceURL+" failed !");
			
		} catch (MalformedURLException e) {
			updateDisplayActionResult("MalformedURLException handled ! "+e.toString()+"\nQuota manager connection to "+webServiceURL+" failed !");
		} catch (RemoteException e) {
			updateDisplayActionResult("RemoteException handled ! "+e.toString()+"\nQuota manager connection to "+webServiceURL+" failed !");
		} catch (ServiceException e) {
			updateDisplayActionResult("ServiceException handled ! "+e.toString()+"\nQuota manager connection to "+webServiceURL+" failed !");
		}
		
		return success;
	}// connect
	
	
	public boolean connectWebDAVManager(String webdavServerURL, String userName, String password) {
		boolean success = false;
		try {
			
			success = webdavManager.connect(webdavServerURL, userName, password);
			if (success) updateDisplayActionResult("WebDAV manager connected to "+webdavServerURL);
			else  updateDisplayActionResult("WebDAV manager connection to "+webdavServerURL+" failed !");
			
		} catch (MalformedURLException e) {
			updateDisplayActionResult("MalformedURLException handled ! "+e.toString()+"\nWebDAV manager connection to "+webdavServerURL+" failed !");
		} catch (RemoteException e) {
			updateDisplayActionResult("RemoteException handled ! "+e.toString()+"\nWebDAV manager connection to "+webdavServerURL+" failed !");
		} catch (HttpException e) {
			updateDisplayActionResult("HttpException handled ! "+e.toString()+"\nWebDAV manager connection to "+webdavServerURL+" failed !");
		} catch (IOException e) {
			updateDisplayActionResult("IOException handled ! "+e.toString()+"\nWebDAV manager connection to "+webdavServerURL+" failed !");
		}

		return success;
	}// connect
	
	
//	public boolean connectInjacSpacesManager(String webdavServerURL, String connectUserName, String connectPassword, String usersPath, String rolesPath, String localRolesPath, String uportalRolesPath) {
//		boolean success = false;
//			
//			try {
//				success = injacSpacesManager.connect(webdavServerURL, connectUserName, connectPassword, usersPath, rolesPath, localRolesPath, uportalRolesPath);
//			} catch (HttpException e) {
//				updateDisplayActionResult("HttpException handled ! "+e.toString()+"\nInjac spaces manager connection to "+webdavServerURL+" failed !");
//			} catch (IOException e) {
//				updateDisplayActionResult("IOException handled ! "+e.toString()+"\nInjac spaces manager connection to "+webdavServerURL+" failed !");
//			}
//			if (success) updateDisplayActionResult("Injac spaces manager connected to "+webdavServerURL);
//			else  updateDisplayActionResult("Injac spaces manager connection to "+webdavServerURL+" failed !");
//		
//		return success;
//	}
	
	public boolean connectSpaceManager(String webdavServerUrl, String userName, String password,
			String ldapURL, String ldapPort, String ldapScope, String ldapBaseDN,
			String ldapPrincipal, String ldapCredential, String ldapMaxResults, String webServiceURL) {
		boolean success = false;
			
				try {
					success = spaceManager.connect(webdavServerUrl, userName, password, ldapURL, ldapPort, ldapScope, ldapBaseDN, ldapPrincipal, ldapCredential, ldapMaxResults, webServiceURL);
				} catch (HttpException e) {
					updateDisplayActionResult("HttpException handled ! "+e.toString()+"\nSpace manager connection to "+webdavServerUrl+" failed !");
				} catch (IOException e) {
					updateDisplayActionResult("IOException handled ! "+e.toString()+"\nSpace manager connection to "+webdavServerUrl+" failed !");
				} catch (ServiceException e) {
					updateDisplayActionResult("ServiceException handled ! "+e.toString()+"\nSpace manager connection to "+webdavServerUrl+" failed !");
				}
			
			if (success) updateDisplayActionResult("Space manager connected to "+webdavServerUrl);
			else  updateDisplayActionResult("Space manager connection to "+webdavServerUrl+" failed !");
		
		return success;
	}
	
//	public boolean connectHomedirManager(String webdavServerURL, String userName, String password,
//			String ldapUrl, 
//			String ldapPort, 
//			String ldapBaseDn, 
//			String ldapPrincipal, 
//			String ldapCredential, 
//			String ldapUserUidAttribut, 
//			String ldapMaxResults, 
//			String _ldapScope,
//			String directoriesStructureHashType,
//			String homedirRoot,
//			String usersPath,
//			String rolesPath,
//			String localRolesPath,
//			String uportalRolesPath		
//	) {
//		boolean success = false;
//		try {
//			success = homedirManager.connect(webdavServerURL, 
//					userName, 
//					password, 
//					ldapUrl, 
//					ldapPort, 
//					ldapBaseDn, 
//					ldapPrincipal, 
//					ldapCredential, 
//					ldapUserUidAttribut, 
//					ldapMaxResults, 
//					_ldapScope,
//					directoriesStructureHashType,
//					homedirRoot,
//					usersPath,
//					rolesPath,
//					localRolesPath,
//					uportalRolesPath);
//		} catch (HttpException e) {
//			updateDisplayActionResult("HttpException handled ! "+e.toString()+"\nHomedir manager connection to "+webdavServerURL+" failed !");
//		} catch (ConfigException e) {
//			updateDisplayActionResult("ConfigException handled ! "+e.toString()+"\nHomedir manager connection to "+webdavServerURL+" failed !");
//		} catch (IOException e) {
//			updateDisplayActionResult("IOException handled ! "+e.toString()+"\nHomedir manager connection to "+webdavServerURL+" failed !");
//		}
//		if (success) updateDisplayActionResult("Homedir manager connected to "+webdavServerURL);
//		else  updateDisplayActionResult("Homedir manager connection to "+webdavServerURL+" failed !");
//
//		return success;
//	}// connect
	
	
	/**
	 * Get the resource quota-available-bytes metadata
	 * Call the parent getQuotaAvailableBytes method
	 * Display the result in the presentation class
	 * @param path resource path
	 */
	public int getQuotaAvailableBytes(String path) {
		int quotaAB = 0;
		try {
			quotaAB = quotaManager.getQuotaAvailableBytes(path);
			updateDisplayQAB(quotaAB);
		} catch (RemoteException e) {
			updateDisplayActionResult("RemoteException handled ! "+e.toString());
		} finally {
		}
		return quotaAB;
	}// getQuotaAvailableBytes
	
	/**
	 * Get the resource quota-available-bytes metadata
	 * Call the parent getQuotaAvailableBytes method
	 * Display the result in the presentation class
	 * @param path resource path
	 */
	public int getQuotaUsedBytes(String path) {
		int quotaUB = 0;
		try {
			quotaUB = quotaManager.getQuotaUsedBytes(path);
			updateDisplayQUB(quotaUB);
		} catch (RemoteException e) {
			updateDisplayActionResult("RemoteException handled ! "+e.toString());
		} finally {
		}
		return quotaUB;
	}// getQuotaAvailableBytes
	
	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.injac.esupWDServerManager.QuotaManager#calculateQuotaUsedBytes(java.lang.String)
	 */
	public int calculateQuotaUsedBytes(String path) {
		int quotaUB = 0;
		try {
			quotaUB = quotaManager.calculateQuotaUsedBytes(path);
			updateDisplayQUB(quotaUB);
		} catch (RemoteException e) {
			updateDisplayActionResult("RemoteException handled ! "+e.toString());
		} finally {
		}
		return quotaUB;
	}
	
	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.injac.esupWDServerManager.QuotaManager#getChildren(java.lang.String, boolean, int)
	 */
	public String getChildren(String path, boolean processFiles, int depth) {
				
		log.info("getChildren:path="+path+" processFiles="+processFiles+" depth="+depth);
		
		String children = "";
		try {
			children = quotaManager.getChildren(path, processFiles, depth);
			//updateDisplayChildren(children);
		} catch (RemoteException e) {
			updateDisplayActionResult("RemoteException handled ! "+e.toString());
		} finally {
		}
		
		log.info("getChildren:children="+children);
		
		return children;
	}
	
	private void _getChildren(String path, boolean processFiles, int depth) {
		updateDisplayChildren(getChildren(path, processFiles, depth));
	}
	
	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.injac.esupWDServerManager.QuotaManager#getTreeQuotaInformation(java.lang.String, boolean)
	 */
	public String getTreeQuotaInformation(String path, boolean processFiles, int maxDepth) {
		String treeQuotaInformation = "";
		try {
			treeQuotaInformation = quotaManager.getTreeQuotaInformation(path, processFiles, maxDepth);
			updateDisplayActionResult(treeQuotaInformation);
		} catch (RemoteException e) {
			updateDisplayActionResult("RemoteException handled ! "+e.toString());
		} finally {
		}
		return treeQuotaInformation;
	}
	
	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.injac.esupWDServerManager.QuotaManager#getVirtualRoot(java.lang.String)
	 */
	public boolean getVirtualRoot(String path) {
		boolean virtualRoot = false;
		try {
			virtualRoot = quotaManager.getVirtualRoot(path);
			updateDisplayVR(virtualRoot);
		} catch (RemoteException e) {
			updateDisplayActionResult("RemoteException handled ! "+e.toString());
		} finally {
		}
		return virtualRoot;
	}
	
	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.injac.esupWDServerManager.QuotaManager#patchQuotaAvailableBytes(java.lang.String, int)
	 */
	public boolean patchQuotaAvailableBytes(String path, int value) {
		boolean success = false;
		try {
			success = quotaManager.patchQuotaAvailableBytes(path, value);
			if (success) updateDisplayActionResult("Metadata patched succesfully for "+path);
			else updateDisplayActionResult("Metadata patch failed for "+path+" !");
		} catch (RemoteException e) {
			updateDisplayActionResult("RemoteException handled ! "+e.toString());
		} finally {
		}
		return success;
	}
	
	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.injac.esupWDServerManager.QuotaManager#patchQuotaUsedBytes(java.lang.String, int, boolean)
	 */
	public boolean patchQuotaUsedBytes(String path, int value, boolean overwrite) {
		boolean success = false;
		try {
			success = quotaManager.patchQuotaUsedBytes(path, value, overwrite);
			if (success) updateDisplayActionResult("Metadata patched succesfully for "+path);
			else updateDisplayActionResult("Metadata patch failed for "+path+" !");
		} catch (RemoteException e) {
			updateDisplayActionResult("RemoteException handled ! "+e.toString());
		} finally {
		}
		return success;
	}
	
	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.injac.esupWDServerManager.QuotaManager#setVirtualRoot(java.lang.String, boolean)
	 */
	public boolean setVirtualRoot(String path, boolean value) {
		boolean success = false;
		try {
			success = quotaManager.setVirtualRoot(path, value);
			if (success) updateDisplayActionResult("Metadata patched succesfully for "+path);
			else updateDisplayActionResult("Metadata patch failed for "+path+" !");
		} catch (RemoteException e) {
			updateDisplayActionResult("RemoteException handled ! "+e.toString());
		} finally {
		}
		return success;
	}
	
	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.injac.esupWDServerManager.QuotaManager#removeQuota(java.lang.String, boolean)
	 */
	public boolean removeQuota(String path, boolean processChildren) {
		boolean success = false;
		try {
			success = quotaManager.removeQuota(path, processChildren);
			if (success) updateDisplayActionResult("Quota removed successfully for "+path);
			else updateDisplayActionResult("Quota not removed for "+path+" !");
		} catch (RemoteException e) {
			updateDisplayActionResult("RemoteException handled ! "+e.toString());
		} finally {
		}
		return success;
	}
	
	/* (non-Javadoc)
	 * @see org.esupportail.portal.utils.injac.esupWDServerManager.QuotaManager#setQuota(java.lang.String, int, boolean)
	 */
	public boolean setQuota(String path, int availableBytes, int depth, boolean calculateQuotaUsedBytes) {
		boolean success = false;
		try {
			success = quotaManager.setQuota(path, availableBytes, depth, calculateQuotaUsedBytes);
			if (success) updateDisplayActionResult("Quota set successfully for "+path);
			else updateDisplayActionResult("Quota not set for "+path+" !");
		} catch (RemoteException e) {
			updateDisplayActionResult("RemoteException handled ! "+e.toString());
		} finally {
		}
		return success;
	}
	
	public boolean cd(String path) {
		boolean success = false;
		try {
			success = webdavManager.cd(path);
			if (success) updateDisplayCd(path);
			else updateDisplayActionResult("Wrong path : "+path+" !");
		} catch (HttpException e) {
			updateDisplayActionResult("HttpException handled ! "+e.toString());
		} catch (IOException e) {
			updateDisplayActionResult("IOException handled ! "+e.toString());
		} finally {
		}
		
		return success;
	}
	
	public boolean exist(String path) {
		boolean success = false;
		try {
			success = webdavManager.cd(path);
			if (success) updateDisplayExist(true);
			else updateDisplayExist(false);
		} catch (HttpException e) {
			updateDisplayActionResult("HttpException handled ! "+e.toString());
			updateDisplayExist(false);
		} catch (IOException e) {
			updateDisplayActionResult("IOException handled ! "+e.toString());
			updateDisplayExist(false);
		} finally {
		}
		
		return success;
	}
	
//	public boolean createHomedirs(String homedirRoot, String ldapRequestFilter) {
//		boolean success = false;
//		
//			try {
//				success = homedirManager.createHomedirs(homedirRoot, ldapRequestFilter);
//			} catch (NumberFormatException e) {
//				updateDisplayActionResult("NumberFormatException handled ! "+e.toString());
//			} catch (LDAPException e) {
//				updateDisplayActionResult("LDAPException handled ! "+e.toString());
//			} catch (ConfigException e) {
//				updateDisplayActionResult("LDAPException handled ! "+e.toString());
//			} catch (IOException e) {
//				updateDisplayActionResult("IOException handled ! "+e.toString());
//			} catch (ReadAclException e) {
//				updateDisplayActionResult("ReadAclException handled ! "+e.toString());
//			} catch (WriteAclException e) {
//				updateDisplayActionResult("WriteAclException handled ! "+e.toString());
//			} catch (WrongPathException e) {
//				updateDisplayActionResult("WrongPathException handled ! "+e.toString());
//			} finally {
//			}
//		
//		if (success) updateDisplayActionResult("Homedir(s) created successfully");
//		else  updateDisplayActionResult("Homedir(s) creation failed !");
//		
//		return success;
//	}
	
//	public int getNumberLDAPEntries(String ldapRequestFilter) {
//		int numberLDAPEntries = 0;
//		
//		try {
//			numberLDAPEntries = homedirManager.getNumberLDAPEntries(ldapRequestFilter);
//		} catch (NumberFormatException e) {
//			updateDisplayActionResult("NumberFormatException handled ! "+e.toString());
//		} catch (LDAPException e) {
//			updateDisplayActionResult("LDAPException handled ! "+e.toString());
//		} catch (ConfigException e) {
//			updateDisplayActionResult("ConfigException handled ! "+e.toString());
//		} finally {
//		}
//		updateDisplayNumberLDAPEntries(numberLDAPEntries);
//		
//		return numberLDAPEntries;
//	}
	
	public boolean mkdir(String path) {
		
		boolean success = false;
		
		try {
			success = webdavManager.mkdir(path);
		} catch (HttpException e) {
			updateDisplayActionResult("HttpException handled ! "+e.toString());
		} catch (IOException e) {
			updateDisplayActionResult("IOException handled ! "+e.toString());
		} finally {
		}
	
		if (success) updateDisplayActionResult("Directory "+path+" created successfully");
		else  updateDisplayActionResult("Directory creation failed : "+path+" !");
		
		return success;
	}
	
	public boolean rm(String path) {
		
		boolean success = false;
		
		try {
			success = webdavManager.rm(path);
		} catch (HttpException e) {
			updateDisplayActionResult("HttpException handled ! "+e.toString());
		} catch (IOException e) {
			updateDisplayActionResult("IOException handled ! "+e.toString());
		} finally {
		}
	
		if (success) updateDisplayActionResult("Directory "+path+" deleted successfully");
		else  updateDisplayActionResult("Directory deletion failed : "+path+" !");
		
		return success;
	}
	
//	public boolean createInjacSpace(String injacPath, String spaceName, String admin, String commonWebDAVChannelAccount) {
//		
//		boolean success = false;
//		
//		try {
//			success = injacSpacesManager.createInjacSpace(injacPath, spaceName, admin, commonWebDAVChannelAccount);
//		} catch (HttpException e) {
//			updateDisplayActionResult("HttpException handled ! "+e.toString());
//		} catch (IOException e) {
//			updateDisplayActionResult("IOException handled ! "+e.toString());
//		} catch (WrongPathException e) {
//			updateDisplayActionResult("WrongPathException handled ! "+e.toString());
//		} catch (ReadAclException e) {
//			updateDisplayActionResult("ReadAclException handled ! "+e.toString());
//		} catch (WriteAclException e) {
//			updateDisplayActionResult("WriteAclException handled ! "+e.toString());
//		} finally {
//		}
//	
//		if (success) updateDisplayActionResult("Space "+spaceName+" created successfully");
//		else  updateDisplayActionResult("Space creation failed !");
//		
//		return success;
//	}
	
	public boolean createSpace(String path, String spaceName, String LDAPFilter, String LDAPAttribute, String regexp, String regexpSeparator, String xmlFilePath, String forceSetProperties) {
		
		boolean success = false;
		
		try {
			success = spaceManager.createSpace(path, spaceName, LDAPFilter, LDAPAttribute, regexp, regexpSeparator, xmlFilePath, forceSetProperties);
		} catch (HttpException e) {
			updateDisplayActionResult("HttpException handled ! "+e.toString());
		} catch (ConfigurationException e) {
			updateDisplayActionResult("ConfigurationException handled ! "+e.toString());
		} catch (WrongPathException e) {
			updateDisplayActionResult("WrongPathException handled ! "+e.toString());
		} catch (LDAPException e) {
			updateDisplayActionResult("LDAPException handled ! "+e.toString());
		} catch (IOException e) {
			updateDisplayActionResult("IOException handled ! "+e.toString());
		} catch (ConfigException e) {
			updateDisplayActionResult("ConfigException handled ! "+e.toString());
		}
		
		if (success) updateDisplayActionResult("Space(s) created successfully");
		else  updateDisplayActionResult("Space(s) creation failed !");
		
		return success;
	}
	
	/**
	 * Display the quota-available-bytes metadata in the presentation class
	 * @param quotaAvailableBytes
	 */
	public void updateDisplayQAB(int quotaAvailableBytes) {
		pQuotaManager.displayQuotaAvailableBytes(quotaAvailableBytes);
	}// updateDisplayQAB
	
	/**
	 * Display the quota-used-bytes metadata in the presentation class
	 * @param quotaAvailableBytes
	 */
	public void updateDisplayQUB(int quotaUsedBytes) {
		pQuotaManager.displayQuotaUsedBytes(quotaUsedBytes);
	}// updateDisplayQAB
	
	/**
	 * @param string
	 */
	private void updateDisplayActionResult(String actionResult) {
		pQuotaManager.displayActionResult(actionResult);
	}
	
	/**
	 * @param children
	 */
	private void updateDisplayChildren(String children) {
		pQuotaManager.displayChildren(children);
	}
	
	/**
	 * @param virtualRoot
	 */
	private void updateDisplayVR(boolean virtualRoot) {
		pQuotaManager.displayVirtualRoot(virtualRoot);
		
	}
	
	/**
	 * @param path
	 */
	private void updateDisplayCd(String path) {
		pQuotaManager.displayCd(path);
		
	}
	
	/**
	 * @param exist
	 */
	private void updateDisplayExist(boolean exist) {
		pQuotaManager.displayExist(exist);
		
	}
	
	/**
	 * @param numberLDAPEntries
	 */
	private void updateDisplayNumberLDAPEntries(int numberLDAPEntries) {
		pQuotaManager.displayNumberLDAPEntries(numberLDAPEntries);
	}
}// CQuotaManager
