/**
 * @author Thomas Bellembois
 * @version
 * 
 * Creation date : 8 nov. 2005
 * Last modification :
 */
package org.esupportail.injac.webdavServer.tools.xmlUtils;

import java.io.IOException;
import java.net.MalformedURLException;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

/**
 * @author tbellemb
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class XMLUtils {
	
	public static void main(String[] args) {
		try {
			boolean valide = XMLUtils.isValide("properties/folderManager_pattern.xml", "properties/folderManager_pattern.dtd");
			System.out.println(valide);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private static Log log;
		
	public XMLUtils() {
		log = LogFactory.getLog(getClass().getName());
	}
	
	public class ErrorChecker implements ErrorHandler {
		public void error(SAXParseException exception) throws SAXException {
			throw new SAXException(exception.getMessage()); 
		}
		
		public void fatalError(SAXParseException exception) throws SAXException {
			throw new SAXException(exception.getMessage()); 
		}
		
		public void warning(SAXParseException exception) throws SAXException {
			throw new SAXException(exception.getMessage()); 
		}
	}
		
	public static boolean isValide (String XMLFilePath, String SchemaPath) throws ConfigurationException, MalformedURLException {
		XMLUtils xmlUtils = new XMLUtils();
		return xmlUtils._isValide(XMLFilePath, SchemaPath);
	}
	
	public boolean _isValide (String XMLFilePath, String SchemaPath) {
		
		boolean result = false;
		
		DOMParser parser = new DOMParser();
		try {
			parser.setFeature("http://xml.org/sax/features/validation", true);
			parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", SchemaPath);
			ErrorChecker errors = new ErrorChecker();
			parser.setErrorHandler(errors);
			parser.parse(XMLFilePath);
			result = true;
		} catch (SAXNotRecognizedException e) {
			log.error("SAXNotRecognizedException handled !\n");
			if (log.isDebugEnabled()) {
				e.printStackTrace();
			} else log.error(e.toString()+"\n");
		} catch (SAXNotSupportedException e) {
			log.error("SAXNotSupportedException handled !\n");
			if (log.isDebugEnabled()) {
				e.printStackTrace();
			} else log.error(e.toString()+"\n");
		} catch (SAXException e) {
			log.error("SAXException handled !\n");
			if (log.isDebugEnabled()) {
				e.printStackTrace();
			} else log.error(e.toString()+"\n");
		} catch (IOException e) {
			log.error("IOException handled !\n");
			if (log.isDebugEnabled()) {
				e.printStackTrace();
			} else log.error(e.toString()+"\n");
		} 
		finally {
		}
		return result;
	}
}
