/*
 * $Header: /home/cvs/jakarta-slide/projector/src/java/org/apache/slide/projector/descriptor/Attic/TreeValueDescriptor.java,v 1.3 2004/08/03 14:27:18 dflorey Exp $
 * $Revision: 1.3 $
 * $Date: 2004/08/03 14:27:18 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.projector.descriptor;

import org.apache.slide.projector.Context;
import org.apache.slide.projector.value.ArrayValue;
import org.apache.slide.projector.value.Value;

/**
 * The TreeValueDescriptor class
 * 
 */
public class TreeValueDescriptor implements ValueDescriptor {
	private ValueDescriptor entryValueDescriptor;
    private ValueDescriptor arrayValueDescriptor;

    public TreeValueDescriptor() {
        this.entryValueDescriptor = null;
        arrayValueDescriptor = new ArrayValueDescriptor(this);
    }

    public TreeValueDescriptor(ValueDescriptor entryValueDescriptor) {
        this.entryValueDescriptor = entryValueDescriptor;
        arrayValueDescriptor = new ArrayValueDescriptor(this);
    }

    public Value valueOf(Object value, Context context) throws ValueCastException {
        try {
            return arrayValueDescriptor.valueOf(value, context);
        } catch ( ValueCastException exception ) {
            return entryValueDescriptor.valueOf(value,  context);
        }
    }

    public void validate(Value value, Context context) throws ValidationException {
    	if ( value instanceof ArrayValue ) {
            arrayValueDescriptor.validate(value, context);
    	} else {
            entryValueDescriptor.validate(value,  context);
        }
    }
}