/*
 * $Header: /home/cvs/jakarta-slide/projector/src/java/org/apache/slide/projector/processor/core/MapEntry.java,v 1.5 2004/08/04 15:22:49 dflorey Exp $
 * $Revision: 1.5 $
 * $Date: 2004/08/04 15:22:49 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.projector.processor.core;

import java.util.Map;

import org.apache.slide.projector.ContentType;
import org.apache.slide.projector.Context;
import org.apache.slide.projector.Processor;
import org.apache.slide.projector.Result;
import org.apache.slide.projector.descriptor.MapValueDescriptor;
import org.apache.slide.projector.descriptor.ParameterDescriptor;
import org.apache.slide.projector.descriptor.ResultDescriptor;
import org.apache.slide.projector.descriptor.ResultEntryDescriptor;
import org.apache.slide.projector.descriptor.StateDescriptor;
import org.apache.slide.projector.descriptor.StringValueDescriptor;
import org.apache.slide.projector.i18n.DefaultMessage;
import org.apache.slide.projector.i18n.ParameterMessage;
import org.apache.slide.projector.processor.SimpleProcessor;
import org.apache.slide.projector.value.MapValue;
import org.apache.slide.projector.value.StringValue;
import org.apache.slide.projector.value.Value;

/**
 * The MapEntry class
 * 
 */
public class MapEntry implements Processor {
    private final static String MAP = "map";
    private final static String KEY = "key";

    private final static String KEY_NOT_FOUND = "keyNotFound";

    private final static ParameterDescriptor[] parameterDescriptors = new ParameterDescriptor[] {
        new ParameterDescriptor(MAP, new ParameterMessage("mapEntry/map"), MapValueDescriptor.ANY),
        new ParameterDescriptor(KEY, new ParameterMessage("mapEntry/key"), new StringValueDescriptor())
    };

    private final static ResultDescriptor resultDescriptor = new ResultDescriptor(
            new StateDescriptor[] {
                StateDescriptor.OK_DESCRIPTOR,
                new StateDescriptor(KEY_NOT_FOUND, new DefaultMessage("mapEntry/state/keyNotFound"))},
            new ResultEntryDescriptor[] {
                new ResultEntryDescriptor(SimpleProcessor.OUTPUT, new DefaultMessage("mapEntry/output"), ContentType.DYNAMIC, false)
            });

    public Result process(Map parameter, Context context) throws Exception {
        Map map = ((MapValue)parameter.get(MAP)).getMap();
        String key = ((StringValue)parameter.get(KEY)).toString();
        Value entry = (Value)map.get(key);
        if ( entry == null ) return new Result(KEY_NOT_FOUND);
        return new Result(StateDescriptor.OK, SimpleProcessor.OUTPUT, entry);
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return parameterDescriptors;
    }

    public ResultDescriptor getResultDescriptor() {
        return resultDescriptor;
    }
}
