/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPReferralHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class LDAPConstraints
implements Cloneable,
Serializable {
    private int msLimit = 0;
    private int hopLimit = 10;
    private boolean doReferrals = false;
    private LDAPReferralHandler refHandler = null;
    private LDAPControl[] controls = null;
    private static Object nameLock = new Object();
    private static int lConsNum = 0;
    private String name;
    private Hashtable properties = null;

    public LDAPConstraints() {
    }

    public LDAPConstraints(int n, boolean bl, LDAPReferralHandler lDAPReferralHandler, int n2) {
        this.msLimit = n;
        this.doReferrals = bl;
        this.refHandler = lDAPReferralHandler;
        this.hopLimit = n2;
    }

    public LDAPControl[] getControls() {
        return this.controls;
    }

    public int getHopLimit() {
        return this.hopLimit;
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    Hashtable getProperties() {
        return this.properties;
    }

    public boolean getReferralFollowing() {
        return this.doReferrals;
    }

    LDAPReferralHandler getReferralHandler() {
        return this.refHandler;
    }

    public int getTimeLimit() {
        return this.msLimit;
    }

    public void setControls(LDAPControl lDAPControl) {
        if (lDAPControl == null) {
            this.controls = null;
            return;
        }
        this.controls = new LDAPControl[1];
        this.controls[0] = (LDAPControl)lDAPControl.clone();
    }

    public void setControls(LDAPControl[] lDAPControlArray) {
        if (lDAPControlArray == null || lDAPControlArray.length == 0) {
            this.controls = null;
            return;
        }
        this.controls = new LDAPControl[lDAPControlArray.length];
        for (int i = 0; i < lDAPControlArray.length; ++i) {
            this.controls[i] = (LDAPControl)lDAPControlArray[i].clone();
        }
    }

    public void setHopLimit(int n) {
        this.hopLimit = n;
    }

    public void setProperty(String string, Object object) throws LDAPException {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(string, object);
    }

    void setProperties(Hashtable hashtable) {
        this.properties = (Hashtable)hashtable.clone();
    }

    public void setReferralFollowing(boolean bl) {
        this.doReferrals = bl;
    }

    public void setReferralHandler(LDAPReferralHandler lDAPReferralHandler) {
        this.refHandler = lDAPReferralHandler;
    }

    public void setTimeLimit(int n) {
        this.msLimit = n;
    }

    public Object clone() {
        try {
            Object object = super.clone();
            if (this.controls != null) {
                ((LDAPConstraints)object).controls = (LDAPControl[])this.controls.clone();
            }
            if (this.properties != null) {
                ((LDAPConstraints)object).properties = (Hashtable)this.properties.clone();
            }
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

