/**
 * @author Thomas Bellembois
 * @version 1.0
 *
 * An _LDAPAttribute represents an LDAP attribute. An _LDAPAttribute has one or several values.<br/>
 * It is made of a name (String) and a Vector of values (Vector of String)
 *  
 * Creation date : 22 nov. 2005
 * Last modification :
 */
package fr.univrennes1.cri.util.ldapUtils;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ESUP_LDAPAttribute {
	
	private String name;
	// Vector of String
	private Vector values;
	
	private Log log;
	
	public ESUP_LDAPAttribute(String name, Vector values) {
		log = LogFactory.getLog(getClass().getName());
		this.name = name;
		this.values = values;
	}// _LDAPAttribute
	
	/**
	 * Gets the attribute name
	 * @return the attribute name as a String
	 */
	public String getName() {
		log.debug("getName");
		return name;
	}// getName
	
	/**
	 * Sets the attribute name
	 * @param name the attribute name
	 */
	public void setName(String name) {
		log.debug("setName:name="+name);
		this.name = name;
	}// setName
	
	/**
	 * Gets the attribute values
	 * @return the attribute values as an Enumeration
	 */
	public Enumeration getValues() {
		log.debug("getValues");
		return values.elements();
	}// getValues
	
	/**
	 * Gets the attribute value if there is only one value
	 * @return the attribute value as an String, null if there are several values
	 */
	public String getValue() {
		log.debug("getValue");
		if (values == null) {
			log.debug("getValue:property with no value");
			return null;
		}
		if (isMono()) {
			return (String)getValues().nextElement();
		}// if (isMono())
		else {
			log.debug("getValue:this property has more than one value !");
			return null;
		}// else (isMono())
	}// getValues
	
	/**
	 * Adds a value
	 * @param value the new value
	 */
	public void addValue(String value) {
		log.debug("addValue:value="+value);
		values.add(value);
	}// addValue
	
	/**
	 * Gets the attribut type
	 * @return true if the attribute has only one value
	 */
	public boolean isMono() {
		if (values != null)	return values.size() == 1;
		else return false;
	}// isMono
	
	/**
	 * Gets the attribut type
	 * @return true if the attribute has more than one value
	 */
	public boolean isMulti() {
		if (values != null)	return values.size() > 1;
		else return false;
	}// isMulti
	
	/**
	 * Returns a String representation of the attribute
	 */
	public String toString() {
		String valuesList = "";
		Enumeration _values = values.elements();
		while (_values.hasMoreElements()) {
			String currentValue = (String) _values.nextElement();
			valuesList = valuesList + currentValue+" ";
		}// while (_values.hasMoreElements())
		valuesList = valuesList.trim();
		
		return name+"="+valuesList;
	}// toString
	
}//LdapAtribute
