/*
 * $Header: /home/cvs/jakarta-slide/projector/src/java/org/apache/slide/projector/processor/query/ResourceQuery.java,v 1.3 2004/07/28 09:47:46 ib Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/28 09:47:46 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.projector.processor.query;

import java.util.Map;

import org.apache.slide.projector.Context;
import org.apache.slide.projector.Processor;
import org.apache.slide.projector.Projector;
import org.apache.slide.projector.Result;
import org.apache.slide.projector.descriptor.ParameterDescriptor;
import org.apache.slide.projector.descriptor.ResultDescriptor;
import org.apache.slide.projector.descriptor.ResultEntryDescriptor;
import org.apache.slide.projector.descriptor.StateDescriptor;
import org.apache.slide.projector.descriptor.StringValueDescriptor;
import org.apache.slide.projector.i18n.DefaultMessage;
import org.apache.slide.projector.i18n.ParameterMessage;
import org.apache.slide.projector.processor.SimpleProcessor;
import org.apache.slide.projector.value.ArrayValue;
import org.apache.slide.projector.value.StringValue;
import org.apache.slide.projector.value.Value;

/**
 * The Query class
 * 
 */
public class ResourceQuery implements Processor {
    private final static String EMPTY = "empty";
    private final static String DASL_QUERY = "query";

    private static ResultDescriptor resultDescriptor = new ResultDescriptor(
            new StateDescriptor[] {
                StateDescriptor.OK_DESCRIPTOR,
                new StateDescriptor(EMPTY, new DefaultMessage("resourceQuery/state/empty"))},
            new ResultEntryDescriptor[] {
                new ResultEntryDescriptor(SimpleProcessor.OUTPUT, new DefaultMessage("queryResult"), ArrayValue.CONTENT_TYPE, false)
            });

    private static ParameterDescriptor []parameterDescriptors = new ParameterDescriptor[] {
        new ParameterDescriptor(DASL_QUERY, new ParameterMessage("daslQuery"), new StringValueDescriptor())
    };

    public Result process(Map parameter, Context context) throws Exception {
        String query = ((StringValue)parameter.get(DASL_QUERY)).toString();
        Value []values = Projector.getRepository().search(query, context.getCredentials());
        if ( values.length == 0 ) return new Result(EMPTY);
        return new Result(StateDescriptor.OK, SimpleProcessor.OUTPUT, new ArrayValue(values));
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return parameterDescriptors;
    }

    public ResultDescriptor getResultDescriptor() {
        return resultDescriptor;
    }
}