/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.Connection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.Message;
import com.novell.ldap.MessageVector;
import com.novell.ldap.client.BindProperties;

class MessageAgent {
    private MessageVector messages = new MessageVector(5, 5);
    private int indexLastRead = 0;
    private static Object nameLock = new Object();
    private static int agentNum = 0;
    private String name;

    MessageAgent() {
    }

    Object[] getMessageArray() {
        return this.messages.getObjectArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void merge(MessageAgent messageAgent) {
        Object[] objectArray = messageAgent.getMessageArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.messages.addElement(objectArray[i]);
            ((Message)objectArray[i]).setAgent(this);
        }
        MessageVector messageVector = this.messages;
        synchronized (messageVector) {
            if (objectArray.length > 1) {
                this.messages.notifyAll();
            } else if (objectArray.length == 1) {
                this.messages.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sleepersAwake(boolean bl) {
        MessageVector messageVector = this.messages;
        synchronized (messageVector) {
            if (bl) {
                this.messages.notifyAll();
            } else {
                this.messages.notify();
            }
        }
    }

    final boolean isResponseReceived() {
        int n = this.messages.size();
        int n2 = this.indexLastRead + 1;
        for (int i = 0; i < n; ++i) {
            Message message;
            if (n2 == n) {
                n2 = 0;
            }
            if (!(message = (Message)this.messages.elementAt(n2)).hasReplies()) continue;
            return true;
        }
        return false;
    }

    final boolean isResponseReceived(int n) {
        try {
            Message message = this.messages.findMessageById(n);
            return message.hasReplies();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
    }

    final void abandon(int n, LDAPConstraints lDAPConstraints) {
        Message message = null;
        try {
            message = this.messages.findMessageById(n);
            this.messages.removeElement(message);
            message.abandon(lDAPConstraints, null);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
    }

    final void abandonAll() {
        int n = this.messages.size();
        for (int i = 0; i < n; ++i) {
            Message message = (Message)this.messages.elementAt(i);
            this.messages.removeElement(message);
            message.abandon(null, null);
        }
    }

    final int[] getMessageIDs() {
        int n = this.messages.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Message message = (Message)this.messages.elementAt(i);
            nArray[i] = message.getMessageID();
        }
        return nArray;
    }

    final boolean isComplete(int n) {
        try {
            Message message = this.messages.findMessageById(n);
            if (!message.isComplete()) {
                return false;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return true;
    }

    final Message getMessage(int n) throws NoSuchFieldException {
        return this.messages.findMessageById(n);
    }

    final void sendMessage(Connection connection, LDAPMessage lDAPMessage, int n, LDAPMessageQueue lDAPMessageQueue, BindProperties bindProperties) throws LDAPException {
        Message message = new Message(lDAPMessage, n, connection, this, lDAPMessageQueue, bindProperties);
        this.messages.addElement(message);
        message.sendMessage();
    }

    final Object getLDAPMessage(Integer n) {
        if (this.messages.size() == 0) {
            return null;
        }
        if (n != null) {
            try {
                Message message = this.messages.findMessageById(n);
                Object object = message.waitForReply();
                if (!message.acceptsReplies() && !message.hasReplies()) {
                    this.messages.removeElement(message);
                    message.abandon(null, null);
                }
                return object;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return null;
            }
        }
        MessageVector messageVector = this.messages;
        synchronized (messageVector) {
            while (true) {
                int n2 = this.indexLastRead + 1;
                for (int i = 0; i < this.messages.size(); ++i) {
                    if (n2 >= this.messages.size()) {
                        n2 = 0;
                    }
                    Message message = (Message)this.messages.elementAt(n2);
                    this.indexLastRead = n2++;
                    Object object = message.getReply();
                    if (!message.acceptsReplies() && !message.hasReplies()) {
                        this.messages.removeElement(message);
                        message.abandon(null, null);
                        --i;
                    }
                    if (object == null) continue;
                    return object;
                }
                if (this.messages.size() == 0) {
                    return null;
                }
                try {
                    this.messages.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    String getAgentName() {
        return this.name;
    }

    int getCount() {
        int n = 0;
        Object[] objectArray = this.messages.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Message message = (Message)objectArray[i];
            n += message.getCount();
        }
        return n;
    }

    private void debugDisplayMessages() {
    }
}

