/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.connectionpool;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPResponseQueue;
import com.novell.ldap.LDAPSocketFactory;

class Connection
extends LDAPConnection
implements Cloneable {
    private boolean inUse = false;
    private boolean allowPoolBind = false;

    public Connection(LDAPSocketFactory lDAPSocketFactory) {
        super(lDAPSocketFactory);
    }

    boolean inUse() {
        return this.inUse;
    }

    boolean setInUse() {
        this.inUse = true;
        return this.inUse;
    }

    boolean clearInUse() {
        this.inUse = false;
        return this.inUse;
    }

    public Object clone() {
        return super.clone();
    }

    void poolBind(int n, String string, byte[] byArray) throws LDAPException {
        try {
            this.allowPoolBind = true;
            super.bind(n, string, byArray);
        }
        catch (LDAPException lDAPException) {
            throw lDAPException;
        }
        finally {
            this.allowPoolBind = false;
        }
    }

    public LDAPResponseQueue bind(int n, String string, byte[] byArray, LDAPResponseQueue lDAPResponseQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (this.allowPoolBind) {
            return super.bind(n, string, byArray, lDAPResponseQueue, lDAPConstraints);
        }
        throw new LDAPLocalException("CANNOT_BIND", 82);
    }
}

