/*
 * $Header: /home/cvs/jakarta-slide/src/stores/org/apache/slide/store/impl/rdbms/SybaseRDBMSAdapter.java,v 1.5 2004/07/28 09:34:16 ib Exp $
 * $Revision: 1.5 $
 * $Date: 2004/07/28 09:34:16 $
 *
 * ====================================================================
 *
 * Copyright 1999-2003 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.store.impl.rdbms;

import org.apache.slide.common.*;
import org.apache.slide.util.logger.Logger;

/**
 * Adapter for Sybase. Actually does not change a thing from SQLServerRDBMSAdapter.
 * 
 * @version $Revision: 1.5 $
 */

public class SybaseRDBMSAdapter extends SQLServerRDBMSAdapter {

    protected static final String LOG_CHANNEL = SybaseRDBMSAdapter.class.getName();

    public SybaseRDBMSAdapter(Service service, Logger logger) {
        super(service, logger);
    }

    protected String getExistsQuery(String sequenceName) {
        String selectQuery = "SELECT * FROM dbo.sysobjects WHERE name = '" + normalizeSequenceName(sequenceName) + "'";
        return selectQuery;
    }

}
