/**
 * @author Thomas Bellembois
 * @version
 * 
 * Creation date : 05 ao�t 2005
 * Last modification :
 */
package org.esupportail.injac.webdavServer.esupWDServerManager.core.webDAVManager;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.webdav.lib.WebdavResource;

public class WebDAVManager {

	private static Log log;
	
	private HttpURL httpUrl;
	private WebdavResource webDavResource;
	private String context;
	private boolean connected;
	
	public WebDAVManager() {
		connected = false;
		log = LogFactory.getLog(getClass().getName());
	}
	
	
	/**
	 * Verify if the WebDAV ressource exits
	 * @param webDavResource
	 * @param path syntax: /{context}/path - exemple: /slide/files/myRessource
	 * @return true if the path exists, else false
	 */
	private boolean pathExist(WebdavResource webDavResource, String path){
		
		log.info("pathExist:path="+path);
		
		if (!connected) {
			log.info("You are not connected to server !");
			return false;
		}
		
		boolean exist = false;
		
		try {
			webDavResource.setPath(path);
			exist = webDavResource.exists();
		} catch (HttpException httpException) {
			log.debug("pathExist:path="+path+" > false");
			return false;
		} catch (IOException ioException) {
			log.debug("pathExist:"+ioException.toString());
		}
		
		log.info("pathExist:path="+path+" > "+exist);
		return exist;
	}// isExist
	
	
	public boolean connect(String webdavServerUrl, String userName, String password) throws HttpException, IOException { 	
	
		log.info("connect:webdavServerUrl="+webdavServerUrl+" userName="+userName);
		
		if (webdavServerUrl == null) {
			log.error("connect:webdavServerUrl can not be null");
			return false;
		}
		if (userName == null) userName = "";
		if (password == null) password = "";
		
		httpUrl = new HttpURL(webdavServerUrl+"/");
		httpUrl.setUserinfo(userName, password);
		context = httpUrl.getCurrentHierPath();
		if (context.equalsIgnoreCase("/")) context = "";
		log.info("connect:context="+context);
		webDavResource = new WebdavResource(httpUrl);
		
		connected = webDavResource.getStatusCode() != 0;
		
		log.info("connect:success=true");
		return connected;
	}
	
	
	public boolean cd(String path) throws HttpException, IOException {
		
		log.info("cd:path="+path);
		
		if (!connected) {
			log.info("You are not connected to server !");
			return false;
		}
		
		if (path == null || path.equals("")) {
			log.error("cd:path can not be null or empty");
			return false;
		}
		
		boolean success = false;
		
		if (pathExist(webDavResource, context+path)) {
			webDavResource.setPath(path);
			success = true;
		}
		
		log.info("cd:success="+success);
		return success;
	}
	
	
	public Enumeration getChildren(String path) throws HttpException, IOException {
		
		log.info("getChildren:path="+path);
		
		if (!connected) {
			log.info("You are not connected to server !");
			return null;
		}
		
		if (path == null) {
			log.error("cd:path can not be null");
			return null;
		}
		
		Vector result = new Vector();
		
		if (!pathExist(webDavResource, context+path)) return null;
		
		Enumeration childResources = webDavResource.getChildResources().getResources();
		
		while (childResources.hasMoreElements()) {
			String childResourcePath = ((WebdavResource)(childResources.nextElement())).getPath();
			log.debug("childResourcePath:path="+path);
			childResourcePath = childResourcePath.substring(context.length());
			result.add(childResourcePath);
		}// while (childResources.hasMoreElements())
		
		return result.elements();
	}
	
	
	public boolean mkdir(String path) throws HttpException, IOException {
		
		log.info("mkdir:path="+path);
		
		if (!connected) {
			log.info("You are not connected to server !");
			return false;
		}
		
		boolean success = false;
		
		if (pathExist(webDavResource, context+path)) {
			log.error("mkdir:path "+path+" already exist !");
			return false;
		}
		
		log.debug("mkdir:creating directory "+context+path);
		success = webDavResource.mkcolMethod(context+path);
				
		log.info("mkdir:success="+success);
		return success;
	}
	
	
	public boolean rm(String path) throws HttpException, IOException {
		
		log.info("rm:path="+path);
		
		if (!connected) {
			log.info("You are not connected to server !");
			return false;
		}
		
		boolean success = false;
		
		if (!pathExist(webDavResource, context+path)) {
			log.error("rm:path "+path+" does not exist !");
			return false;
		}
		
		log.debug("rm:creating directory "+context+path);
		success = webDavResource.deleteMethod(context+path);
		
		log.info("rm:success="+success);
		return success;
	}
	
}// WebDAVClient
