/*
 * $Header: /home/cvs/jakarta-slide/src/share/org/apache/slide/search/basic/IBasicExpression.java,v 1.5 2004/07/28 09:35:01 ib Exp $
 * $Revision: 1.5 $
 * $Date: 2004/07/28 09:35:01 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.search.basic;

import org.apache.slide.search.SearchException;

/**
 * An IBasicExpression represents an executable part of the expression tree.
 * Different stores may have different implementations.
 *
 * @version $Revision: 1.5 $
 */
public interface IBasicExpression {
    
    /**
     * Method execute
     *
     * @return   a Set of RequestedResource objects
     *
     * @throws   SearchException
     *
     */
    IBasicResultSet execute () throws SearchException;
    
    /**
     * Method getFactory
     *
     * @return   the factory which was used to create this expression
     *
     */
    IBasicExpressionFactory getFactory ();
    
    /**
     * Method setFactory
     *
     * @param    factory      the factory which was used to create this expression
     *
     */
    void setFactory (IBasicExpressionFactory factory);
    
}

