/*
 * $Header: /home/cvs/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/resourcekind/VersionImpl.java,v 1.6 2004/08/05 14:43:32 dflorey Exp $
 * $Revision: 1.6 $
 * $Date: 2004/08/05 14:43:32 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.webdav.util.resourcekind;

import java.util.Set;


public class VersionImpl extends AbstractResourceKind implements Version {
    
    protected static ResourceKind singleton = null;
    
    /**
     * Factory method.
     */
    static public ResourceKind getInstance() {
        if( singleton == null )
            singleton = new VersionImpl();
        return singleton;
    }
    
    /**
     * Protected constructor
     */
    protected VersionImpl() {
    }

    /**
     * Get the set properties supported by this resource kind.
     * @param filter Q_PROTECTED_ONLY or Q_COMPUTED_ONLY (no filtering if null)
     * @param excludedFeatures array of F_* constants (no filtering if null or empty)
     * @see org.apache.slide.webdav.util.WebdavConstants
     * @see org.apache.slide.webdav.util.DeltavConstants
     * @see org.apache.slide.webdav.util.AclConstants
     * @see org.apache.slide.webdav.util.DaslConstants
     */
    public Set getSupportedLiveProperties( String[] excludedFeatures ) {
        Set s = super.getSupportedLiveProperties( excludedFeatures );
        if( isSupportedFeature(F_VERSION_CONTROL, excludedFeatures) ) {
            s.add( P_PREDECESSOR_SET );
            s.add( P_SUCCESSOR_SET );
            s.add( P_CHECKOUT_SET );
            s.add( P_VERSION_NAME );
        }
        if( isSupportedFeature(F_CHECKOUT_IN_PLACE, excludedFeatures) 
        || isSupportedFeature(F_WORKING_RESOURCE, excludedFeatures) ) {
            s.add( P_CHECKOUT_FORK );
            s.add( P_CHECKIN_FORK );
        }
        if( isSupportedFeature(F_VERSION_HISTORY, excludedFeatures) )
            s.add( P_VERSION_HISTORY );
        if( isSupportedFeature(F_LABEL, excludedFeatures) )
            s.add( P_LABEL_NAME_SET );
        if( isSupportedFeature(F_ACTIVITY, excludedFeatures) )
            s.add( P_ACTIVITY_SET);
        return s;
    }

    /**
     * Get the set methods supported by this resource kind.
     */
    public Set getSupportedMethods() {
        Set s = super.getSupportedMethods();
        if( isSupportedFeature(F_LABEL) )
            s.add( M_LABEL );
        if( isSupportedFeature(F_WORKING_RESOURCE) )
            s.add( M_CHECKOUT );
        return s;
    }

    /**
     * Get the set reports supported by this resource kind.
     */
    public Set getSupportedReports() {
        Set s = super.getSupportedReports();
        if( isSupportedFeature(F_VERSION_CONTROL) )
            s.add( R_VERSION_TREE );
        return s;
    }
    
    /**
     *
     */
    public String toString() {
        return "version";
    }
}

