package org.esupportail.injac.webdavServer.esupWDServerManager.userInterface;


import java.net.MalformedURLException;
import java.rmi.RemoteException;

import javax.xml.rpc.ServiceException;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.injac.webdavServer.esupWDServerManager.Factory1;
import org.esupportail.injac.webdavServer.esupWDServerManager.Factory2;
import org.esupportail.injac.webdavServer.esupWDServerManager.controller.CWDServerManager;

public class Launcher {
	
	private static final String INTERFACE_COMMAND_LINE = "cl";
	private static final String INTERFACE_GRAPHIC = "gr";
	
	private static Log log;
	
	public Launcher() {
		log = LogFactory.getLog(getClass().getName());
	}// Launcher
	
	public static void main(String[] args) {
		
		try {
			
			String commandMode = null;
			String inputFile = null;
			
			Launcher launcher = new Launcher();
						
			if (args.length >=1) {
				
				commandMode = args[0];
				if (args.length ==2) inputFile = args[1];
				
				log.debug("commandMode="+commandMode+"\n");
				log.debug("inputFile="+inputFile+"\n");
				
				if (commandMode!=null && commandMode.equalsIgnoreCase(INTERFACE_COMMAND_LINE)) {
					Factory1 factory1 = new Factory1();
					if (args.length==2 && args[1] instanceof String) {
						factory1.setArgs((String)args[1]);
					}// if (args.length==2 && args[1] instanceof String)
					CWDServerManager cQuotaManager = (CWDServerManager)factory1.newCQuotaManager(factory1);
				}else if (commandMode!=null && commandMode.equalsIgnoreCase(INTERFACE_GRAPHIC)) {
					Factory2 factory2 = new Factory2();
					CWDServerManager cQuotaManager = (CWDServerManager)factory2.newCQuotaManager(factory2);
				}// if (commandMode.equalsIgnoreCase(INTERFACE_COMMAND_LINE))
				
			}else {
				log.error("Wrong arguments !\n");
				log.info("syntax: Launcher "+INTERFACE_COMMAND_LINE+" [fileName]\n");
				log.info("syntax: Launcher "+INTERFACE_GRAPHIC+" >>not implemented<<\n");
				log.info("Note : "+INTERFACE_COMMAND_LINE+" : command line interface with optional input file\n");
				log.info("       "+INTERFACE_GRAPHIC+" : graphic interface >>not implemented<<\n");
			}
			
		} catch (MalformedURLException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (RemoteException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (ConfigurationException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (ServiceException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
	}
}
