/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.util;

import org.apache.commons.transaction.util.LoggerFacade;

public class RendezvousBarrier {
    public static final int DEFAULT_TIMEOUT = 20000;
    protected final int parties;
    protected final String name;
    protected int count = 0;
    protected long timeout;
    protected LoggerFacade logger;

    public RendezvousBarrier(String name, LoggerFacade logger) {
        this(name, 20000L, logger);
    }

    public RendezvousBarrier(String name, long timeout, LoggerFacade logger) {
        this(name, 2, timeout, logger);
    }

    public RendezvousBarrier(String name, int parties, long timeout, LoggerFacade logger) {
        this.parties = parties;
        this.name = name;
        this.timeout = timeout;
        this.logger = logger;
    }

    public synchronized void call() {
        ++this.count;
        if (this.count >= this.parties) {
            if (this.logger.isFineEnabled()) {
                this.logger.logFine("Thread " + Thread.currentThread().getName() + " by CALL COMPLETING barrier " + this.name);
            }
            this.notifyAll();
        }
    }

    public synchronized void meet() throws InterruptedException {
        ++this.count;
        if (this.count >= this.parties) {
            if (this.logger.isFineEnabled()) {
                this.logger.logFine("Thread " + Thread.currentThread().getName() + " by MEET COMPLETING barrier " + this.name);
            }
            this.notifyAll();
        } else {
            if (this.logger.isFineEnabled()) {
                this.logger.logFine("At barrier " + this.name + " thread " + Thread.currentThread().getName() + " WAITING for " + (this.parties - this.count) + " of " + this.parties + " parties");
            }
            this.wait(this.timeout);
            if (this.count != 0) {
                if (this.count >= this.parties) {
                    if (this.logger.isFineEnabled()) {
                        this.logger.logFine("Thread " + Thread.currentThread().getName() + " CONTINUING at barrier " + this.name);
                    }
                } else {
                    if (this.logger.isFineEnabled()) {
                        this.logger.logFine("Thread " + Thread.currentThread().getName() + " FAILING at barrier " + this.name);
                    }
                    this.notifyAll();
                }
            }
        }
    }

    public synchronized void reset() {
        if (this.logger.isFineEnabled()) {
            this.logger.logFine("Resetting barrier " + this.name);
        }
        this.count = 0;
        this.notifyAll();
    }
}

