/**
 * @author Thomas Bellembois
 * @version
 * 
 * Creation date : 21 juil. 2005
 * Last modification :
 */
package org.esupportail.injac.webdavServer.esupWDServerManager.userInterface;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.esupportail.injac.webdavServer.esupWDServerManager.constants.Help;
import org.esupportail.injac.webdavServer.esupWDServerManager.constants.PQuotaManagerCL_constants;

import fr.univrennes1.cri.util.commonUtils.CommonUtils;
import fr.univrennes1.cri.util.ioUtils.CommentBufferedReader;

public class PWDServerManagerCL extends PWDServerManager implements PQuotaManagerCL_constants {
	
	public CLInterface cLInterface;
	
	private static CommentBufferedReader stdin;
		
	public class CLInterface extends Thread {

		public void run() {
			
			String commandCall = COM_CALL_DISPLAY_MENU;			
			boolean connected = false;	
			
			log.info(menu);
			log.info(Help.getString("quickStart")+"\n");
			
			while (!commandCall.equalsIgnoreCase(COM_CALL_QUIT)) {
				
				try {
					
					log.info(currentPath+">");
					commandCall = stdin.readLine();
					
					if (commandCall == null) {
						log.info("No input command - leaving... !\n");
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_DISPLAY_MENU)) {
						log.info(menu);
						if (!connected) log.info(Help.getString("quickStart")+"\n");
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_DISPLAY_CONNECT_PARAM)) {
						Hashtable configuration = getConfiguration();
						Enumeration keys = configuration.keys();
						while (keys.hasMoreElements()) {
							String key = (String)keys.nextElement();
							String value = (String)configuration.get(key);
							log.info(key+" > "+value+"\n");
						}// while (keys.hasMoreElements())
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_MODIFY_CONNECT_PARAM)) {
						log.info("Enter parameter name to modify :\n");
						propToModify = stdin.readLine();
						log.info("Enter the new value :\n");
						newValue = stdin.readLine();
						
						boolean result;
						try {
							result = modifyConfigurationProperty(propToModify, newValue);
							if (result) log.info("Parameter modified\n");
							else log.info("Parameter does not exist !\n");
						} catch (ConfigurationException e) {
							log.error("ConfigurationException handled !");
							log.error(e.toString());
						} catch (Exception e) {
							log.error("Not expected exception handled !");
							log.error(e.toString());
						}
					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_MODIFY_CONNECT_PARAM.toLowerCase())) {
						if ((commandCall.split(" ")).length != 2) {
							log.info("Wrong number of parameters !\n");
							commandCall = COM_CALL_MODIFY_CONNECT_PARAM;
						} else {
							String tmp = commandCall.substring(COM_CALL_MODIFY_CONNECT_PARAM.length()).trim();
							propToModify = StringUtils.substringBefore(tmp, "=");
							newValue  = StringUtils.substringBetween(tmp, "\"");
							boolean result;
							try {
								result = modifyConfigurationProperty(propToModify, newValue);
								if (result) log.info("Parameter modified\n");
								else log.info("Parameter does not exist !\n");
							} catch (ConfigurationException e) {
								log.error("ConfigurationException handled !");
								log.error(e.toString());
							} catch (Exception e) {
								log.error("Not expected exception handled !");
								log.error(e.toString());
							}
						}
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_CONNECT_WS)) {
						connectAction.execute();
						connected = true;
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_GET_RESOURCE_QUB)) {
						getQuotaUsedBytesAction.execute();
					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_GET_RESOURCE_QUB.toLowerCase())) {
						if ((commandCall.split(" ")).length < 2) {
							log.info("Wrong number of parameters !\n");
							commandCall = COM_CALL_GET_RESOURCE_QUB;
						} else {
							oldPath = currentPath;
							currentPath = StringUtils.substringBetween(commandCall, "\"");
							existAction.execute();
							if (resourceExists) {
								getQuotaUsedBytesAction.execute();
							}
							else {
								log.info("Resource does not exist!\n");
								currentPath = oldPath;
							}
							resourceExists = false; //not necessary, just in case of...
						}
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_GET_RESOURCE_QAB)) {
						getQuotaAvailableBytesAction.execute();
					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_GET_RESOURCE_QAB.toLowerCase())) {
						if ((commandCall.split(" ")).length < 2) {
							log.info("Wrong number of parameters !\n");
							commandCall = COM_CALL_GET_RESOURCE_QAB;
						} else {
							oldPath = currentPath;
							currentPath = StringUtils.substringBetween(commandCall, "\"");
							existAction.execute();
							if (resourceExists) {
								getQuotaAvailableBytesAction.execute();
							}
							else {
								log.info("Resource does not exist!\n");
								currentPath = oldPath;
							}
							resourceExists = false; //not necessary, just in case of...
						}
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_GET_RESOURCE_VR)) {
						getVirtualRootAction.execute();
					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_GET_RESOURCE_VR.toLowerCase())) {
						if ((commandCall.split(" ")).length < 2) {
							log.info("Wrong number of parameters !\n");
							commandCall = COM_CALL_GET_RESOURCE_VR;
						} else {
							oldPath = currentPath;
							currentPath = StringUtils.substringBetween(commandCall, "\"");
							existAction.execute();
							if (resourceExists) {
								getVirtualRootAction.execute();
							}
							else {
								log.info("Resource does not exist!\n");
								currentPath = oldPath;
							}
							resourceExists = false; //not necessary, just in case of...
						}
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_PATCH_RESOURCE_QUB)) {
						log.info("Enter parameter the new quota-used-bytes value (in bytes) :\n");
						String _newQuotaUsebBytes = stdin.readLine();
						if (!_newQuotaUsebBytes.matches("[0-9]+")) {
							log.info("Wrong number format!\n");
						} else {
							newQuotaUsebBytes = new Long(Long.parseLong(_newQuotaUsebBytes)).longValue();
							patchQuotaUsedBytesAction.execute();
						}
					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_PATCH_RESOURCE_QUB.toLowerCase())) {
						if ((commandCall.split(" ")).length < 3) {
							log.info("Wrong number of parameters !\n");
							commandCall = COM_CALL_PATCH_RESOURCE_QUB;
						} else {
							boolean doAction = true;
							oldPath = currentPath;
							currentPath  = StringUtils.substringBetween(commandCall, "\"");
							String _newQuotaUsebBytes = StringUtils.substringAfterLast(commandCall, " ");
							existAction.execute();
							if (!_newQuotaUsebBytes.matches("[0-9]+")) {
								log.info("Wrong number format!\n");
								currentPath = oldPath;
								doAction = false;
							}
							if (!resourceExists) {
								log.info("Resource does not exist!\n");
								currentPath = oldPath;
								doAction = false;
							}
							if (doAction) {
								newQuotaUsebBytes = new Long(Long.parseLong(_newQuotaUsebBytes)).longValue();
								patchQuotaUsedBytesAction.execute();
							}
							
							resourceExists = false; //not necessary, just in case of...
						}
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_PATCH_RESOURCE_QAB)) {
						log.info("Enter parameter the new quota-available-bytes value (in bytes) :\n");
						String _newQuotaAvailableBytes = stdin.readLine();
						if (!_newQuotaAvailableBytes.matches("[0-9]+")) {
							log.info("Wrong number format!\n");
						} else {
							newQuotaAvailableBytes = new Long(Long.parseLong(_newQuotaAvailableBytes)).longValue();
							patchQuotaAvailableBytesAction.execute();
						}
					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_PATCH_RESOURCE_QAB.toLowerCase())) {
						if ((commandCall.split(" ")).length < 3) {
							log.info("Wrong number of parameters !\n");
							commandCall = COM_CALL_PATCH_RESOURCE_QAB;
						} else {
							boolean doAction = true;
							oldPath = currentPath;
							currentPath  = StringUtils.substringBetween(commandCall, "\"");
							String _newQuotaAvailableBytes = StringUtils.substringAfterLast(commandCall, " ");
							existAction.execute();
							if (!_newQuotaAvailableBytes.matches("[0-9]+")) {
								log.info("Wrong number format!\n");
								currentPath = oldPath;
								doAction = false;
							}
							if (!resourceExists) {
								log.info("Resource does not exist!\n");
								currentPath = oldPath;
								doAction = false;
							}
							if (doAction) {
								newQuotaAvailableBytes = new Long(Long.parseLong(_newQuotaAvailableBytes)).longValue();
								patchQuotaAvailableBytesAction.execute();
							}
							resourceExists = false; //not necessary, just in case of...
						}
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_SET_RESOURCE_VR)) {
						log.info("Enter parameter the new virtual-root value (true/false) :\n");
						String _newVirtualRoot = stdin.readLine();
						if (_newVirtualRoot.equalsIgnoreCase("true") || _newVirtualRoot.equalsIgnoreCase("false")) {
							newVirtualRoot = Boolean.valueOf(_newVirtualRoot).booleanValue();
							setVirtualRootAction.execute();
						} else {
							log.info("Wrong answer!\n");
							log.info("Enter true or false\n");
						}
					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_SET_RESOURCE_VR.toLowerCase())) {
						if ((commandCall.split(" ")).length < 3) {
							log.info("Wrong number of parameters !\n");
							commandCall = COM_CALL_SET_RESOURCE_VR;
						} else {
							boolean doAction = true;
							oldPath = currentPath;
							currentPath  = StringUtils.substringBetween(commandCall, "\"");
							String _newVirtualRoot = StringUtils.substringAfterLast(commandCall, " ");
							existAction.execute();
							if (!(_newVirtualRoot.equalsIgnoreCase("true") || _newVirtualRoot.equalsIgnoreCase("false"))) {
								log.info("Wrong new virtual root!\n");
								log.info("Enter true or false\n");
								doAction = false;
							}
							if (!resourceExists) {
								log.info("Resource does not exist!\n");
								currentPath = oldPath;
								doAction = false;
							}
							if (doAction) {
								newVirtualRoot = Boolean.valueOf(_newVirtualRoot).booleanValue();
								setVirtualRootAction.execute();
							}
							
							resourceExists = false; //not necessary, just in case of...
						}
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_SET_QUOTA)) {
						String _childrenDepth = "";
						while(!_childrenDepth.matches("[0-9]+")) {
							log.info("Enter depth :\n");
							_childrenDepth = stdin.readLine();
						}
						childrenDepth = Integer.parseInt(_childrenDepth);
						
						String _newQuotaAvailableBytes = "";
						while(!_newQuotaAvailableBytes.matches("[0-9]+")) {
							log.info("Enter the quota (in Bytes) :\n");
							_newQuotaAvailableBytes = stdin.readLine();
						}
						newQuotaAvailableBytes = new Long(Long.parseLong(_newQuotaAvailableBytes)).longValue();
							
						String _calculateQuotaUsedBytes = "";
						while (!_calculateQuotaUsedBytes.equals("y") && !_calculateQuotaUsedBytes.equals("n")) {
							log.info("Calculate quota-used-bytes ? (y/n):\n");
							_calculateQuotaUsedBytes = stdin.readLine();
						}// while (!tmp.equals("y") || !tmp.equals("n"))
						if (_calculateQuotaUsedBytes.equals("y")) calculateQuotaUsedBytes = true;
						else calculateQuotaUsedBytes = false;
						setQuotaAction.execute();
					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_SET_QUOTA.toLowerCase())) {
						if ((commandCall.split(" ")).length < 5) {
							log.info("Wrong number of parameters !\n");
							commandCall = COM_CALL_SET_QUOTA;
						} else {
							boolean doAction = true;
							oldPath = currentPath;
							String tmp = commandCall.substring(COM_CALL_SET_QUOTA.length()).trim();
							currentPath  = StringUtils.substringBetween(commandCall, "\"");
							tmp = StringUtils.substringAfterLast(tmp, "\"").trim();
							String _childrenDepth = tmp.split(" ")[0];
							String _newQuotaAvailableBytes = tmp.split(" ")[1];
							String _calculateQuotaUsedBytes = tmp.split(" ")[2];
							existAction.execute();
							if (!_childrenDepth.matches("[0-9]+")) {
								log.info("Wrong number format for children depth\n");
								doAction = false;
							}
							if (!_newQuotaAvailableBytes.matches("[0-9]+")) {
								log.info("Wrong number format for quota available bytes\n");
								doAction = false;
							}
							if (!(_calculateQuotaUsedBytes.equalsIgnoreCase("true") || _calculateQuotaUsedBytes.equalsIgnoreCase("false"))) {
								log.info("Wrong format for children depth\n");
								log.info("Enter true or false\n");
								doAction = false;
							}
							if (!resourceExists) {
								log.info("Resource does not exist!\n");
								currentPath = oldPath;
								doAction = false;
							}
							if (doAction) {
								childrenDepth = Integer.parseInt(_childrenDepth);
								newQuotaAvailableBytes = new Long(Long.parseLong(_newQuotaAvailableBytes)).longValue();
								calculateQuotaUsedBytes = Boolean.valueOf(_calculateQuotaUsedBytes).booleanValue();
								setQuotaAction.execute();
							}
							resourceExists = false; //not necessary, just in case of...
						}
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_REMOVE_QUOTA)) {
						String tmpProcessChild = "";
						while (!tmpProcessChild.equals("y") && !tmpProcessChild.equals("n")) {
							log.info("Process children ? (y/n):\n");
							tmpProcessChild = stdin.readLine();
						}// while (!tmp.equals("y") || !tmp.equals("n"))
						if (tmpProcessChild.equals("y")) removeQuotaProcessChildren = true;
						else removeQuotaProcessChildren = false;
						removeQuotaAction.execute();
					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_REMOVE_QUOTA.toLowerCase())) {
						if ((commandCall.split(" ")).length < 3) {
							log.info("Wrong number of parameters !\n");
							commandCall = COM_CALL_REMOVE_QUOTA;
						} else {
							boolean doAction = true;
							oldPath = currentPath;
							String tmp = commandCall.substring(COM_CALL_REMOVE_QUOTA.length()).trim();
							currentPath  = StringUtils.substringBetween(commandCall, "\"");
							String _removeQuotaProcessChildren = StringUtils.substringAfterLast(tmp, "\"").trim();
							existAction.execute();
							if (!(_removeQuotaProcessChildren.equalsIgnoreCase("true") || _removeQuotaProcessChildren.equalsIgnoreCase("false"))) {
								log.info("Wrong format for process children\n");
								log.info("Enter true or false\n");
								doAction = false;
							}
							if (!resourceExists) {
								log.info("Resource does not exist!\n");
								currentPath = oldPath;
								doAction = false;
							}
							if (doAction) {
								removeQuotaAction.execute();
							}
							resourceExists = false; //not necessary, just in case of...
						}
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_CALCULATE_RESOURCE_QUB)) {
						calculateQuotaUsedBytesAction.execute();
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_DISPLAY_CHILDREN)) {
						childrenDepth = 1;
						getChildrenAction.execute();
					}
//					else if (commandCall.equalsIgnoreCase(COM_CALL_CREATE_HOMEDIR)) commandNbr = COM_NBR_CREATE_HOMEDIR;
//					else if (commandCall.equalsIgnoreCase(COM_CALL_CREATE_INJACSPACE)) commandNbr = COM_NBR_CREATE_INJACSPACE;
					else if (commandCall.equalsIgnoreCase(COM_CALL_CREATE_SPACE)) {
						
						log.info("Enter the space name:\n");
						spaceName = stdin.readLine();
						log.info("Enter the path:\n");
						currentPath = stdin.readLine();
						log.info("Enter the LDAP filter (press return if no LDAP filter):\n");
						spaceLDAPFilter = stdin.readLine();
						log.info("Enter the LDAP attribute (press return if no LDAP attribute):\n");
						spaceLDAPAttribute = stdin.readLine();
						log.info("Enter the regexp (press return if no regexp):\n");
						spaceRegexp = stdin.readLine();
						log.info("Enter the regexp separator (press return if no regexp separator):\n");
						spaceRegexpSeparator = stdin.readLine();
						log.info("Enter the pattern file path:\n");
						spacePatternFilePath = stdin.readLine();
						String _forceSetProperties = "";
						while (!_forceSetProperties.equals("y") && !_forceSetProperties.equals("n")) {
							log.info("Force set properties ?(y/n):\n");
							_forceSetProperties = stdin.readLine();
						}// while (!tmp.equals("y") || !tmp.equals("n"))
						if (_forceSetProperties.equals("y")) forceSetProperties = "true";
						else forceSetProperties = "false";
						createSpaceAction.execute();
					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_CREATE_SPACE.toLowerCase())) {
						String [] _commandCall = StringUtils.split(commandCall, null);
						for (int i = 1; i < _commandCall.length; i++) {
							String parameter = _commandCall[i];
							log.debug("parameter="+parameter+"\n");
							if (parameter.toLowerCase().startsWith("-path")) {
								//currentPath = (StringUtils.split(parameter, "="))[1];
								currentPath = (StringUtils.substringBetween(parameter, "\""));
							}
							else if (parameter.toLowerCase().startsWith("-name")) {
								//spaceName = (StringUtils.split(parameter, "="))[1];
								spaceName = (StringUtils.substringBetween(parameter, "\""));
							}
							else if (parameter.toLowerCase().startsWith("-ldapattribute")) {
								//spaceLDAPAttribute = (StringUtils.split(parameter, "="))[1];
								spaceLDAPAttribute = (StringUtils.substringBetween(parameter, "\""));
							}
							else if (parameter.toLowerCase().startsWith("-ldap")) {
								//spaceLDAPFilter = (StringUtils.split(parameter, "="))[1];
								spaceLDAPFilter = (StringUtils.substringBetween(parameter, "\""));
							}
							else if (parameter.toLowerCase().startsWith("-templatefile")) {
								//spacePatternFilePath = (StringUtils.split(parameter, "="))[1];
								spacePatternFilePath = (StringUtils.substringBetween(parameter, "\""));
							}
							else if (parameter.toLowerCase().startsWith("-regexpseparator")) {
								//spaceRegexpSeparator = (StringUtils.split(parameter, "="))[1];
								spaceRegexpSeparator = (StringUtils.substringBetween(parameter, "\""));
							}
							else if (parameter.toLowerCase().startsWith("-regexp")) {
								//spaceRegexp = (StringUtils.split(parameter, "="))[1];
								spaceRegexp = (StringUtils.substringBetween(parameter, "\""));
							}
							else if (parameter.toLowerCase().startsWith("-forcesetproperties")) {
								//spaceRegexp = (StringUtils.split(parameter, "="))[1];
								forceSetProperties = (StringUtils.substringBetween(parameter, "\""));
							}
						}
						log.debug("currentPath="+currentPath+"\n");
						log.debug("spaceName="+spaceName+"\n");
						log.debug("spaceLDAPFilter="+spaceLDAPFilter+"\n");
						log.debug("spaceLDAPAttribute="+spaceLDAPAttribute+"\n");
						log.debug("spacePatternFilePath="+spacePatternFilePath+"\n");
						log.debug("spaceRegexp="+spaceRegexp+"\n");
						log.debug("spaceRegexpSeparator="+spaceRegexpSeparator+"\n");
						log.debug("forceSetProperties="+forceSetProperties+"\n");
						createSpaceAction.execute();
						spaceName = null;
						spaceLDAPAttribute = null;
						spaceLDAPFilter = null;
						spacePatternFilePath = null;
						spaceRegexpSeparator = null;
						spaceRegexp = null;
						forceSetProperties = null;
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_QUIT)) {
						log.info("Good bye !\n");
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_DISPLAY_RESOURCE_INFO)) {
						childrenDepth = 0;
						getTreeQuotaInformationAction.execute();
					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_DISPLAY_RESOURCE_INFO.toLowerCase())) {
						if ((commandCall.split(" ")).length != 2) {
							log.info("Wrong number of parameters !\n");
							commandCall = COM_CALL_DISPLAY_RESOURCE_INFO;
						} else {
							String _childrenDepth;
							_childrenDepth = commandCall.substring(COM_CALL_DISPLAY_RESOURCE_INFO.length());
							_childrenDepth = _childrenDepth.trim();
							if (!_childrenDepth.matches("[0-9]+")) _childrenDepth = "0";
							childrenDepth = Integer.valueOf(_childrenDepth).intValue();
							getTreeQuotaInformationAction.execute();
						}
					}
//					else if (commandCall.equalsIgnoreCase(COM_CALL_CHANGE_DIRECTORY)) {
//						commandCall = COM_CALL_CHANGE_DIRECTORY;
//						
//						log.debug("currentPath="+currentPath+"\n");
//						log.debug("newPath="+newPath+"\n");
//						if (!newPath.startsWith("/")) {
//							if (newPath.equalsIgnoreCase("..")) {
//								newPath = CommonUtils.getParentUri(currentPath);
//							}
//							else if (currentPath.equalsIgnoreCase("/")) {
//								newPath = currentPath+newPath;
//							}
//							else {
//								newPath = currentPath+"/"+newPath;
//							}
//						}
//						log.debug("newPath="+newPath+"\n");
//						cdAction.execute();
//					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_CHANGE_DIRECTORY.toLowerCase())){
						if ((commandCall.split(" ")).length < 2) {
							log.info("Wrong number of parameters !\n");
							commandCall = COM_CALL_CHANGE_DIRECTORY;
						} 
						else {
							newPath = commandCall.substring(COM_CALL_CHANGE_DIRECTORY.length());
							newPath = newPath.trim();
							log.debug("newPath="+newPath+"\n");
							
							if (!newPath.startsWith("/")) {
								if (newPath.equalsIgnoreCase("..")) {
									newPath = CommonUtils.getParentUri(currentPath);
								}
								else if (currentPath.equalsIgnoreCase("/")) {
									newPath = currentPath+newPath;
								}
								else {
									newPath = currentPath+"/"+newPath;
								}
							}
							log.debug("newPath="+newPath+"\n");
							cdAction.execute();
						}
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_CREATE_NEWDIR)) {
						log.info("Wrong number of parameters !\n");
						commandCall = COM_CALL_CREATE_NEWDIR;
					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_CREATE_NEWDIR.toLowerCase())) {
						if ((commandCall.split(" ")).length < 2) {
							log.info("Wrong number of parameters !\n");
							commandCall = COM_CALL_CREATE_NEWDIR;
						} else {
							newPath = commandCall.substring(COM_CALL_CREATE_NEWDIR.length());
							newPath = newPath.trim();
							
							log.debug("currentPath="+currentPath+"\n");
							log.debug("newPath="+newPath+"\n");
							if (!newPath.startsWith("/")) {
								if (newPath.equalsIgnoreCase("..")) {
									newPath = CommonUtils.getParentUri(currentPath);
								}
								else if (currentPath.equalsIgnoreCase("/")) {
									newPath = currentPath+newPath;
								}
								else {
									newPath = currentPath+"/"+newPath;
								}
							}
							log.debug("newPath="+newPath+"\n");
							mkdirAction.execute();
						}

					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_DELETE_DIR)) {
						log.info("Wrong number of parameters !\n");
						commandCall = COM_CALL_DELETE_DIR;
					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_DELETE_DIR.toLowerCase())) {
//						if ((commandCall.split(" ")).length > 3 || (commandCall.split(" ")).length < 2) {
//							log.info("Wrong number of parameters !\n");
//							commandCall = COM_CALL_DELETE_DIR;
//						} else {
						if ((commandCall.split(" ")).length < 2) {
							log.info("Wrong number of parameters !\n");
							commandCall = COM_CALL_DELETE_DIR;
						} else {
						newPath = commandCall.substring(COM_CALL_DELETE_DIR.length());
						newPath = newPath.trim();
						
						boolean forceDeletion = false;
						
						if (newPath.split(" ")[0] != null && newPath.split(" ")[0].equalsIgnoreCase("-f")) {
							forceDeletion = true;
							newPath = newPath.split(" ")[1];
						}// if (newPath.split("")[0] != null...
						
						log.debug("currentPath="+currentPath+"\n");
						log.debug("newPath="+newPath+"\n");
						if (!newPath.startsWith("/")) {
							if (newPath.equalsIgnoreCase("..")) {
								newPath = CommonUtils.getParentUri(currentPath);
							}
							else if (currentPath.equalsIgnoreCase("/")) {
								newPath = currentPath+newPath;
							}
							else {
								newPath = currentPath+"/"+newPath;
							}
						}
						log.debug("newPath="+newPath+"\n");
						
						if (forceDeletion) {
							rmAction.execute();
						}// if (forceDeletion)
						else {
							String confirmDeletion = "";
							while (!confirmDeletion.equals("y") && !confirmDeletion.equals("n")) {
								log.info("Are you sure ? (y/n):\n");
								confirmDeletion = stdin.readLine();
							}// while (!tmp.equals("y") || !tmp.equals("n"))
							
							if (confirmDeletion.equals("y")) {
								rmAction.execute();
							} else {
								log.info("Directory not deleted\n");
							}
						}// else (forceDeletion)
						}
					}
					else if (commandCall.equalsIgnoreCase(COM_CALL_HELP)) {
						commandCall = COM_CALL_HELP;
						log.info(Help.getString(commandCall)+"\n");
					}
					else if (commandCall.toLowerCase().startsWith(COM_CALL_HELP.toLowerCase())) {
						if ((commandCall.split(" ")).length != 2) {
							log.info("Wrong number of parameters !\n");
							commandCall = COM_CALL_HELP;
						} else {
							commandCall = commandCall.substring(COM_CALL_HELP.length());
							commandCall = commandCall.trim();
							if (commandCall.equalsIgnoreCase(COM_CALL_FULL_HELP)) {
								for (int i = 0; i < FULL_COMMAND_LIST.length; i++) {
									log.info("->"+FULL_COMMAND_LIST[i]+"\n");
									//log.info("\t"+Help.getString(FULL_COMMAND_LIST[i]).replaceAll("", "\t"));
									log.info(Help.getString(FULL_COMMAND_LIST[i])+"\n");
								}// for (int i = 0; i < FULL_COMMAND_LIST.length; i++)
							}else {
								log.info(Help.getString(commandCall)+"\n");
							}// else (commandCall.equalsIgnoreCase(COM_CALL_FULL_HELP))
						}
					}
					
					log.debug("commandCall="+commandCall+"\n");
				} catch (NumberFormatException e) {
					log.error("NumberFormatException handled !");
					if (log.isDebugEnabled()) {
						e.printStackTrace();
					} else log.error(e.toString());
				} catch (IOException e) {
					log.error("IOException handled !");
					if (log.isDebugEnabled()) {
						e.printStackTrace();
					} else log.error(e.toString());
				} catch (Exception e) {
					log.error("Not expected exception handled !");
					if (log.isDebugEnabled()) {
						e.printStackTrace();
					} else log.error(e.toString());
				}
				
			}// while (commandNbr != COM_NBR_QUIT)
			
		}// run
	}// CLInterface
	
	public PWDServerManagerCL(Object args) throws ConfigurationException {
		super();
		currentPath = "/";
		
		File inputFile = new File(args.toString());
		if (args == null || args.equals("") || !inputFile.exists()) throw new ConfigurationException("Input file not given in parameter or file does not exist: "+args.toString());
		
		try {
			stdin = new CommentBufferedReader( new FileReader((String)args) );
		} catch (FileNotFoundException e) {
			if (log.isDebugEnabled()) {
				e.printStackTrace();
			} else log.error(e.toString());
		}
		cLInterface = new CLInterface();
	}// PQuotaManagerCL

	public PWDServerManagerCL() throws ConfigurationException {
		super();
		currentPath = "/";
		stdin = new CommentBufferedReader( new InputStreamReader( System.in ) );
		cLInterface = new CLInterface();
	}// PWDServerManagerCL
	
	public void displayQuotaAvailableBytes(long quotaAvailableBytes) {
		log.info("quotaAvailableBytes="+quotaAvailableBytes+"\n");
	}// displayQuotaAvailableBytes

	public String getCurrentPath() {
		return currentPath;
	}// getCurrentPath

	public void startInterface() {
		cLInterface.run();
	}// startInterface

	public void displayQuotaUsedBytes(long quotaUsedBytes) {
		log.info("quotaUsedBytes="+quotaUsedBytes+"\n");
	}// displayQuotaUsedBytes

	public void displayActionResult(String actionResult) {
		log.info(actionResult+"\n");
	}

	public int getChildrenDepth() {
		//if (childrenDepth <= 0) childrenDepth = 1;
		return childrenDepth;
	}

	public boolean getChildrenProcessFiles() {
		return false;
	}

	public boolean getTreeQuotaInformationProcessFiles() {
		return false;
	}

	public long getNewQuotaAvailableBytes() {
		return newQuotaAvailableBytes;
	}

	public long getNewQuotaUsedBytes() {
		return newQuotaUsebBytes;
	}

	public boolean getPatchQuotaUsedBytesOverwrite() {
		return true;
	}

	public boolean getNewVirtualRoot() {
		return newVirtualRoot;
	}

	public boolean getRemoveQuotaProcessChildren() {
		return removeQuotaProcessChildren;
	}

	public boolean getSetQuotaCalculateQuotaUsedBytes() {
		return calculateQuotaUsedBytes;
	}

	public void displayChildren(String children) {
		log.debug("displayChildren="+children+"\n");
		Enumeration _children = CommonUtils.convertStringToEnumeration(children, ":");
		while (_children.hasMoreElements()) {
			String child = (String) _children.nextElement();
			child = child.substring(child.lastIndexOf("/")+1);
			log.info("\t"+child+"\n");
		}
	}

	public void displayVirtualRoot(boolean virtualRoot) {
		log.info("virtualRoot="+virtualRoot+"\n");
	}

	public void displayNumberLDAPEntries(int displayNumberLDAPEntries) {
		log.info("number of LDAP entries="+displayNumberLDAPEntries+"\n");
	}

	public String getWebServiceURL() {
		return webServiceURL;
	}

	public String getConnectPassword() {
		return connectPassword;
	}

	public String getConnectUserName() {
		return connectUserName;
	}

	public String getWebdavServerURL() {
		return webdavServerURL;
	}

	public void displayCd(String path) {
		currentPath = path;
	}
	
	public void displayExist(boolean exist) {
		resourceExists = exist;
	}
	
	public String getNewPath() {
		return newPath;
	}

	public String getLdapUrl() {
		return ldapURL;
	}

	public String getLdapPort() {
		return ldapPort;
	}

	public String getLdapBaseDn() {
		return ldapBaseDN;
	}

	public String getLdapPrincipal() {
		return ldapPrincipal;
	}

	public String getLdapCredential() {
		return ldapCredential;
	}

	public String getLdapUserUidAttribut() {
		return ldapUIDAttribut;
	}

	public String getLdapMaxResults() {
		return ldapMaxResult;
	}

	public String get_ldapScope() {
		return ldapScope;
	}

	public String getDirectoriesStructureHashType() {
		return homedirHashType;
	}

	public String getHomedirRoot() {
		return currentPath;
	}

	public String getUsersPath() {
		return webdavUsersPath;
	}

	public String getRolesPath() {
		return webdavRolesPath;
	}

	public String getLocalRolesPath() {
		return webdavLocalRolesPath;
	}

	public String getUportalRolesPath() {
		return webdavUPortalRolesPath;
	}

	public String getHomedirLdapFilter() {
		return homedirLDAPFilter;
	}

	public String getInjacAdmin() {
		return injacAdmin;
	}

	public String getInjacSpaceName() {
		return injacSpaceName;
	}

	public String getInjacChannelAccount() {
		return injacChannelAccount;
	}

	public String getSpaceLDAPAttribute() {
		return spaceLDAPAttribute;
	}

	public String getSpaceLDAPFilter() {
		return spaceLDAPFilter;
	}

	public String getSpaceName() {
		return spaceName;
	}

	public String getSpacePatternFilePath() {
		return spacePatternFilePath;
	}

	public String getSpaceRegexp() {
		return spaceRegexp;
	}

	public String getSpaceRegexpSeparator() {
		return spaceRegexpSeparator;
	}

	public String getForceSetProperties() {
		return forceSetProperties;
	}

}
