/*
 * $Header: /home/cvs/jakarta-slide/src/stores/org/apache/slide/store/txfile/XMLResourceDescriptor.java,v 1.15 2004/07/28 09:33:56 ib Exp $
 * $Revision: 1.15 $
 * $Date: 2004/07/28 09:33:56 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.esupportail.webdavserver.store.txhashfile;

import org.apache.commons.transaction.file.ResourceIdToPathMapper;
import org.apache.slide.util.logger.Logger;

/**
 * XML descriptor as a resource in a {@link FileResourceManager}. 
 * 
 * @see FileResourceManager
 * @see TxXMLFileDescriptorsStore
 */
public class HashIdMapper implements ResourceIdToPathMapper {
    private static String hashMethod = null;
    private static String storeRoot = null;
    protected static final String HASH_METHOD_HASH = "hash";
    protected static final String HASH_METHOD_HASH_REVERSE = "hash_reverse";
    private Logger Log = null;
    private static String LOGGER_CHANNEL = "org.apache.slide.store.txhashfile.HashIdMapper";
    
    public void init(String hm,String sr,Logger l){
        hashMethod = hm;
        storeRoot = sr;
        Log = l;
        
        Log.log(
                "HashIdMapper : hashMetod " + hashMethod + ", storeRoot " + storeRoot,
                LOGGER_CHANNEL,
                Logger.DEBUG);        
    }
    
    public String getPathForId(Object resourceId) {
        String path = resourceId.toString();
        
        if(path.matches("^/"+storeRoot+"\\"+XMLResourceDescriptor.PATH_EXTENSION)){
            Log.log(
                    "HashIdMapper :No hashing to do on :"+path,
                    LOGGER_CHANNEL,
                    Logger.DEBUG); 
            return path;
        }
        
        Log.log(
                "HashIdMapper : path at start :"+path,
                LOGGER_CHANNEL,
                Logger.DEBUG); 
        String endTmp = path.replaceAll("^/"+storeRoot+"/","");
        
        if (hashMethod.equals(HASH_METHOD_HASH)) {            
            String newEndTmp = ""+endTmp.charAt(0);
            newEndTmp += "/"+endTmp.charAt(0)+endTmp.charAt(1);
            newEndTmp += "/"+endTmp.substring(0);
            
            path= "/"+storeRoot+"/" + newEndTmp;
             
        } else if (hashMethod.equals(HASH_METHOD_HASH_REVERSE)) {
            String newEndTmp = ""+endTmp.charAt(endTmp.length() - 1);
            newEndTmp += "/"+endTmp.charAt(endTmp.length() - 1)+endTmp.charAt(endTmp.length() - 2);
            newEndTmp += "/"+endTmp.substring(0);
            
            path= "/"+storeRoot+"/" + newEndTmp;                                  
        } else {
            Log.log(
                    "HashIdMapper : unknow  hashMethod :"+hashMethod,
                    LOGGER_CHANNEL,
                    Logger.ERROR);             
        }
        
        Log.log(
                "HashIdMapper : path at end (hash) :"+path,
                LOGGER_CHANNEL,
                Logger.DEBUG); 
        return path;
    }

   
}
