/**
 * @author Thomas Bellembois
 * @version
 * 
 * Creation date : 21 juil. 2005
 * Last modification :
 */
package fr.univrennes1.cri.util.commonUtils;

import java.util.Enumeration;
import java.util.Vector;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonUtils {
	
	public static Enumeration convertStringToEnumeration (String stringToConvert, String separator) {
		
		Vector result = new Vector();
		
		if (stringToConvert.startsWith(separator)) stringToConvert = stringToConvert.substring(1);
		if (stringToConvert.endsWith(separator)) stringToConvert = stringToConvert.substring(0, stringToConvert.length()-1);
		
		String [] splitResult = stringToConvert.split(separator);
		
		for (int i = 0; i < splitResult.length; i++) {
			result.add(splitResult[i]);
		}// for (int i = 0; i < splitResult.length; i++)
		
		return result.elements();
		
	}// convertStringToEnumeration
	
	public static String getPackageAbsolutePath(Object myObject) {
		
		String objectAbsolutePath = myObject.getClass().getResource( "." ).getPath().toString();
		String objectPackageName = myObject.getClass().getPackage().getName().toString();
		String objectPackageFirstDirectory = StringUtils.substringBefore(objectPackageName, ".");
		String packageAbsolutePath = StringUtils.substringBeforeLast(objectAbsolutePath ,objectPackageFirstDirectory);
		packageAbsolutePath = StringUtils.removeEnd(packageAbsolutePath, "/");
		return packageAbsolutePath;
		
	}// getPackageAbsolutePath
	
	/**
	 * Get the parent uri of an uri
	 * @param uri to process
	 * @return the parent uri
	 */
	public static String getParentUri (String uri) {
		int indexLastSlash = uri.lastIndexOf("/");
		if (indexLastSlash == -1) return null;
		else if (indexLastSlash == 0) return "/";
		else return uri.substring(0, indexLastSlash);	
	}// getParentUri
	
	/**
	 * Get a resource name from an URI
	 * @param uri to process
	 * @return the parent uri
	 */
	public static String getResourceName (String uri) {
		int indexLastSlash = uri.lastIndexOf("/");
		if (indexLastSlash == -1) return null;
		else if (indexLastSlash == 0) return "/";
		else return uri.substring(indexLastSlash+1);	
	}// getParentUri
	
	/**
	 * Convert an array into a String
	 * @param array the array to convert
	 * @param separator the separator used to separate each element of the array in the result string
	 * @return a String
	 */
	public static String convertArrayToString (Object[] array, String separator) {
		String result = "";
		for (int i = 0; i < array.length; i++) {
			result = result + array[i].toString()+separator;
		}// for (int i = 0; i < array.length; i++)
		return result;
	}
	
	/**
	 * Convert an Enumeration into a Vector
	 * @param enumeration the Enumeration to convert
	 * @return a Vector
	 */
	public static Vector convertEnumerationToVector (Enumeration enumeration) {
		Vector result = new Vector();
		while (enumeration.hasMoreElements()) {
			Object element = (Object) enumeration.nextElement();
			result.add(element);
		}// while (enumeration.hasMoreElements())
		return result;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// build a group path like : groupA/subGroupA/subSubGroupA with a vector containing groupA|subGroupA|subSubGroupA
	//
	public static String buildGroupHierarchy(Vector group){
		
		// return a new String if the parameter is null
		if (group == null) return new String();
		
		Enumeration enum = group.elements();
		StringBuffer result = new StringBuffer();
		
		// building the result - separating each element of the enumeration with a '/' with no '/' at the end of the String
		String nextElement = (String)enum.nextElement();
		while (nextElement != null) {
			result.append(nextElement);
			if(enum.hasMoreElements()){
				nextElement = (String)enum.nextElement();
				result.append("/"); //no '/' at the end of the String
			}// if(enum.hasMoreElements())
			else  nextElement = null;
		}// while (enum.hasMoreElements())
		
		return result.toString();
		
	}// buildGroupHierarchy
	
	
	////////////////////////////////////////////
	// convert a Vector of Strings into a String
	//
	public static String convertVectorIntoString(Vector v){
		
		if (v == null) return new String("");
		
		StringBuffer result = new StringBuffer();
		Enumeration enum = v.elements();
		
		String nextElement;
		if (enum.hasMoreElements()) nextElement = (String)enum.nextElement();
		else return new String("");
		
		while (nextElement != null) {
			result.append(nextElement);
			if(enum.hasMoreElements()){
				nextElement = (String)enum.nextElement();
				result.append("|"); //no '|' at the end of the String
			}// if(enum.hasMoreElements())
			else  nextElement = null;
		}// while (enum.hasMoreElements())
		
		return result.toString();
		
	}// convertVectorIntoString
	
	///////////////////////////////////////////////////////
	// convert a Vector of Vectors of Strings into a String
	//
	public static String convertVectorOfVectorIntoString(Vector v){
		
		if (v == null) {
			return new String("");
		}
		
		StringBuffer result = new StringBuffer();
		Enumeration enum = v.elements();
		
		Vector nextElement;
		if (enum.hasMoreElements())	nextElement = (Vector)enum.nextElement();
		else {
			return new String("");	
		}
		
		while (nextElement != null) {
			
			Enumeration enum2 = nextElement.elements();
		
			String nextElement2 = (String)enum2.nextElement();
			while (nextElement2 != null) {
				result.append(nextElement2);
				if(enum2.hasMoreElements()){
					nextElement2 = (String)enum2.nextElement();
					result.append("|"); //no '|' at the end of the String
				}// if(enum.hasMoreElements())
				else  nextElement2 = null;
			}// while (enum.hasMoreElements())
		
			if (enum.hasMoreElements()){
				nextElement = (Vector) enum.nextElement();
				result.append(" - ");
			}
			else nextElement = null;
				
		}// while (enum.hasMoreElements())
		
		return result.toString();
		
	}// convertVectorIntoString
}
