/**
 * @author Thomas Bellembois
 * @version 1.0
 *
 * An _LDAPEntry represents an LDAP entry. It is made of a name (String) and a list of attributes (Vector of _LDAPAttributes)<br/>
 *  
 * Creation date : 22 nov. 2005
 * Last modification :
 */
package fr.univrennes1.cri.util.ldapUtils;

import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class ESUP_LDAPEntry {
	
	private String dn;
	private ESUP_LDAPAttributes attributes;
	
	private Log log;
	
	public ESUP_LDAPEntry(String dn, ESUP_LDAPAttributes attributes) {
		log = LogFactory.getLog(getClass().getName());
		this.dn = dn;
		this.attributes = attributes;
	}// _LDAPEntry
	
	public ESUP_LDAPEntry(String dn) {
		log = LogFactory.getLog(getClass().getName());
		this.dn = dn;
		attributes = new ESUP_LDAPAttributes();
	}// _LDAPEntry
	
	/**
	 * Adds a new attribut with its values
	 * @param name the attribut name
	 * @param values the attribut values
	 */
	public void addAttribute(String name, Vector values) {
		log.debug("addAttribute:name="+name);
		attributes.addLDAPAttribute(name, values);
	}// addAttribute
			
	/**
	 * @return Returns the attributes as a _LDAPAttributes
	 */
	public ESUP_LDAPAttributes getAttributes() {
		return attributes;
	}// getAttributes
	
	/**
	 * Return the attribute
	 * @param attributeName attribute to return
	 * @return
	 */
	public ESUP_LDAPAttribute getLdapAttribute(String attributeName) {
		return attributes.getLdapAttribute(attributeName);
	}// getLdapAttribute
	
	/**
	 * Returns a String representation of the entry
	 */
	public String toString() {
		return dn+" > "+attributes.toString();
	}// toString

}//LdapEntry
