/*
* $Header: /home/cvs/jakarta-slide/projector/src/java/org/apache/slide/projector/expression/ExpressionFactory.java,v 1.2 2004/07/28 09:48:21 ib Exp $
* $Revision: 1.2 $
* $Date: 2004/07/28 09:48:21 $
*
* ====================================================================
*
* Copyright 1999-2002 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
*/

package org.apache.slide.projector.expression;

import java.util.Iterator;

import org.jdom.Element;

/**
 * The ConditionParser class
 * 
 */
public class ExpressionFactory {
    public static Expression create(Element element) {
    	String name = element.getName();
    	Expression expression = null;
    	if ( name.equals("and") ) {
            expression = new AndExpression();
        } else if ( name.equals("or") ) {
            expression = new OrExpression();
        } else if ( name.equals("true") ) {
            expression = new TrueExpression();
        } else if ( name.equals("event") ) {
            String method = element.getAttributeValue("method");
            expression = new EventExpression(method);
        	for ( Iterator i = element.getChildren().iterator(); i.hasNext(); ) {
        		Element child = (Element)i.next();
        		String key = child.getAttributeValue("key");
        		String value = child.getAttributeValue("value");
        		((EventExpression)expression).addProperty(key, value);
        	}
        }
        if ( expression instanceof EnclosingExpression ) {
        	for ( Iterator i = element.getChildren().iterator(); i.hasNext(); ) {
        		Element child = (Element)i.next();
        		Expression nestedExpression = create(child);
        		((EnclosingExpression)expression).addExpression(nestedExpression);
        	}
        }
        return expression;
    }
}