/*
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.projector.store;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

import org.apache.slide.projector.Store;

public class RequestParameterStore implements Store {
    protected HttpServletRequest request;

    public RequestParameterStore(HttpServletRequest request) {
        this.request = request;
    }

    public void put(String key, Object value, long timeout) throws IOException {
        throw new IOException("Put operation is not supported by request-parameter store!");
    }

    public void put(String key, Object value) throws IOException {
        throw new IOException("Put operation is not supported by request-parameter store!");
    }

    public Object get(String key) {
        return request.getParameterValues(key);
    }

    public void dispose(String key) throws IOException {
        throw new IOException("Dispose operation is not supported by request-parameter store!");
    }
}