/*
 * $Header: /home/cvs/jakarta-slide/src/share/org/apache/slide/common/UnknownObjectClassException.java,v 1.6 2004/07/28 09:38:09 ib Exp $
 * $Revision: 1.6 $
 * $Date: 2004/07/28 09:38:09 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */ 

package org.apache.slide.common;

import org.apache.slide.util.Messages;

/**
 * Unknown object class.
 * 
 * @version $Revision: 1.6 $
 */
public class UnknownObjectClassException extends SlideException {
    
    
    // ----------------------------------------------------------- Constructors
    
    
    /**
     * Constructor.
     * 
     * @param className Name of the unknown object class
     */
    public UnknownObjectClassException(String className) {
        super(Messages.format(UnknownObjectClassException.class.getName(), 
                              className));
    }
    
}
