/*
 * $Header: /home/cvs/jakarta-slide/src/share/org/apache/slide/extractor/AbstractContentExtractor.java,v 1.3.2.2 2004/09/29 15:11:38 unico Exp $
 * $Revision: 1.3.2.2 $
 * $Date: 2004/09/29 15:11:38 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.extractor;

import java.io.InputStream;
import java.io.Reader;

/**
 * The AbstractPropertyExtractor class
 */
public abstract class AbstractContentExtractor implements ContentExtractor {

    private String contentType;
    private String uri;
    private String namespace;

    public AbstractContentExtractor(String uri, String contentType) {
        this(uri, contentType, null);
    }

    public AbstractContentExtractor(String uri, String contentType, String namespace) {
        this.contentType = contentType;
        this.uri = uri;
        this.namespace = namespace;
    }

    public abstract Reader extract(InputStream content) throws ExtractorException;

    public String getContentType() {
        return contentType;
    }

    public String getUri() {
        return uri;
    }
    
    public String getNamespace() {
        return namespace;
    }

}
