/*
 * $Header: /home/cvs/jakarta-slide/src/share/org/apache/slide/structure/ObjectAlreadyExistsException.java,v 1.7 2004/07/28 09:34:35 ib Exp $
 * $Revision: 1.7 $
 * $Date: 2004/07/28 09:34:35 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */ 

package org.apache.slide.structure;

import org.apache.slide.util.Messages;

/**
 * Object already exists.
 * 
 * @version $Revision: 1.7 $
 */
public class ObjectAlreadyExistsException extends StructureException {
    
    
    // ----------------------------------------------------------- Constructors
    
    
    /**
     * Constructor.
     * 
     * @param objectUri Object Uri
     */
    public ObjectAlreadyExistsException(String objectUri) {
        super(Messages.format(ObjectAlreadyExistsException.class.getName(), 
                              objectUri));
        this.objectUri = objectUri;
    }
    
    
    // ----------------------------------------------------- Instance Variables
    
    
    /**
     * Object Uri.
     */
    private String objectUri;
    
    
    // ------------------------------------------------------------- Properties
    
    
    /**
     * Object Uri accessor.
     * 
     * @return String object Uri
     */
    public String getObjectUri() {
        if (objectUri == null) {
            return new String();
        } else {
            return objectUri;
        }
    }
    
}
